<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db
 */
/**
 * @file S2DaoManager.php
 * @brief s2dao manager
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: S2DaoManager.php 14 2007-07-18 14:55:12Z ishitoya $
 */

require_once("ficus/config/Registry.php");

/**
 * @class S2DaoManager
 */
class Ficus_S2DaoManager{
    /**
     * dao object
     */
    protected $dao = null;

    /**
     * set dao
     * @param $target string target entity name
     */
    public function setTarget($target){
        $this->dao =
            Ficus_S2DaoComponentFactory::getModelFactory()->getDao($target);
    }
    
    /**
     * get Entity
     * @param $id id
     */
    public function getSingleEntity($id){
        $entity = $this->dao->getById($id);
        if($entity->isEmpty()){
            return null;
        }
        return $entity->get(0);
    }

    /**
     * get Entities
     * @param $ids array id list
     * @return S2Dao_ArrayList 
     */
    public function getEntities($ids){
        $entities = new S2Dao_ArrayList();
        foreach($ids as $id){
            if(is_int($id)){
                $entities->append($this->getSingleEntity($id));
            }
        }
        if($entities->isEmpty()){
            throw new Ficus_IllegalArgumentException("no entities related with ids");
        }
        return $entities;
    }

    /**
     * get Pager entities
     */
    public function getPagerDto($offset = 0, $limit = 10){ 
        $dto = $this->dao->dto();
        $dto->setOffset($offset);
        $dto->setLimit($limit);

        return $dto;
    }

    /**
     * deserializeEntity
     */
    public function deserializeEntity($data){
        $entity = $this->dao->entity();
        $deserializer = new Ficus_S2DaoArrayEntityDeserializer();
        $entity->deserialize($data, $deserializer);

        return $entity;
    }

    /**
     * get dao
     */
    public function dao(){
        return $this->dao;
    }

    /**
     * entity
     */
    public function entity(){
        return $this->dao->entity();
    }
}
?>
