<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.crypto
 */
/**
 * @file KeyGenerator.php
 * @brief key generator interface
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: KeyGenerator.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * generator factory class
 */

require_once "ficus/crypto/CryptoConstants.php";
require_once "ficus/lang/ClassLoader.php";
require_once "ficus/exception/AlgorithmNotFoundException.php";

/**
 * @abstract Ficus_KeyGenerator
 */
abstract class Ficus_KeyGenerator implements Ficus_CryptoConstants
{
    const SIGNATURE = "ficus.crypto.Ficus_%sKeyGenerator";

    /**
     * get instance
     * @param $algorithm string algorithm
     * @return Ficus_KeyGenerator instance
     */
    public static function getInstance($algorithm){
        $classname = sprintf(self::SIGNATURE, $algorithm);
        try{
            $generator = Ficus_ClassLoader::load($classname);
            return $generator;
        }catch(Exception $e){
            throw new Ficus_AlgorithmNotFoundException($e->getMessage(), $e);
        }
    }
        
    /**
     * Generate key
     * @return Ficus_Key generated key
     */
    public abstract function generate();
}
?>
