<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.crypto
 */
/**
 * @file HMACSHA1Cipher.php
 * @brief cipher class
 * @author <a href="mailto:"></a>
 * @version $Id: HMACSHA1Cipher.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * cipher class
 */

require_once "ficus/crypto/Cipher.php";
require_once "ficus/exception/NotSupportedException.php";
require_once "ficus/lang/Bytes.php";

/**
 * @class Ficus_HMACSHA1Cipher
 */
class Ficus_HMACSHA1Cipher extends Ficus_Cipher
{
    const PADDING_KEY = 0x00;
    const PADDING_INNER = 0x36;
    const PADDING_OUTER = 0x5C;
    const KEY_LENGTH = 64;

    /**
     * ipad
     */
    protected $ipad = null;
    
    /**
     * opad
     */
    protected $opad = null;
    /**
     *
     */
    public function __construct(){
        $bytes = new Ficus_Bytes();
        $this->ipad = $bytes->fill(self::KEY_LENGTH, self::PADDING_INNER);
        $this->opad = $bytes->fill(self::KEY_LENGTH, self::PADDING_OUTER);
    }
    
    /**
     * crypt data with key
     * @param $data string data to crypt
     * @param $key Ficus_Key to use cryption
     * @return crypted data
     */
    public function encrypt($data, $key){
        if(is_string($key)){
            $key = new Ficus_Key(self::DIGEST_SHA1, $key);
        }
        
        $key = new Ficus_Bytes($key->getEncoded());
        $key = $key->padding(self::KEY_LENGTH, self::PADDING_KEY);
        $inner = $key->xorWith($this->ipad);
        $inner = sha1($inner . $data);
        $outer = $key->xorWith($this->opad);
        $outer = sha1($outer . $inner);
        return $outer;
    }

    /**
     * decrypt data from crypted data.
     * @param $data string crypted data
     * @param $key Ficus_Key to use decrypt
     * @return decripted data
     */
    public function decrypt($data, $key){
        throw new Ficus_NotSupportedException("HMACSHA1Ciper is not able to decrypt.");
    }
}
?>
