<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.ffmpeg
 */
/**
 * @file FFMpegVideoInfo.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: FFMpegVideoInfo.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes ffmpeg abstract class
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/ffmpeg/FFMpeg.php");
require_once("ficus/media/video/VideoBean.php");
require_once("ficus/media/audio/AudioBean.php");


/**
 * @class Ficus_FFMpegVideoInfo
 */
class Ficus_FFMpegVideoInfo extends Ficus_FFMpeg
{
    /**
     * video bean
     */
    protected $video = null;

    /**
     * audio bean
     */
    protected $audio = null;
    

    /**
     * process result
     * @return boolean true if no error
     */
    protected function processResult(){
        $result = $this->getErrorStream();
        if(preg_match('/Duration: (.*?), start: (.*?), bitrate: (.*?) .*?Video: (.*?), (.*?), (.*?)x(.*?), (.*?) /ms', $result, $regs)){
            $video = new Ficus_VideoBean();
            $audio = new Ficus_AudioBean();
            $video->setFilename($this->filename);
            $audio->setFilename($this->filename);

            $length = $this->calcLength($this->getTrimmed($regs, 1));
            $video->setLength($length);
            $video->setBitrate($this->getTrimmed($regs, 2));
            $video->setCodec($this->getTrimmed($regs, 4));
            $video->setColor($this->getTrimmed($regs, 5));
            $video->setWidth($this->getTrimmed($regs, 6));
            $video->setHeight($this->getTrimmed($regs, 7));
            $video->setFps($this->getTrimmed($regs, 8));
            $this->video = $video;

            if(preg_match('/Audio: (.*?), (.*?), (.*?), (.*?) /ms', $result, $regs)){

                $audio->setLength($length);
                $audio->setCodec($this->getTrimmed($regs, 1));
                $audio->setFrequency($this->getTrimmed($regs, 2));
                $audio->setMethod($this->getTrimmed($regs, 3));
                $audio->setBitrate($this->getTrimmed($regs, 4));
                $this->audio = $audio;
            }

            return true;
        }else{
            return false;
        }
    }
}
?>
