<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli
 */
/**
 * @file CommandLineCommandAnnotation.php
 * @brief command line application abstract class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: CommandLineCommandAnnotation.php 15 2007-07-18 15:02:48Z ishitoya $
 *
 * Command line application
 */


/**
 * @class Soya_CommandLineCommandAnnotation
 */
require_once "ficus/lang/reflect/ReflectionAnnotation.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/exception/IllegalAnnotationException.php";

class Soya_CommandLineCommandAnnotation extends Ficus_ReflectionAnnotation{
    private $short;
    private $long;
    private $isDefault;
    
    /**
     * constructor
     * @param $reflector object reflector object
     * @param $arguments string arguments written in annotation section
     */
    public function __construct($reflector, $arguments){
        parent::__construct($reflector, $arguments);
        $this->short = $arguments["short"];
        $this->long  = $arguments["long"];
        if(array_key_exists("default", $arguments)){
            $this->isDefault = $arguments["default"];
        }else{
            $this->idDefault = false;
        }
    }

    /**
     * get short name
     */
    public function getShort(){
        return $this->short;
    }

    /**
     * get long name
     */
    public function getLong(){
        return $this->long;
    }
    
    /**
     * isDefault
     */
    public function isDefault(){
        return $this->isDefault;
    }
}
?>
