<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.analyzer
 */
/**
 * @file ClassAnalyzeData.php
 * @brief ClassAnalyzeData of PHP.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ClassAnalyzeData.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Class Analyze data of PHP.
 */
require_once('ficus/lang/Arrays.php');
require_once('ficus/analyzer/AnalyzeData.php');
/**
 * @class Ficus_ClassAnalyzeData
 */
class Ficus_ClassAnalyzeData extends Ficus_AnalyzeData {
    /**
     * @var path.
     */
    protected $path;
    /**
     * @var Ficus_FunctionAnalyzeData in this class.
     */
    protected $functions = array();
    /**
     * Constructor.
     *
     * @param $path string of path.
     * @param $name string of name.
     */
    public function __construct($path, $name) { $this->path = $path; $this->name = $name; }
    /**
     * Get name.
     *
     * @return string of name.
     */
    public function getName() { return ($this->name != null) ? $this->name : '* NO_CLASS *'; }
    /**
     * Get path.
     *
     * @return string of path.
     */
    public function getPath() { return $this->path; }
    /**
     * Add function.
     *
     * @param $function Ficus_FunctionAnalyzeData.
     */
    public function addFunction($function) { $this->functions[] = $function; }
    /**
    * Get function analyze data by index.
     *
     * @param $index int index of Ficus_FunctionAnalyzeData.
     * @return Ficus_FunctionAnalyzeData.
     */
    public function getFunction($index) { return $this->functions[$index]; }
    /**
     * Get function analyze data.
     *
     * @return array of Ficus_FunctionAnalyzeData.
     */
    public function getFunctions() { return $this->functions; }
    /**
     * To string.
     *
     * @return string of this.
     */
    public function __toString() {
        $buf = "[" . $this->path . "]\n";
        $buf .= 'class ' . parent::__toString();
        $buf .= Ficus_Arrays::arrayToString($this->functions);
        return $buf;
    }
}
?>
