<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.XML
 */
/**
 * @file QName.php
 * @brief QName.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: QName.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once("ficus/lang/Assert.php");
require_once("ficus/lang/Types.php");
/**
 * @class Ficus_QName
 */
class Ficus_QName
{
    /**
     * namespace uri.
     */
    protected $uri = null;

    /**
     * localPart.
     */
    protected $localPart = null;

    /**
     * constructor.
     *
     * @param $uri string string of uri.
     * @param $localPart string string of localPart.
     */
    public function __construct($uri, $localPart) {
        Ficus_Assert::isPrimitiveType($uri, "string");
        Ficus_Assert::isPrimitiveType($localPart, "string");
        $this->uri = $uri;
        $this->localPart = $localPart;
    }

    /**
     * get uri namespace.
     *
     * @return String of uri.
     */
    public function uri() {
        return $this->uri;
    }

    /**
     * get uri namespace.
     *
     * @return String of namespace uri.
     */
    public function namespace() {
        return $this->uri;
    }

    /**
     * get localPart.
     *
     * @return String of localPart.
     */
    public function localPart() {
        return $this->localPart;
    }

    /**
     * get localName.
     *
     * @return String of localName.
     * @see Ficus_QName::localPart
     */
    public function localName() {
        return $this->localPart;
    }

    /**
     * get expanded name.
     *
     * @return String of qname.
     */
    public function expandedName() {
        return $this->uri . $this->localPart;
    }

    /**
     * compare qname.
     *
     * @param $qname Ficus_QName or string another qname.
     * @return int
     */
    public function compare($qname) {
        if (($cmp = strcmp($this->uri, $qname->uri)) == 0) {
            return strcmp($this->localPart, $qname->localPart);
        }
        return $cmp;
    }

    /**
     * equals qname.
     *
     * @param $qname Ficus_QName or string another qname.
     * @return boolean return true if equals else return false.
     */
    public function equals($qname) {
        return ($this->uri == $qname->uri)
            && ($this->localPart == $qname->localPart);
    }

    /**
     * QName toString.
     *
     * @return string of QName.
     */
    public function toString() {
        return $this->expandedName();
    }

    /**
     * QName toString.
     *
     * @return string of QName.
     */
    public function __toString() {
        return $this->expandedName();
    }

    /**
     * is Empty
     *
     * @return boolean return true if empty
     */
    public function isEmpty(){
        if(empty($this->uri) && empty($this->localPart)){
            return true;
        }
        return false;
    }
}
?>
