<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file RDFQName.php
 * @brief RDFQName.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: RDFQName.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once("ficus/XML/QName.php");
require_once("ficus/collection/UnicodeIterator.php");
/**
 * @class Soya_RDFQName
 */
class Ficus_RDFQName extends Ficus_QName
{
    /**
     * IS NCStartName?
     *
     * @param $unicode string unicode.
     * @return boolean is NCStartName?
     */
    private static function isNCStartName($unicode) {
        $ncNameChars = Ficus_XMLUtils::getNCNameStartChar();
        foreach ($ncNameChars as $charRange) {
            if ($charRange[0] <= $unicode && $unicode <= $charRange[1]) {
                return true;
            }
        }
        return false;
    }

    /**
     * IS NCName?
     *
     * @param $unicode string unicode.
     * @return boolean is NCName?
     */
    private static function isNCName($unicode) {
        $ncNameChars = Ficus_XMLUtils::getNCNameChar();
        foreach ($ncNameChars as $charRange) {
            if ($charRange[0] <= $unicode && $unicode <= $charRange[1]) {
                return true;
            }
        }
        return false;
    }

    /**
     * Split resource uri to namespace and local part.
     *
     * @param $nodeString string node string.
     * @return Ficus_QName resource qname.
     */
    public static function createByString($nodeString) {
        // Why does not reverse iterator exist in SPL?
        $rev = array();
        foreach (new Ficus_UnicodeIterator($nodeString) as $unicode) {
            $rev []= $unicode;
        }
        $rev = array_reverse($rev);

        // search NCStartName char and invalid char.
        foreach ($rev as $index => $unicode) {
            if (self::isNCStartName($unicode)) {
                $startCharPos = $index + 1;
            } else if (self::isNCName($unicode)) {
            } else {
                // invalid char before NCStartNameChar.
                break;
            }
        }

        if (isset($startCharPos)) {
            $pos = sizeof($rev) - $startCharPos;
            $ns = mb_substr($nodeString, 0, $pos);
            $local = mb_substr($nodeString, $pos);
        } else {
            $ns = $nodeString;
            $local = '';
        }

        return new Ficus_RDFQName($ns, $local);
    }
}
?>
