<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.validators
 */
/**
 * @file RequiredValidator.php
 * @brief RequiredValidator for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: RequiredValidator.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * validate parameter that is required
 */

require_once("ficus/validators/Validatable.php");
require_once("ficus/exception/ValidationException.php");

/**
 * @interface Ficus_RequiredValidator
 */
class Ficus_RequiredValidator implements Ficus_Validatable
{
	/**
	 * validate parameter
	 * parameter must not empty
	 * @param $param array parameter to validate
     * @throw Ficus_ValidationException invalidate.
	 */
	public function validate($param){
		if(empty($param["value"])){
			throw new Ficus_ValidationException("Parameter {$param['key']} is required : must exist and must not empty");
		}
	}
	
	/**
	 * get String form validator
	 * @return string definition of this validator
	 */
	public function __toString(){
		return "required";
	}
}
?>
