<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.validators
 */
/**
 * @file PerlRegexValidatable.php
 * @brief PerlRegexValidator for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: PerlRegexValidator.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * validate parameter that 
 */

require_once("ficus/exception/ValidationException.php");
require_once("ficus/exception/IllegalArgumentException.php");
/**
 * @interface Ficus_PerlRegexValidator
 */
class Ficus_PerlRegexValidator implements Ficus_RegexValidator
{
	/**
	 * @var $pattern string regular expression
	 */
	private $pattern = "";

	/**
	 * @var $errorIndicator boolean indicates regex error occurance
	 */
	private $errorIndicator = false;
	/**
	 * constructor
	 * @param $pattern string regular expression 
	 */
	public function __construct($pattern){
		$this->pattern($pattern);
	}
	
	/**
	 * validate parameter
	 * @param $param array parameter to validate
     * @throw Ficus_ValidationException invalidate.
	 */
	public function validate($param){
		set_error_handler(array($this, "errorHandler"));
		$result = preg_match($this->pattern, $param["value"]);
		restore_error_handler();
		if($this->errorIndicator || $result === 0){
			$this->errorIndicator = false;
            if(isset($param['key'])){
                throw new Ficus_ValidationException("Parameter {$param['key']} does not match pattern : {$this->pattern}");
            }else{
                throw new Ficus_ValidationException("Parameter index key was not exist");
            }
		}
	}

	/**
	 * error Handler for regex validator
     *
     * @param $errno string error number.
     * @param $errmsg string error message.
     * @param $filename string file name.
     * @param $linenum string line number.
     * @param $vars string vars.
	 */
	public function errorHandler($errno, $errmsg, $filename, $linenum, $vars){
		if($filename === __FILE__){
			$this->errorIndicator = true;
		}
	}

	/**
	 * set regular pattern
	 * @param $pattern string reqular expression
     * @throw Ficus_IllegalArgumentException pattern is empty.
	 */
	public function pattern($pattern){
		if(empty($pattern)){
			throw new Ficus_IllegalArgumentException("pattern is empty");
		}
		$this->pattern = $pattern;
	}

	/**
	 * get String form validator
	 * @return string definition of this validator
	 */
	public function __toString(){
		return "perlRegex('{$this->pattern}')";
	}
}
?>
