<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters.visitors
 */
/**
 * @file ParameterValidator.php
 * @brief ParameterValidator for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ParameterValidator.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * ParameterValidator.
 */

require_once("ficus/lang/Assert.php");
require_once("ficus/parameters/Parameter.php");
require_once("ficus/parameters/visitors/Acceptor.php");
require_once("ficus/parameters/visitors/Visitor.php");
require_once("ficus/validators/Validatable.php");
require_once("ficus/exception/IllegalTypeException.php");

/**
 * @class Ficus_ParameterValidator
 */
class Ficus_ParameterValidator extends Ficus_Visitor
{
	/*
	 * @var array array of parameters that passed to module
	 */
	private $parameters = array();

	/**
	 * constructor
     *
	 * @param $parameters array array of parameters to validate
	 */
	public function __construct($parameters){
		$this->setParameters($parameters);
	}
	
	/**
	 * visit parameters and validate
	 * @param $parameter Ficus_Acceptor validatables
	 */
	public function visit($parameter){
		Ficus_Assert::isInstanceOf($parameter, "Ficus_Acceptor");
		if($parameter instanceof Ficus_Validatable &&
		   $parameter instanceof Ficus_Parameter){
			$name = $parameter->name();
			
			if(array_key_exists($name, $this->parameters)){
				if(is_string($this->parameters[$name])){
                        $this->parameters[$name] = 
                                           trim($this->parameters[$name]);
                }
                $param = array("key"   => trim($name),
							   "value" => $this->parameters[$name]);
				$parameter->validate($param);
			}else{
				$parameter->validate(array("key"   => $name,
                                           "value" => null));
			}
			
			//check for child parameters
			if($parameter instanceof Ficus_ComplexParameter){
				$children = $parameter->getParameters();
				foreach($children as $child){
					if($child instanceof Ficus_Acceptor){
						$child->accept($this);
					}
				}
			}
		}
	}

	/**
	 * Set parameter.
     *
	 * @param $parameters array array of parameters that passed to module
     * @throw Ficus_IllegalTypeException no array argument.
	 */
	public function setParameters($parameters){
		if(is_array($parameters)){
			$this->parameters = $parameters;
		}else{
			throw new Ficus_IllegalTypeException("argument 1 must be array");
		}
	}
}
?>
