<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ScaffoldPages.php
 * @brief abstract buffered page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldPage.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/BufferedPage.php");

/**
 * @class Ficus_Page
 */
abstract class Ficus_ScaffoldPage extends Ficus_BufferedPage
implements Ficus_ScaffoldConstants{
    protected $manager = null;
    protected $target = null;
    protected $foreperson = null;

    /**
     * on called
     * @param $mode string name of mode
     * @param $args array of args of do method
     */
    protected function onDo($mode, $args){
        if(($action = $this->isScaffoldAction($mode))){
            $this->foreperson = strtolower($action);
            $action = $this->getScaffoldAction(self::ACTION_NEW);
            $this->setNextAction($action);
            $this->manager = new Ficus_ScaffoldManager($this);
        }
    }

    /**
     * exec scaffold
     */
    protected function buildScaffold(){
        $scaffold = $this->manager->organize();
        $this->assign(self::SMARTY_SCAFFOLD, $scaffold);
    }

    /**
     * on execute finished
     * @param $mode string name of mode
     * @param $args array of args of do method
     * @param $result mixed switch
     */
    protected function onDone($mode, $args, $result){
        if($this->isScaffoldAction($mode) &&
           $result == self::MODE_TEMPLATE){
            $mode = $this->foreperson;
            $this->buildScaffold();
        }
        parent::onDone($mode, $args, $result);
    }

    /**
     * do new
     */
    public function doScaffoldNew($args){
        $result = $this->dispatchScaffoldEvent($args);
        if(is_null($result)){
            return self::MODE_TEMPLATE;
        }
    }

    /**
     * get action
     */
    protected function getScaffoldAction($action){
        return self::ACTION_PREFIX . ucfirst($action);
    }

    /**
     * is scaffold action
     */
    protected function isScaffoldAction($mode){
        if(preg_match('/^' . self::ACTION_PREFIX . '(.*)$/', $mode, $regs)){
            return $regs[1];
        }
        return false;
    }

    /**
     * call event handler
     */
    protected function dispatchScaffoldEvent($args){
        $do = $this->manager->formBean()->do();
        $methodDefault = "onDoScaffold" . ucfirst($this->foreperson);
        $method = $methodDefault . ucfirst($do);
        if(method_exists($this, $method)){
            return $this->{$method}($args);
        }
        if(method_exists($this, $methodDefault)){
            return $this->{$methodDefault}($args);
        }
        return null;
    }
}
?>
