<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi
 */
/**
 * @file PukiWikiUtility.php
 * @brief access to pukiwiki
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PukiWikiUtility.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * access to pukiwiki
 */

/**
 * @class Ficus_PukiWikiUtility
 */
class Ficus_PukiWikiUtility
{
    const ENCODING_EUC = "EUC-JP";
    const WIKI_EXT = ".txt";
    
    /**
     * wiki encoding
     */
    private static $encoding = self::ENCODING_EUC;
    
    /**
     * get file name from page name
     * @param $pagename string name of the page
     * @return string page name
     */
    public static function getFileName($pagename){
        $pagename = mb_convert_encoding($pagename, self::$encoding,
                                        mb_detect_encoding($pagename));
        $pagename = strtoupper(bin2hex($pagename));
        return $pagename . self::WIKI_EXT;
    }

    /**
     * get page name from name
     * @param $name string name of the page
     * @return string page name
     */
    public static function getPageName($pagename){
        $pagename = mb_convert_encoding($pagename, self::$encoding,
                                        mb_detect_encoding($pagename));
        $pagename = rawurlencode($pagename);
        return $pagename;
    }

    /**
     * set encoding
     * @param $encoding string encoding
     */
    public static function setEncoding($encoding){
        self::$encoding = $encoding;
    }
}
?>
