<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URLFactoryImpl.php
 * @brief URLFactoryImpl for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URLFactoryImpl.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URLFactoryImpl for php
 */
require_once("ficus/net/URIFactoryImpl.php");
require_once("ficus/net/URL.php");
require_once("ficus/net/HttpURL.php");
require_once("ficus/net/HttpsURL.php");
require_once("ficus/net/FtpURL.php");
require_once("ficus/net/FileURL.php");
/**
 * @class Ficus_URLFactoryImpl
 */
class Ficus_URLFactoryImpl extends Ficus_URIFactoryImpl {

    /**
     * Get suffix of class name.
     *
     * @return string suffix.
     */
    public function getSuffix() {
        return 'URL';
    }

    /**
     * Default URI .
     *
     * @param $uri string URI.
     * @return Ficus_URI URI.
     */
    public function defaultInstance($uri) {
        return new Ficus_URL($uri);
    }

}
?>
