<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang.reflect
 */
/**
 * @file ReflectionProperty.php
 * @brief This class is the wrapper of ReflectionProperty
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ReflectionProperty.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * Implement getDocComment
 */
require_once "ficus/lang/PHPVersion.php";
require_once "ficus/lang/Assert.php";
/**
 * @class Ficus_ReflectionProperty
 */
class Ficus_ReflectionProperty extends ReflectionProperty
{
    /**
     * implementation of getDocComment available from php5.1.0
     * @return string document comment
     */
    public function getDocComment(){
        if(Ficus_PHPVersion::isOlderThan("5.1.0")){
            $class = $this->getDeclaringClass();
            $filename = $class->getFileName();
            $file = file_get_contents($filename);
            $pattern = '/(\/\*\*(?:(?!\/\*\*).)*?\*\/)(?:(?!\/\*\*)[^\$])*?\$%s/ms';
            $pattern = sprintf($pattern, $this->getName());
            preg_match($pattern, $file, $matches);
            return $matches[1];
        }else{
            return parent::getDocComment();
        }
    }
}
?>
