<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang.annotation
 */
/**
 * @file ReturnAnnotation.php
 * @brief This class stores var annotation data
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ReturnAnnotation.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/lang/reflect/ReflectionAnnotation.php";
require_once "ficus/lang/Assert.php";

/**
 * @class Ficus_ReturnAnnotation
 */
class Ficus_ReturnAnnotation extends Ficus_ReflectionAnnotation
{
    /**
     * type
     */
    private $type;

    /**
     * comment
     */
    private $comment;
    
    /**
     * constructor
     * @param $reflector object reflector object
     * @param $arguments string arguments written in annotation section
     */
    public function __construct($reflector, $arguments){
        parent::__construct($reflector, $arguments);
        preg_match('/^([^ ]+)(.*)/', trim($arguments), $matches);
        $this->type    = $matches[1];
        $this->comment = $matches[2];
    }

    /**
     * get type
     * @return string type
     */
    public function getType(){
        return $this->type;
    }

    /**
     * get comment
     * @return string comment
     */
    public function getComment(){
        return $this->comment;
    }
}
?>
