<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file Random.php
 * @brief create random hash, id
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Random.php 2 2007-07-11 10:37:48Z ishitoya $
 */


/**
 * @class Ficus_Random
 */
class Ficus_Random {
    /**
     * create rondomized integer, alias of nextInteger
     * @param $min int minimal number
     * @param $max int maximam number
     * @return int randomized integer
     */
    public function next($min = 0, $max = 0){
        return $this->nextInteger($min, $max);
    }
    
    /**
     * create randomized integer
     * @param $min int minimal number
     * @param $max int maximam number
     * @return int randomized integer
     */
    public function nextInteger($min = 0, $max = 0){
        if(($min == 0 && $max == 0) ||
           ($min < $max) == false){
            return mt_rand();
        }
        return mt_rand($min, $max);
    }

    /**
     * create rondamized hash string
     * @param $length int length of hash
     * @return string hash string
     */
    public function nextString($length = 0){
        $random = $this->next();
        $hash = sha1(uniqid(mt_rand(), true));
        if($length == 0){
            return $hash;
        }else{
            return substr($hash, 0, $length);
        }
    }
}
?>
