<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.io
 */
/**
 * @file AbstractFileReader.php
 * @brief AbstractFileReader for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: AbstractFileReader.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Abstract File Reader for php
 */

require_once("ficus/exception/FileNotFoundException.php");
require_once("ficus/exception/MultipleFileFoundException.php");
require_once("ficus/exception/NotReadyException.php");
require_once("ficus/lang/ClassPath.php");
require_once("ficus/lang/ClassPathElement.php");
require_once("ficus/io/Dir.php");
require_once("ficus/io/File.php");
require_once("ficus/io/FileReader.php");

/**
 * @class Ficus_AbstractFileReader
 */
abstract class Ficus_AbstractFileReader implements Ficus_FileReader
{

    /** name of config dir*/
    protected static $configDir = null;

    /** name of file to read*/
    protected $filename = null;

	/**
	 * set config path
	 * @param $name string config dir name
	 */
	public static function setConfigDir($name){
		self::$configDir = $name;
	}

	/**
	 * read property file.
	 * @param $package string property file name.
     * @param $suffix string suffix of property file name
     * @param $class string caller class
     * @throw Ficus_NotReadyException no initialized.
     * @throw Ficus_MultipleFileFoundException multiple file found.
     * @throw Ficus_FileNotFoundException file not found.
	 */
	public static function read($package, $suffix = "", $class = __CLASS__){
		$filePath = Ficus_ClassPath::packageToDirectory($package);
        $packageDir = dirname($filePath);
        $filename = basename($filePath) . ".$suffix";

        $found = array();

        if(empty(self::$configDir)){
            $filePath = $packageDir . "/" . $filename;
        }else{
            $filePath = self::$configDir . "/"
                . $packageDir . "/" . $filename;
        }
        $files = Ficus_ClassPath::search($filePath);

        if(count($files) >= 2){
            $files = implode(",", $files);
            throw new Ficus_MultipleFileFoundException("Multiple files are found. please check your settings. $files are found.");
        }else if(empty($files)){
            $paths = Ficus_ClassPath::__toString();
            throw new Ficus_FileNotFoundException(self::$configDir . "/$filename is not found in " . $paths . ".");
        }

        $reader = new $class();
        return $reader->onRead($files[0]);
	}

    /**
     * on read
     * @param $filename string file name
     * @return array of result
     */
    abstract public function onRead($filename);
}
?>
