<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.collection
 */
/**
 * @file MBStringIterator.php
 * @brief MBStringIterator.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: MBStringIterator.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once('ficus/lang/Unicode.php');
/**
 * @class Ficus_MBStringIterator
 */
class Ficus_MBStringIterator implements Iterator
{
    /**
     * @var string.
     */
    protected $string;

    /**
     * @var position.
     */
    protected $position;

    /**
     * @var encoding.
     */
    protected $encoding;

    /**
     * Constructor.
     *
     * @param $string string.
     * @param $encoding encoding.
     */
    public function __construct($string, $encoding = Ficus_Unicode::UTF8) {
        $this->string = $string;
        $this->encoding = $encoding;
    }

    /**
     * Return the current char.
     *
     * @return string current char.
     */
    public function current() {
        return mb_substr($this->string, $this->position, 1, $this->encoding);
    }

    /**
     * Return the key of the current char.
     *
     * @return int current char position.
     */
    public function key() {
        return $this->position;
    }

    /**
     * Move forward to next char.
     */
    public function next() {
        $this->position++;
    }

    /**
     * Rewind the Iterator to the first char.
     */
    public function rewind() {
        $this->position = 0;
    }

    /**
     * Check if there is a current char after calls to rewind() or next().
     */
    public function valid() {
        return $this->position < mb_strlen($this->string, $this->encoding);
    }
}
?>
