<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.subversion
 */
/**
 * @file SVNLookChanged.php
 * @brief execute svnlook changed command
 * @author <a href="kent@guarana.cc">ISITOYA Kentaro</a>
 * @version $Id: SVNLookChanged.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * wrapper class for executing svnlook changed command
 */

require_once("ficus/cli/subversion/SVNConstants.php");
require_once("ficus/cli/subversion/SVNStatusLine.php");
require_once("ficus/lang/Runtime.php");
require_once("ficus/exception/CommandNotFoundException.php");
require_once("ficus/exception/IllegalArgumentException.php");

/**
 * @class Ficus_SVNLookChanged
 */
class Ficus_SVNLookChanged implements Ficus_SVNConstants
{
    const COMMAND = "changed";

    /**
     * @var $repository string repository to look up.
     */
    private $repository = null;

    /**
     * @var $revision string revision number
     */
    private $revision = null;

    /**
     * constructor
     * @param $repository string repository to look in
     * @param $revision string revision numver
     */
    public function __construct($repository, $revision = null){
        $this->repository = $repository;
        $this->revision = $revision;
    }

    /**
     * execute
     * @return array of Ficus_StatusLine
     */
    public function execute(){
        if(Ficus_Runtime::isCommandExists(self::SVNLOOK) == false){
            throw new Ficus_CommandNotFoundException("command svnlook is not found in path");
        }

        $command = $this->createCommand();
        $output = Ficus_Runtime::exec($command);

        $error = $output[Ficus_Runtime::ERROR];
        unset($output[Ficus_Runtime::ERROR]);

        if(empty($error) == false){
            throw new Ficus_IllegalArgumentException($this->repository . " or " . $this->revision . " is illegal. cause of error :$error");
        }

        $result = array();
        foreach($output as $line){
            try{
                $result[] = new Ficus_SVNStatusLine($line);
            }catch(Ficus_IllegalArgumentException $e){
                continue;
            }
        }
        return $result;
    }

    /**
     * create command
     * @return string created command
     */
    private function createCommand(){
        $command = self::SVNLOOK . " " . self::COMMAND;
        $command .=  " " . $this->repository;
        if(is_null($this->revision) == false){
            $command .= " -r " . $this->revision;
        }
        return $command;
    }   
}
?>
