<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli
 */
/**
 * @file CommandLineCommand.php
 * @brief command line command class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: CommandLineCommand.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * Command line command 
 */

/**
 * @class Soya_CommandLineCommand
 */
class Soya_CommandLineCommand{
    const SIMPLE = "simple";
    const PARAMETER = "parameter";
    const EXECUTABLE = "executable";

    private $argument;
    private $function;
    private $name = "";
    private $type;

    public function __construct($name, $type, $function, $argument){
        $this->name = $name;
        $this->type = $type;
        $this->argument = $argument;
        $this->function = $function;
    }
    
    public function name(){
        return $this->name;
    }

    public function argument(){
        return $this->argument;
    }

    public function type(){
        return $this->type;
    }

    public function check($args){
        return $this->argument->check($args, $this->type);
    }

    public function execute(){
        if($this->type == self::EXECUTABLE){
            call_user_func($this->function, null);
        }
    }
}
?>