<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file ErrorBeanDeserializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ErrorBeanDeserializer.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/beans/Bean.php";
require_once "ficus/beans/BeanManager.php";
require_once "ficus/beans/annotation/BeanAnnotationAccessor.php";
require_once "ficus/beans/serializer/BeanDeserializer.php";
require_once "ficus/exception/IllegalBeanException.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_ErrorBeanDeserializer
 */
class Ficus_ErrorBeanDeserializer implements Soya_BeanDeserializer{

    /**
     * @var $manager Ficus_BeanManager manager
     */
    private $manager = null;
    
    /**
     * serialize bean to RDF
     * @param $data array array to deserialize
     * @param $bean Ficus_ErrorBean target bean
     * @return Ficus_Bean bean
     */
    public function deserialize($bean, $data){
        Ficus_Assert::isInstanceOf(
            $bean, "Ficus_Beans_cc_guarana_soya_system_ErrorBean");
        Ficus_Assert::isInstanceOf($data, "Exception");
                           
        $this->manager = new Ficus_BeanManager();
        $bean = $this->parseError($bean, $data);
        return $bean;
    }

    /**
     * Deserialize Exception
     * @param $bean Ficus_ErrorBean bean to parse
     * @param $data Exception to parse
     * @return Ficus_ErrorBean result bean
     * @throw Ficus_IllegalBeanException illegal bean.
     */
    private function parseError($bean, $data){
        $bean->setType(get_class($data));
        $bean->setMessage($data->getMessage());
        $bean->setTrace($data->getTraceAsString());
        $bean->setFile($data->getFile());
        $bean->setLine($data->getLine());
        if($data->getCause() != null){
            $cause = $bean->getCauseBean();
            $bean->setCause($this->parseError($cause, $data->getCause()));
        }
        return $bean;
    }
}
?>
