<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.analyzer
 */
/**
 * @file FunctionAnalyzeData.php
 * @brief FunctionAnalyzeData of PHP.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: FunctionAnalyzeData.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Function Analyze data of PHP.
 */
require_once('ficus/analyzer/AnalyzeData.php');
/**
 * @class Ficus_FunctionAnalyzeData
 */
class Ficus_FunctionAnalyzeData extends Ficus_AnalyzeData {
    /**
     * @var function parameters.
     */
    protected $parameters = array();
    /**
     * @var throwing exceptions in function.
     */
    protected $throws = array();
    /**
     * Constructor.
     *
     * @param $name string name.
     */
    public function __construct($name) { $this->name = $name; }
    /**
     * Add throw analyze data.
     *
     * @param $throw Ficus_ThrowAnalyzeData.
     */
    public function addThrow($throw) { $this->throws[] = $throw; }
    /**
     * Set throw analyze data.
     *
     * @param $throws array of Ficus_ThrowAnalyzeData.
     */
    public function setThrows($throws) { $this->throws = $throws; }
    /**
     * Get throw analyze data by index.
     *
     * @param $index int index of throw analyze data.
     * @return Ficus_ThrowAnalyzeData.
     */
    public function getThrow($index) { return $this->throws[$index]; }
    /**
     * Get throw analyze data.
     *
     * @return array of Ficus_ThrowAnalyzeData.
     */
    public function getThrows() { return $this->throws; }
    /**
     * Add parameter analyze data.
     *
     * @param $parameter Ficus_ParameterAnalyzeData.
     */
    public function addParameter($parameter) { $this->parameters[] = $parameter; }
    /**
     * Set parameter analyze data.
     *
     * @param $parameters array of Ficus_ParameterAnalyzeData.
     */
    public function setParameters($parameters) { $this->parameters = $parameters; }
    /**
     * Get parameter analyze data by index.
     *
     * @param $index int index of parameter analyze data.
     */
    public function getParameter($index) { return $this->parameters[$index]; }
    /**
     * Get parameter analyze data.
     *
     * @return array of Ficus_ParameterAnalyzeData.
     */
    public function getParameters() { return $this->parameters; }
    /**
     * To string.
     *
     * @return string of this.
     */
    public function __toString() {
        $buf = "\nfunction " . parent::__toString();
        foreach ($this->parameters as $parameter) {
            $buf .= Ficus_Arrays::arrayToString($parameter);
        }
        $buf .= Ficus_Arrays::arrayToString($this->throws);
        return $buf;
    }
}
?>
