<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.analyzer
 */
/**
 * @file AnalyzeData.php
 * @brief AnalyzeData of PHP.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: AnalyzeData.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Analyze data of PHP.
 */
require_once('ficus/lang/Arrays.php');
/**
 * @class Ficus_AnalyzeData
 */
class Ficus_AnalyzeData {
    /**
     * @var data name.
     */
    protected $name;
    /**
     * @var comment.
     */
    protected $comment;
    /**
     * @var annotations.
     */
    protected $annotations = array();
    /**
     * Set name.
     *
     * @param $name string name.
     */
    public function setName($name) { $this->name = $name; }
    /**
     * Get name.
     *
     * @return string name.
     */
    public function getName() { return $this->name; }
    /**
     * Set comment.
     *
     * @param $comment string comment.
     */
    public function setComment($comment) { $this->comment = $comment; }
    /**
     * Get comment.
     *
     * @return string comment.
     */
    public function getComment() { return $this->comment; }
    /**
     * Add annotation.
     *
     * @param $annotation Ficus_AnnotationAnalyzeData.
     */
    public function addAnnotation($annotation) { $this->annotations[] = $annotation; }
    /**
     * Set annotations.
     *
     * @param $annotations array of Ficus_AnnotationAnalyzeData.
     */
    public function setAnnotations($annotations) { $this->annotations = $annotations; }
    /**
     * Get annotations.
     *
     * @return array of annotation.
     */
    public function getAnnotations() { return $this->annotations; }
    /**
     * Get Annotation.
     *
     * @param $index int index of annotation.
     * @return Ficus_AnnotationAnalyzeData annotation analyze data.
     */
    public function getAnnotation($index) { return $this->annotations[$index]; }
    /**
     * To string.
     *
     * @return string of this.
     */
    public function __toString() {
        $buf = $this->getName() . "\n";
        $buf .= Ficus_Arrays::arrayToString($this->annotations);
        return $buf;
    }
}
?>
