<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.XML
 */
/**
 * @file PrefixedQName.php
 * @brief PrefixedQName.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: PrefixedQName.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once("ficus/lang/Types.php");
require_once("ficus/XML/QName.php");
/**
 * @class Ficus_PrefixedQName
 */
class Ficus_PrefixedQName extends Ficus_QName
{
    /**
     * prefix.
     */
    protected $prefix = NULL;

    /**
     * constructor.
     *
     * @param $uri string String of uri.
     * @param $localPart string String of localPart.
     * @param $prefix string String of prefix.
     */
    public function __construct($uri, $localPart, $prefix) {
        parent::__construct($uri, $localPart);
        Ficus_Assert::isPrimitiveType($prefix, "string");
        $this->prefix = $prefix;
    }

    /**
     * add prefix to qname.
     *
     * @param $qname Ficus_QName.
     * @param $prefix string prefix.
     * @return Ficus_PrefixedQName
     */
    public static function addPrefix($qname, $prefix) {
        return new Ficus_PrefixedQName($qname->uri, $qname->localPart, $prefix);
    }

    /**
     * get prefix.
     *
     * @return String of prefix.
     */
    public function prefix() {
        return $this->prefix;
    }

    /**
     * get prefixed name.
     *
     * @return String of qname.
     */
    public function prefixedName() {
        return $this->prefix . ":" . $this->localPart;
    }

    /**
     * QName toString.
     *
     * @return string of QName.
     */
    public function toString() {
        return $this->prefixedName();
    }

    /**
     * QName toString.
     *
     * @return string of QName.
     */
    public function __toString() {
        return $this->prefixedName();
    }
}
?>
