<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file RDFTypes.php
 * @brief RDFTypes.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: RDFTypes.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
/**
 * @class Ficus_RDFTypes
 */
class Ficus_RDFTypes
{
    /**
     * XML schema namespace.
     */
    const NS_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema#";

    /**
     * RDF namespace.
     */
    const NS_RDF = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#';

    const XSD_STRING = 'string';
    const XSD_BOOLEAN = 'boolean';
    const XSD_DECIMAL = 'decimal';
    const XSD_FLOAT = 'float';
    const XSD_DOUBLE = 'double';
    const XSD_DATE_TIME = 'dateTime';
    const XSD_DATETIME = 'dateTime';
    const XSD_TIME = 'time';
    const XSD_DATE = 'date';
    const XSD_G_YEAR_MONTH = 'gYearMonth';
    const XSD_G_YEAR = 'gYear';
    const XSD_G_MONTH_DAY = 'gMonthDay';
    const XSD_G_DAY = 'gDay';
    const XSD_G_MONTH = 'gMonth';
    const XSD_HEX_BINARY = 'hexBinary';
    const XSD_BASE64_BINARY = 'base64Binary';
    const XSD_ANY_URI = 'anyURI';
    const XSD_NORMALIZED_STRING = 'normalizedString';
    const XSD_TOKEN = 'token';
    const XSD_LANGUAGE = 'language';
    const XSD_NMTOKEN = 'NMTOKEN';
    const XSD_NAME = 'name';
    const XSD_NC_NAME = 'NCName';
    const XSD_NCNAME = 'NCName';
    const XSD_INTEGER = 'integer';
    const XSD_NON_POSITIVE_INTEGER = 'nonPositiveInteger';
    const XSD_NEGATIVE_INTEGER = 'negativeInteger';
    const XSD_LONG = 'long';
    const XSD_INT = 'int';
    const XSD_SHORT = 'short';
    const XSD_BYTE = 'byte';
    const XSD_NON_NEGATIVE_INTEGER = 'nonNegativeInteger';
    const XSD_UNSIGNED_LONG = 'unsignedLong';
    const XSD_UNSIGNED_INT = 'unsignedInt';
    const XSD_UNSIGNED_SHORT = 'unsignedShort';
    const XSD_UNSIGNED_BYTE = 'unsignedByte';
    const XSD_POSITIVE_INTEGER = 'positiveInteger';
    const RDF_XML_LITERAL = 'XMLLiteral';

    /**
     * Get RDF Type.
     *
     * @return string RDF type QName.
     */
    public function string() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_STRING);
    }
    public function boolean() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_BOOLEAN);
    }
    public function decimal() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_DECIMAL);
    }
    public function float() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_FLOAT);
    }
    public function double() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_DOUBLE);
    }
    public function dateTime() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_DATE_TIME);
    }
    public function time() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_TIME);
    }
    public function date() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_DATE);
    }
    public function gYearMonth() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_G_YEAR_MONTH);
    }
    public function gYear() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_G_YEAR);
    }
    public function gMonthDay() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_G_MONTH_DAY);
    }
    public function gDay() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_G_DAY);
    }
    public function gMonth() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_G_MONTH);
    }
    public function hexBinary() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_HEX_BINARY);
    }
    public function base64Binary() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_BASE64_BINARY);
    }
    public function anyURI() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_ANY_URI);
    }
    public function normalizedString() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NORMALIZED_STRING);
    }
    public function token() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_TOKEN);
    }
    public function language() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_LANGUAGE);
    }
    public function NMTOKEN() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NMTOKEN);
    }
    public function name() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NAME);
    }
    public function NCName() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NC_NAME);
    }
    public function integer() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_INTEGER);
    }
    public function nonPositiveInteger() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NON_POSITIVE_INTEGER);
    }
    public function negativeInteger() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NEGATIVE_INTEGER);
    }
    public function long() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_LONG);
    }
    public function int() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_INT);
    }
    public function short() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_SHORT);
    }
    public function byte() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_BYTE);
    }
    public function nonNegativeInteger() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_NON_NEGATIVE_INTEGER);
    }
    public function unsignedLong() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_UNSIGNED_LONG);
    }
    public function unsignedInt() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_UNSIGNED_INT);
    }
    public function unsignedShort() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_UNSIGNED_SHORT);
    }
    public function unsignedByte() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_UNSIGNED_BYTE);
    }
    public function positiveInteger() {
        return new Ficus_QName(self::NS_XML_SCHEMA, self::XSD_POSITIVE_INTEGER);
    }
    public function XMLLiteral() {
        return new Ficus_QName(self::NS_RDF, self::RDF_XML_LITERAL);
    }
}
?>
