/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.models.table;

import java.util.ArrayList;
import jp.sourceforge.ffplug.rcp.models.table.BeanPredicate;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AllPredicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.apache.log4j.Logger;

public class SynthPredicate
implements Predicate {
    static Logger log;
    private String text;
    private int kind;
    private boolean subskill;
    private int capRank;
    private int capBase;
    private int capRange;
    private boolean capIncludeUnknown;
    private boolean targetHq;
    private boolean targetIngredient;
    private boolean targetText;
    private boolean repBasic;
    private boolean repDiv;
    private boolean repItem;
    private Predicate textPredicate;
    private Predicate kindPredicate;
    private Predicate capPredicate;
    private Predicate predicate;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ffplug.rcp.models.table.SynthPredicate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((String)clazz.getName());
    }

    public SynthPredicate() {
        this.setDefault();
    }

    public void setDefault() {
        this.text = null;
        this.kind = -1;
        this.capRank = -1;
        this.capBase = -1;
        this.capRange = 3;
        this.repBasic = true;
        this.targetHq = true;
        this.makePredicate();
    }

    public void makePredicate() {
        this.makeTextPredicate();
        this.makeKindPredicate();
        this.makeCapPredicate();
        this.predicate = AllPredicate.getInstance((Predicate[])new Predicate[]{this.textPredicate, this.kindPredicate, this.capPredicate});
    }

    private void makeTextPredicate() {
        if (this.text == null || this.text.equals("")) {
            this.textPredicate = TruePredicate.getInstance();
        } else {
            ContainsPredicate cp = new ContainsPredicate((Comparable)((Object)this.text));
            ArrayList<BeanPredicate> predicates = new ArrayList<BeanPredicate>();
            predicates.add(new BeanPredicate("itemName", cp));
            if (this.targetHq) {
                predicates.add(new BeanPredicate("hqItemName1", cp));
                predicates.add(new BeanPredicate("hqItemName2", cp));
                predicates.add(new BeanPredicate("hqItemName3", cp));
            }
            if (this.targetIngredient) {
                predicates.add(new BeanPredicate("materialItemName1", cp));
                predicates.add(new BeanPredicate("materialItemName2", cp));
                predicates.add(new BeanPredicate("materialItemName3", cp));
                predicates.add(new BeanPredicate("materialItemName4", cp));
                predicates.add(new BeanPredicate("materialItemName5", cp));
                predicates.add(new BeanPredicate("materialItemName6", cp));
                predicates.add(new BeanPredicate("materialItemName7", cp));
                predicates.add(new BeanPredicate("materialItemName8", cp));
            }
            if (this.targetText) {
                predicates.add(new BeanPredicate("itemText", cp));
            }
            this.textPredicate = AnyPredicate.getInstance(predicates);
        }
    }

    private void makeKindPredicate() {
        if (this.kind >= 0 && this.kind <= 8 && !this.subskill) {
            EqualPredicate eqp = new EqualPredicate((Object)new Integer(this.kind));
            this.kindPredicate = new BeanPredicate("skillId", (Predicate)eqp);
        } else {
            this.kindPredicate = TruePredicate.getInstance();
        }
    }

    private void makeCapPredicate() {
        if (this.kind >= 0 && this.kind <= 8) {
            if (this.capRank >= 0 && this.capRank <= 9) {
                if (this.subskill) {
                    this.capPredicate = this.makeRangePredicate(this.capRank * 10, this.capRank * 10 + 9, this.kind);
                } else {
                    EqualPredicate eqp = new EqualPredicate((Object)new Integer(this.capRank));
                    this.capPredicate = new BeanPredicate("rankId", (Predicate)eqp);
                }
            } else {
                this.capPredicate = this.capBase >= 0 && this.capRange >= 0 ? this.makeRangePredicate(this.capBase, this.capBase + this.capRange, this.kind) : TruePredicate.getInstance();
            }
            EqualPredicate boolTrue = new EqualPredicate((Object)new Boolean(true));
            EqualPredicate boolFalse = new EqualPredicate((Object)new Boolean(false));
            if (this.repBasic) {
                if (!this.repDiv) {
                    this.capPredicate = AllPredicate.getInstance((Predicate[])new Predicate[]{this.capPredicate, new BeanPredicate("decomp", (Predicate)boolFalse)});
                }
            } else {
                this.capPredicate = this.repDiv ? AllPredicate.getInstance((Predicate[])new Predicate[]{this.capPredicate, new BeanPredicate("decomp", (Predicate)boolTrue)}) : FalsePredicate.getInstance();
            }
            if (this.capIncludeUnknown) {
                this.capPredicate = AnyPredicate.getInstance((Predicate[])new Predicate[]{this.capPredicate, new BeanPredicate("skillCap" + this.kind, (Predicate)new EqualPredicate((Object)new Integer(-1)))});
            }
        } else {
            this.capPredicate = TruePredicate.getInstance();
        }
    }

    private Predicate makeRangePredicate(int capFrom, int capTo, int skillKind) {
        GePredicate gep = new GePredicate(new Integer(capFrom));
        LePredicate lep = new LePredicate(new Integer(capTo));
        String skillCapField = "skillCap" + skillKind;
        BeanPredicate gebp = new BeanPredicate(skillCapField, gep);
        BeanPredicate lebp = new BeanPredicate(skillCapField, lep);
        return AllPredicate.getInstance((Predicate[])new Predicate[]{gebp, lebp});
    }

    public boolean evaluate(Object obj) {
        return this.predicate.evaluate(obj);
    }

    public int getCapBase() {
        return this.capBase;
    }

    public void setCapBase(int capBase) {
        this.capBase = capBase;
    }

    public int getCapRange() {
        return this.capRange;
    }

    public void setCapRange(int capRange) {
        this.capRange = capRange;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public boolean isSubskill() {
        return this.subskill;
    }

    public void setSubskill(boolean subskill) {
        this.subskill = subskill;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isRepBasic() {
        return this.repBasic;
    }

    public void setRepBasic(boolean repBasic) {
        this.repBasic = repBasic;
    }

    public boolean isRepDiv() {
        return this.repDiv;
    }

    public void setRepDiv(boolean repDiv) {
        this.repDiv = repDiv;
    }

    public boolean isRepItem() {
        return this.repItem;
    }

    public void setRepItem(boolean repItem) {
        this.repItem = repItem;
    }

    public boolean isTargetHq() {
        return this.targetHq;
    }

    public void setTargetHq(boolean targetHq) {
        this.targetHq = targetHq;
    }

    public boolean isTargetIngredient() {
        return this.targetIngredient;
    }

    public void setTargetIngredient(boolean targetIngredient) {
        this.targetIngredient = targetIngredient;
    }

    public boolean isTargetText() {
        return this.targetText;
    }

    public void setTargetText(boolean targetText) {
        this.targetText = targetText;
    }

    public boolean isCapIncludeUnknown() {
        return this.capIncludeUnknown;
    }

    public void setCapIncludeUnknown(boolean capIncludeUnknown) {
        this.capIncludeUnknown = capIncludeUnknown;
    }

    public int getCapRank() {
        return this.capRank;
    }

    public void setCapRank(int capRank) {
        this.capRank = capRank;
    }

    public static class GePredicate
    implements Predicate {
        Comparable index;

        public GePredicate(Comparable index) {
            this.index = index;
        }

        public boolean evaluate(Object input) {
            if (input instanceof Comparable) {
                int cmp = ((Comparable)input).compareTo(this.index);
                return cmp >= 0;
            }
            return true;
        }
    }

    public static class LePredicate
    implements Predicate {
        Comparable index;

        public LePredicate(Comparable index) {
            this.index = index;
        }

        public boolean evaluate(Object input) {
            if (input instanceof Comparable) {
                int cmp = ((Comparable)input).compareTo(this.index);
                return cmp <= 0;
            }
            return true;
        }
    }

    public static class ContainsPredicate
    implements Predicate {
        String index;

        public ContainsPredicate(Comparable index) {
            this.index = (String)((Object)index);
        }

        public boolean evaluate(Object input) {
            String inputStr = (String)input;
            return inputStr.indexOf(this.index) != -1;
        }
    }
}

