/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ffplug.rcp.models.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    private static final String INPUT_DATE_FORMAT_PATTERN = "yyyyMMdd";
    private static final SimpleDateFormat INPUT_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");

    public static Date parseDate(String fromDateStr) {
        if (fromDateStr == null || fromDateStr.equals("")) {
            return null;
        }
        Date time = null;
        try {
            time = INPUT_DATE_FORMAT.parse(fromDateStr);
        }
        catch (ParseException parseException) {
            return null;
        }
        return time;
    }

    public static String formatDate(Date date) {
        String toDateStr = INPUT_DATE_FORMAT.format(date);
        return toDateStr;
    }

    public static Date getNowDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date time = cal.getTime();
        return time;
    }

    public static Date lastMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(7, 2);
        if (cal.getTime().after(date)) {
            cal.add(4, -1);
        }
        return cal.getTime();
    }

    public static Date lastWeekDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(4, -1);
        return cal.getTime();
    }

    public static Date latestDate(Collection dates) {
        Date nowDate = DateUtils.getNowDate();
        Date latestDate = null;
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            if (date.after(nowDate)) continue;
            if (latestDate == null) {
                latestDate = date;
                continue;
            }
            if (!date.after(latestDate)) continue;
            latestDate = date;
        }
        return latestDate;
    }

    public static Date parseDateFilename(String prefix, String name) {
        String patternStr = String.valueOf(prefix) + "\\.(\\d{8})" + "\\.txt";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(name);
        if (!m.matches()) {
            return null;
        }
        String datestr = m.group(1);
        Date date = DateUtils.parseDate(datestr);
        return date;
    }
}

