# ======================================================================
# LocalCGI.pm - CGIȤʴؿ
#
# ----------------------------------------------------------------------

package LocalCGI;

use TextTemplate;

use Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
	&URL_encode
	&URL_decode
	&HTML_encode
	&HTML_decode
	&toEUC
	&toJIS
	&toSJIS
	&BASE64_encode
	&BASE64_decode
	&Regular
	&Strip
	&QUERY_decode
	&TIME_format
	&FILE_head
	&OutputTemplate
	&OutputHtml
);


use strict;

# ======================================================================
# FORMURIΥ󥳡/ǥ
#
# ----------------------------------------------------------------------
# ʸѴؿϤ٤
#   饳ƥȤʤ1Ѵ̤򥹥
#   ꥹȥƥȤʤ餹٤ƤΰѴ̤
# ֤


sub URL_encode
{
	my @ret = @_;
	
	for (@ret) {
		s/([^-.!~*@\$ \w])/sprintf("%%%02X", ord($1))/eg;
		tr/ /+/;
	}
	return wantarray ? @ret : $ret[0];
}

sub URL_decode
{
	my @ret = @_;

	for (@ret) {
		tr/+/ /;
		s/%([0-9A-Fa-f][0-9A-Fa-f])/chr(hex($1))/eg;
	}
	return wantarray ? @ret : $ret[0];
}

# ======================================================================
# Ѵ
#
# CGIEUCǽΤ ?EUC  EUC? 
# ----------------------------------------------------------------------

sub toEUC
{
	require "jcode.pl";

	my @ret = map { jcode::to("euc", $_, undef, "z"); } @_;

	return wantarray ? @ret : $ret[0];
}

sub toJIS
{
	require "jcode.pl";

	my @ret = map { jcode::to("jis", $_, "euc"); } @_;

	return wantarray ? @ret : $ret[0];
}

sub toSJIS
{
	require "jcode.pl";

	my @ret = map { jcode::to("sjis", $_, "euc"); } @_;

	return wantarray ? @ret : $ret[0];
}


# ======================================================================
# HTMLʸƥƥΥ󥳡/ǥ
#
# ----------------------------------------------------------------------

sub HTML_encode
{
	my @ret = @_;

	for (@ret) {
		s/\&/\&amp;/g;
		s/\"/\&quot;/g;
		s/\</\&lt;/g;
		s/\>/\&gt;/g;
	}
	return wantarray ? @ret : $ret[0];
}

sub HTML_decode
{
	my @ret = @_;

	for (@ret) {
		s/\&quot;/\"/g;
		s/\&lt;/\</g;
		s/\&gt;/\>/g;
		s/\&amp;/\&/g;
	}
	return wantarray ? @ret : $ret[0];
}

# ======================================================================
# ԥɤ\nפ줹
#
# ----------------------------------------------------------------------

sub NL_regularize
{
	my @ret = @_;

	for (@ret) {
		s/\015\012/\012/g;
		tr/\015\012/\n\n/;
	}
	return wantarray ? @ret : $ret[0];
}

# ======================================================================
# BASE64󥳡/ǥ
#
# ----------------------------------------------------------------------

sub BASE64_encode
{
	my @ret = @_;

	for (@ret) {
		my $p = (3 - length($_) % 3) % 3;

		my $s;
		while (/(.{1,45})/gs) {
			$s .= substr(pack("u", $1), 1);
			chop($s);
		}
		$_ = $s;

		tr/` -_/AA-Za-z0-9+\//; 
		s/.{$p}$/'=' x $p/e  if $p;
		# s/(.{1,76})/$1\n/g;
	}
	return wantarray ? @ret : $ret[0];
}

sub BASE64_decode
{
	my @ret = @_;
	
	for (@ret) {
		tr/A-Za-z0-9+\///cd;
		tr/A-Za-z0-9+\// -_/;

		my $s;
		while (/(.{1,60})/gs) {
			my $len = chr(32 + int(length($1) * 3 / 4));
			$s .= unpack("u", $len . $1);
		}
		$_ = $s;
	}
	return wantarray ? @ret : $ret[0];
}


# ======================================================================
# ʸ
#
# ASCIIˤʸASCIIˤ
# ISO-2022-JPˤʤʸϥˤ
# 1byteʤѴ̤
# ----------------------------------------------------------------------

sub CHAR_r1
{
	my ($HL, $H, $L) = @_;

	#
	# ASCIIˤʸASCIIˤ
	#
	if ($H eq "\241") {
		#
		# 
		#
		if ($L =~ tr/\241\244\245\247-\252\260-\262\277\300\303\306\307\312\313\316-\321\334\335\341\343\344\357\360\363-\367/ ,.:;?!^~_\/\\|`'()[]{}+\-=<>\\\$%#&*\@/) {
			$HL = $L;
		}
	}
	elsif ($H eq "\243") {
		#
		# ѿ
		#
		if ($L =~ tr/\260-\271\301-\332\341-\372/0-9A-Za-z/) {
			$HL = $L;
		}
	}
	#
	# ISO-2022-JPˤʤʸϥˤ
	#
	elsif ($H eq "\255") {
		#
		# ޤ: NEC98Ѵ
		#
		if ($L =~ /[\241-\264]/) {
			#
			# ݿ
			#
			$HL = sprintf("(%d)", ord($L) - 0240);
		}
		elsif ($L =~ /[\265-\276]/) {
			#
			# ޿
			#
			$HL = sprintf("%s", (qw(I II III IV V VI VII VIII IX X))[ord($L) - 0265]);
		}
		elsif ($L =~ /[\337-\357]/) {
			#
			# misc.
			#
			$HL = sprintf("%s", ("ʿ", "\`", "\'", "No.", "K.K.", "Tel", "()", "()", "()", "()", "()", "()", "(ͭ)", "()", "", "", "")[ord($L) - 0337]);
		}
		else {
			#
			# 
			#
			$HL = "\242\256";
		}
	}

	return $HL;
}

sub CHAR_regularize
{
	my @ret = @_;

	for (@ret) {
		s/(([\200-\377])([\200-\377]))/CHAR_r1($1, $2, $3)/ge;
	}
	return wantarray ? @ret : $ret[0];
}

# ======================================================================
# ޤȤ
#
# ----------------------------------------------------------------------

sub Regular
{
	my @ret = map { CHAR_regularize(toEUC(NL_regularize($_))); } @_;

	return wantarray ? @ret : $ret[0];
}


# ======================================================================
# ζʸ
#
# JISδֳ֡֡פ
# ----------------------------------------------------------------------

sub Strip
{
	my @ret = @_;

	for (@ret) {
		s/^(\241\241|[\000-\040])+//;
		s/(\241\241|[\000-\040])+$//;
	}
	return wantarray ? @ret : $ret[0];
}


# ======================================================================
# եफΥǡʤ
#
# name="[@][!*]<key>[:<value>]"
#
#  @        
#
#  !        ǡ򤤤ʤ
#  *        뤬ζϤȤʤ
#  (ʤ)   ζȤ
#
#  <value>  value°ͤȤƤȤ
# ----------------------------------------------------------------------

sub QUERY_decode
{
	if ($ENV{CONTENT_TYPE} =~ /^multipart/) {
		#
		# ޥѡ
		#
		return QUERY_multi();
	}

	my %query;

	if ($ENV{REQUEST_METHOD} eq "POST") {
		read(STDIN, $_, $ENV{CONTENT_LENGTH});
	} else {
		$_ = $ENV{QUERY_STRING};
	}

	foreach (split("&")) {
		my ($name, $value) = split("=");
		my ($arr, $ex, $key, $eq, $xval) = Regular(URL_decode($name)) =~ /^(@?)([!\*]?)([^:]*)(?:(:)(.*))?$/;
		my $val = $eq ? $xval
		              : $ex
		                ? $ex eq "!"
		                  ? URL_decode($value)
		                  : Regular(URL_decode($value)) 
		                : Strip(Regular(URL_decode($value)))
		;
		if ($arr) {
			push(@{$query{$key}}, $val);
		}
		else {
			$query{$key} = $val;
		}
	}
	return %query;
}

# ======================================================================
# ޥѡ(եΥåץɤʤ)
# ----------------------------------------------------------------------

sub QUERY_multi
{
	local ($_);

	my $rest = $ENV{CONTENT_LENGTH};

	#
	# ѥ졼(ǽβԤޤ)Ȥ
	#
	my $i;
	my $sep;
	while (($i = index($sep, "\015\012")) < 0) {
		return () if $rest <= 0;
		read(STDIN, $_, 8192);
		$rest -= length($_);
		$sep .= $_;
	}
	my $head = substr($sep, $i);
	$sep = "\015\012" . substr($sep, 0, $i);
	my $seplen = length($sep);

	#
	# ƥˤȤ
	#
	my %query;
	while ($head =~ /^\015\012/) {
		#
		# إå(=ԤդĤޤ)Ȥ
		#
		while (($i = index($head, "\015\012\015\012")) < 0) {
			last if $rest <= 0;
			read(STDIN, $_, 8192);
			$rest -= length($_);
			$head .= $_;
		}
		my $content = substr($head, $i + 4);
		$head = substr($head, 2, $i - 2);

		#
		# إå
		#
		my ($name,)  = $head =~ / name="([^"]*)"/;
		my ($fname,) = $head =~ / filename="([^"]*)"/;
		my ($type,)  = $head =~ /Content-Type: (.*)/;

		#
		# ǡ(=ѥ졼ޤ)Ф
		#
		while (($i = index($content, $sep)) < 0) {
			last if $rest <= 0;
			read(STDIN, $_, 8192);
			$rest -= length($_);
			$content .= $_;
		}
		$head = substr($content, $i + $seplen);
		$content = substr($content, 0, $i);

		#
		# ȤϤդĤΥեȤʤ
		# ǥɤ
		#
		my ($arr, $ex, $key, $eq, $xval) = Regular($name) =~ /^(@?)([!\*]?)([^:]*)(?:(:)(.*))?$/;
		$content = $eq ? $xval
		               : $ex
		                ? $ex eq "!"
		                  ? $content
		                  : Regular($content)
                                : Strip(Regular($content))
		;
		if ($arr) {
			push(@{$query{$key}}, $content);
		}
		else {
			$query{$key} = $content;
			$query{"-${key}_name"} = $fname if($fname ne "");
			$query{"-${key}_type"} = $type  if($type ne "");
		}
	}
	return %query;
}

# ======================================================================
# 
#
# ----------------------------------------------------------------------

sub TIME_format
{
	my ($format, $time, $gmt) = @_;

	#
	# locale
	#
	my ($zone, $diff) = ("JST", "+09");

	if ($format =~ /^(HTTP|COOKIE)$/) {
		#
		# ΥץȥǤGMTȤ
		#
		$gmt = 1;
	}


	if ($format =~ /^$/) {
		#
		# 褯Ȥ
		#
		$format = "{YYYY}/{MM}/{DD} {hh}:{mm}:{ss}";
	}
	elsif ($format =~ /^(HTTP|SMTP)$/) {
		#
		# RFC1123
		#
		my $tz = $gmt ? "(GMT)" : "${diff}00";
		$format = "{www}, {DD} {MMM} {YYYY} {hh}:{mm}:{ss} $tz";
	}
	elsif ($format =~ /^(COOKIE)$/) {
		#
		# ѷ RFC1123 (GMTڤϥå)
		# http://home.netscape.com/newsref/std/cookie_spec.html
		#
		$format = "{www}, {DD}-{MMM}-{YYYY} {hh}:{mm}:{ss} GMT";
	}
	elsif ($format eq /^(HTML)$/) {
		#
		# ISO8601 ΤҤȤ
		#
		my $tz = $gmt ? "Z" : "${diff}:00";
		$format = "{YYYY}-{MM}-{DD}T{hh}:{mm}:{ss} $tz";
	}
		
	$time ||= time();
	my ($s, $m, $h, $D, $M, $Y, $w) = $gmt ? gmtime($time) : localtime($time);

	for ($format) {
		s/{YYYY}/sprintf("%04d", $Y + 1900)/ge;
		s/{YY}/sprintf("%02d", $Y % 100)/ge;
		s/{MM}/sprintf("%02d", $M + 1)/ge;
		s/{DD}/sprintf("%02d", $D)/ge;
		s/{hh}/sprintf("%02d", $h)/ge;
		s/{mm}/sprintf("%02d", $m)/ge;
		s/{ss}/sprintf("%02d", $s)/ge;
		s/{MMM}/(qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec))[$M]/ge;
		s/{www}/(qw(Sun Mon Tue Wed Thu Fri Sat))[$w]/ge;
	}
	return $format;
}


# ======================================================================
# ɤ
# ----------------------------------------------------------------------

sub FILE_head
{
	my ($filename, $length) = @_;

	my $ret = <<"__EOS__";
Content-Disposition: attachment; filename="$filename"
Content-Type: application/octet-stream
__EOS__
	$ret .= "Content-Length: $length\n"  if $length ne "";  
	$ret .= "\n";

	return $ret;
}

# ======================================================================
# ƥץ졼ȤѤHTMLν
# ----------------------------------------------------------------------
sub OutputTemplate {
	my ($filename, %tmpl_data) = @_;

	my $template = TextTemplate->new(
		FILENAME   => $filename,
		TAG_PREFIX => 'TMPL_',
		VAR_PREFIX => '{{',
		VAR_SUFFIX => '}}'
	);

	$template->param( %tmpl_data );
	return $template->output();
}

sub OutputHtml($%){
	my ($filename, %tmpl_data, $charset) = @_;

	my $html = OutputTemplate($filename, %tmpl_data);
	$html = TemplataFilter($html, %tmpl_data);

	$charset ||= 'EUC-JP';
	
#Pragma: no-cache
#Cache-Control: no-cache
	print <<END_OF_HTML;
Content-type: text/html; charset=$charset

$html
END_OF_HTML

}

# --------------------------------------------------------------------
# ƥץ졼ȥե륿
# - <select name="hoge" tmpl_select="1">
# - <input type="checkbox" name="xx" tmpl_check="1">
#
#
# --------------------------------------------------------------------
sub TemplataFilter {
    my ($html, %tmpl) = @_;

    my @html = split("\n", $html);

    my $selected;
    my %tmp;
    for (@html) {
        if (/<select name=".*?(\w+)".*?tmpl_select="1">/) {
            $selected = $1;
            s/ tmpl_select="1"//;
        }
        if ($selected and /<option value="(.+)">/) {
            if ($tmpl{$selected} eq $1) {
                s/option/option selected/;
            }
        }

        #
        # CHECKED
        #
        if (/<\s*input(.+type=["']?(radio|checkbox)["']?.*?)>/i) {

			my $tmp =$1;
			$tmp =~ s/^\s*(.+?)\s*$/$1/;
			my %attribute =
				map {s/^["']?(.*?)["']?$/$1/; $_}  # ;פ "' 
				map{split("=", $_)}                # = ʬ
				split(/\s+/, $tmp);                # ڡʬ

			if ($attribute{tmpl_check} == 1) {
				my $key   = $attribute{name};
				my $value = $attribute{value};
				if (ref $tmpl{$key} eq "ARRAY" and ref $tmp{$key} ne "HASH") {
					for (@{$tmpl{$key}}) {
						$tmp{$key}->{$_} = 1;
					}
				}
				if ($tmpl{$key} eq $value or $tmp{$key}->{$value} == 1) {
					s/name="/checked name="/;
				}
			}
        }
    }

    return join("\n", @html);
}

1;
