/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.zookeeper.KeeperException;

public class CloudSolrServer
extends SolrServer {
    private volatile ZkStateReader zkStateReader;
    private String zkHost;
    private int zkConnectTimeout = 10000;
    private int zkClientTimeout = 10000;
    private volatile String defaultCollection;
    private final LBHttpSolrServer lbServer;
    private final boolean shutdownLBHttpSolrServer;
    private HttpClient myClient;
    Random rand = new Random();
    private final boolean updatesToLeaders;
    private boolean parallelUpdates = true;
    private ExecutorService threadPool = Executors.newCachedThreadPool(new SolrjNamedThreadFactory("CloudSolrServer ThreadPool"));
    private String idField = "id";
    private final Set<String> NON_ROUTABLE_PARAMS = new HashSet<String>();

    public CloudSolrServer(String zkHost) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.zkHost = zkHost;
        this.myClient = HttpClientUtil.createClient(null);
        this.lbServer = new LBHttpSolrServer(this.myClient, new String[0]);
        this.lbServer.setRequestWriter(new BinaryRequestWriter());
        this.lbServer.setParser(new BinaryResponseParser());
        this.updatesToLeaders = true;
        this.shutdownLBHttpSolrServer = true;
    }

    public CloudSolrServer(String zkHost, boolean updatesToLeaders) throws MalformedURLException {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.zkHost = zkHost;
        this.myClient = HttpClientUtil.createClient(null);
        this.lbServer = new LBHttpSolrServer(this.myClient, new String[0]);
        this.lbServer.setRequestWriter(new BinaryRequestWriter());
        this.lbServer.setParser(new BinaryResponseParser());
        this.updatesToLeaders = updatesToLeaders;
        this.shutdownLBHttpSolrServer = true;
    }

    public CloudSolrServer(String zkHost, LBHttpSolrServer lbServer) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.zkHost = zkHost;
        this.lbServer = lbServer;
        this.updatesToLeaders = true;
        this.shutdownLBHttpSolrServer = false;
    }

    public CloudSolrServer(String zkHost, LBHttpSolrServer lbServer, boolean updatesToLeaders) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.zkHost = zkHost;
        this.lbServer = lbServer;
        this.updatesToLeaders = updatesToLeaders;
        this.shutdownLBHttpSolrServer = false;
    }

    public ResponseParser getParser() {
        return this.lbServer.getParser();
    }

    public void setParser(ResponseParser processor) {
        this.lbServer.setParser(processor);
    }

    public RequestWriter getRequestWriter() {
        return this.lbServer.getRequestWriter();
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.lbServer.setRequestWriter(requestWriter);
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getIdField() {
        return this.idField;
    }

    public void setDefaultCollection(String collection) {
        this.defaultCollection = collection;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setZkConnectTimeout(int zkConnectTimeout) {
        this.zkConnectTimeout = zkConnectTimeout;
    }

    public void setZkClientTimeout(int zkClientTimeout) {
        this.zkClientTimeout = zkClientTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.zkStateReader == null) {
            CloudSolrServer cloudSolrServer = this;
            synchronized (cloudSolrServer) {
                if (this.zkStateReader == null) {
                    ZkStateReader zk = null;
                    try {
                        zk = new ZkStateReader(this.zkHost, this.zkClientTimeout, this.zkConnectTimeout);
                        zk.createClusterStateWatchersAndUpdate();
                        this.zkStateReader = zk;
                    }
                    catch (InterruptedException e) {
                        if (zk != null) {
                            zk.close();
                        }
                        Thread.currentThread().interrupt();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (KeeperException e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (IOException e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (TimeoutException e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (Exception e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw e;
                    }
                }
            }
        }
    }

    public void setParallelUpdates(boolean parallelUpdates) {
        this.parallelUpdates = parallelUpdates;
    }

    private NamedList directUpdate(AbstractUpdateRequest request, ClusterState clusterState) throws SolrServerException {
        DocCollection col;
        DocRouter router;
        Map<String, String> collectionAliases;
        String collection;
        UpdateRequest updateRequest = (UpdateRequest)request;
        ModifiableSolrParams params = request.getParams();
        ModifiableSolrParams routableParams = new ModifiableSolrParams();
        ModifiableSolrParams nonRoutableParams = new ModifiableSolrParams();
        if (params != null) {
            nonRoutableParams.add(params);
            routableParams.add(params);
            for (String param : this.NON_ROUTABLE_PARAMS) {
                routableParams.remove(param);
            }
        }
        if ((collection = nonRoutableParams.get("collection", this.defaultCollection)) == null) {
            throw new SolrServerException("No collection param specified on request and no default collection has been set.");
        }
        Aliases aliases = this.zkStateReader.getAliases();
        if (aliases != null && (collectionAliases = aliases.getCollectionAliasMap()) != null && collectionAliases.containsKey(collection)) {
            collection = collectionAliases.get(collection);
        }
        if ((router = (col = clusterState.getCollection(collection)).getRouter()) instanceof ImplicitDocRouter) {
            return null;
        }
        Map<String, List<String>> urlMap = this.buildUrlMap(col);
        if (urlMap == null) {
            return null;
        }
        NamedList<Throwable> exceptions = new NamedList<Throwable>();
        NamedList<Object> shardResponses = new NamedList<Object>();
        Map<String, LBHttpSolrServer.Req> routes = updateRequest.getRoutes(router, col, urlMap, routableParams, this.idField);
        if (routes == null) {
            return null;
        }
        long start = System.nanoTime();
        if (this.parallelUpdates) {
            String url;
            HashMap responseFutures = new HashMap(routes.size());
            for (Map.Entry<String, LBHttpSolrServer.Req> entry : routes.entrySet()) {
                url = entry.getKey();
                final LBHttpSolrServer.Req lbRequest = entry.getValue();
                responseFutures.put(url, this.threadPool.submit(new Callable<NamedList<?>>(){

                    @Override
                    public NamedList<?> call() throws Exception {
                        return CloudSolrServer.this.lbServer.request(lbRequest).getResponse();
                    }
                }));
            }
            for (Map.Entry<String, LBHttpSolrServer.Req> entry : responseFutures.entrySet()) {
                url = entry.getKey();
                Future responseFuture = (Future)((Object)entry.getValue());
                try {
                    shardResponses.add(url, responseFuture.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    exceptions.add(url, e.getCause());
                }
            }
            if (exceptions.size() > 0) {
                throw new RouteException(SolrException.ErrorCode.SERVER_ERROR, exceptions, routes);
            }
        } else {
            for (Map.Entry<String, LBHttpSolrServer.Req> entry : routes.entrySet()) {
                String string = entry.getKey();
                LBHttpSolrServer.Req lbRequest = entry.getValue();
                try {
                    NamedList<Object> rsp = this.lbServer.request(lbRequest).getResponse();
                    shardResponses.add(string, rsp);
                }
                catch (Exception e) {
                    throw new SolrServerException(e);
                }
            }
        }
        UpdateRequest nonRoutableRequest = null;
        List<String> deleteQuery = updateRequest.getDeleteQuery();
        if (deleteQuery != null && deleteQuery.size() > 0) {
            UpdateRequest updateRequest2 = new UpdateRequest();
            updateRequest2.setDeleteQuery(deleteQuery);
            nonRoutableRequest = updateRequest2;
        }
        Set<String> set = nonRoutableParams.getParameterNames();
        HashSet<String> intersection = new HashSet<String>(set);
        intersection.retainAll(this.NON_ROUTABLE_PARAMS);
        if (nonRoutableRequest != null || intersection.size() > 0) {
            if (nonRoutableRequest == null) {
                nonRoutableRequest = new UpdateRequest();
            }
            nonRoutableRequest.setParams(nonRoutableParams);
            ArrayList<String> urlList = new ArrayList<String>();
            urlList.addAll(routes.keySet());
            Collections.shuffle(urlList, this.rand);
            LBHttpSolrServer.Req req = new LBHttpSolrServer.Req(nonRoutableRequest, urlList);
            try {
                LBHttpSolrServer.Rsp rsp = this.lbServer.request(req);
                shardResponses.add((String)urlList.get(0), rsp.getResponse());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)urlList.get(0), (Throwable)e);
            }
        }
        long end = System.nanoTime();
        RouteResponse rr = this.condenseResponse(shardResponses, (end - start) / 1000000L);
        rr.setRouteResponses(shardResponses);
        rr.setRoutes(routes);
        return rr;
    }

    private Map<String, List<String>> buildUrlMap(DocCollection col) {
        HashMap<String, List<String>> urlMap = new HashMap<String, List<String>>();
        Collection<Slice> slices = col.getActiveSlices();
        for (Slice slice : slices) {
            String name = slice.getName();
            ArrayList<String> urls = new ArrayList<String>();
            Replica leader = slice.getLeader();
            if (leader == null) {
                return null;
            }
            ZkCoreNodeProps zkProps = new ZkCoreNodeProps(leader);
            String url = zkProps.getCoreUrl();
            urls.add(url);
            Collection<Replica> replicas = slice.getReplicas();
            for (Replica replica : replicas) {
                if (replica.getNodeName().equals(leader.getNodeName()) || replica.getName().equals(leader.getName())) continue;
                ZkCoreNodeProps zkProps1 = new ZkCoreNodeProps(replica);
                String url1 = zkProps1.getCoreUrl();
                urls.add(url1);
            }
            urlMap.put(name, urls);
        }
        return urlMap;
    }

    public RouteResponse condenseResponse(NamedList response, long timeMillis) {
        RouteResponse condensed = new RouteResponse();
        int status = 0;
        Integer rf = null;
        Integer minRf = null;
        for (int i = 0; i < response.size(); ++i) {
            Object rfObj;
            NamedList shardResponse = (NamedList)response.getVal(i);
            NamedList header = (NamedList)shardResponse.get("responseHeader");
            Integer shardStatus = (Integer)header.get("status");
            int s = shardStatus;
            if (s > 0) {
                status = s;
            }
            if ((rfObj = header.get("rf")) != null && rfObj instanceof Integer) {
                Integer routeRf = (Integer)rfObj;
                if (rf == null || routeRf < rf) {
                    rf = routeRf;
                }
            }
            minRf = (Integer)header.get("min_rf");
        }
        NamedList<Number> cheader = new NamedList<Number>();
        cheader.add("status", status);
        cheader.add("QTime", timeMillis);
        if (rf != null) {
            cheader.add("rf", rf);
        }
        if (minRf != null) {
            cheader.add("min_rf", minRf);
        }
        condensed.add("responseHeader", cheader);
        return condensed;
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        SolrParams reqParams;
        this.connect();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        boolean sendToLeaders = false;
        ArrayList<String> replicas = null;
        if (request instanceof IsUpdateRequest) {
            NamedList response;
            if (request instanceof UpdateRequest && (response = this.directUpdate((AbstractUpdateRequest)request, clusterState)) != null) {
                return response;
            }
            sendToLeaders = true;
            replicas = new ArrayList<String>();
        }
        if ((reqParams = request.getParams()) == null) {
            reqParams = new ModifiableSolrParams();
        }
        ArrayList<String> theUrlList = new ArrayList<String>();
        if (request.getPath().equals("/admin/collections") || request.getPath().equals("/admin/cores")) {
            Set<String> liveNodes = clusterState.getLiveNodes();
            for (String liveNode : liveNodes) {
                theUrlList.add(this.zkStateReader.getBaseUrlForNodeName(liveNode));
            }
        } else {
            String collection = reqParams.get("collection", this.defaultCollection);
            if (collection == null) {
                throw new SolrServerException("No collection param specified on request and no default collection has been set.");
            }
            Set<String> collectionsList = this.getCollectionList(clusterState, collection);
            if (collectionsList.size() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection: " + collection);
            }
            String shardKeys = reqParams.get("_route_");
            if (shardKeys == null) {
                shardKeys = reqParams.get("shard.keys");
            }
            HashMap<String, Slice> slices = new HashMap<String, Slice>();
            for (String collectionName : collectionsList) {
                DocCollection col = clusterState.getCollection(collectionName);
                Collection<Slice> routeSlices = col.getRouter().getSearchSlices(shardKeys, reqParams, col);
                ClientUtils.addSlices(slices, collectionName, routeSlices, true);
            }
            Set<String> liveNodes = clusterState.getLiveNodes();
            ArrayList<String> leaderUrlList = null;
            ArrayList<String> urlList = null;
            ArrayList<String> replicasList = null;
            HashMap<String, ZkNodeProps> nodes = new HashMap<String, ZkNodeProps>();
            ArrayList<String> urlList2 = new ArrayList<String>();
            for (Slice slice : slices.values()) {
                for (ZkNodeProps zkNodeProps : slice.getReplicasMap().values()) {
                    String url;
                    ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps(zkNodeProps);
                    String node = coreNodeProps.getNodeName();
                    if (!liveNodes.contains(coreNodeProps.getNodeName()) || !coreNodeProps.getState().equals("active") || nodes.put(node, zkNodeProps) != null) continue;
                    if (!sendToLeaders || sendToLeaders && coreNodeProps.isLeader()) {
                        url = reqParams.get("collection") == null ? ZkCoreNodeProps.getCoreUrl(zkNodeProps.getStr("base_url"), this.defaultCollection) : coreNodeProps.getCoreUrl();
                        urlList2.add(url);
                        continue;
                    }
                    if (!sendToLeaders) continue;
                    url = reqParams.get("collection") == null ? ZkCoreNodeProps.getCoreUrl(zkNodeProps.getStr("base_url"), this.defaultCollection) : coreNodeProps.getCoreUrl();
                    replicas.add(url);
                }
            }
            if (sendToLeaders) {
                leaderUrlList = urlList2;
                replicasList = replicas;
            } else {
                urlList = urlList2;
            }
            if (sendToLeaders) {
                theUrlList = new ArrayList(leaderUrlList.size());
                theUrlList.addAll(leaderUrlList);
            } else {
                theUrlList = new ArrayList(urlList.size());
                theUrlList.addAll(urlList);
            }
            Collections.shuffle(theUrlList, this.rand);
            if (sendToLeaders) {
                ArrayList<String> theReplicas = new ArrayList<String>(replicasList.size());
                theReplicas.addAll(replicasList);
                Collections.shuffle(theReplicas, this.rand);
                theUrlList.addAll(theReplicas);
            }
        }
        LBHttpSolrServer.Req req = new LBHttpSolrServer.Req(request, theUrlList);
        LBHttpSolrServer.Rsp rsp = this.lbServer.request(req);
        return rsp.getResponse();
    }

    private Set<String> getCollectionList(ClusterState clusterState, String collection) {
        List<String> rawCollectionsList = StrUtils.splitSmart(collection, ",", true);
        HashSet<String> collectionsList = new HashSet<String>();
        for (String collectionName : rawCollectionsList) {
            if (!clusterState.getCollections().contains(collectionName)) {
                Aliases aliases = this.zkStateReader.getAliases();
                String alias = aliases.getCollectionAlias(collectionName);
                if (alias != null) {
                    List<String> aliasList = StrUtils.splitSmart(alias, ",", true);
                    collectionsList.addAll(aliasList);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + collectionName);
            }
            collectionsList.add(collectionName);
        }
        return collectionsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.zkStateReader != null) {
            CloudSolrServer cloudSolrServer = this;
            synchronized (cloudSolrServer) {
                if (this.zkStateReader != null) {
                    this.zkStateReader.close();
                }
                this.zkStateReader = null;
            }
        }
        if (this.shutdownLBHttpSolrServer) {
            this.lbServer.shutdown();
        }
        if (this.myClient != null) {
            this.myClient.getConnectionManager().shutdown();
        }
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
        }
    }

    public LBHttpSolrServer getLbServer() {
        return this.lbServer;
    }

    public boolean isUpdatesToLeaders() {
        return this.updatesToLeaders;
    }

    public int getMinAchievedReplicationFactor(String collection, NamedList resp) {
        NamedList header = (NamedList)resp.get("responseHeader");
        Integer achRf = (Integer)header.get("rf");
        if (achRf != null) {
            return achRf;
        }
        Map<String, Integer> shardRf = this.getShardReplicationFactor(collection, resp);
        for (Integer rf : shardRf.values()) {
            if (achRf != null && rf >= achRf) continue;
            achRf = rf;
        }
        return achRf != null ? achRf : -1;
    }

    public Map<String, Integer> getShardReplicationFactor(String collection, NamedList resp) {
        this.connect();
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        if (resp instanceof RouteResponse) {
            NamedList routes = ((RouteResponse)resp).getRouteResponses();
            ClusterState clusterState = this.zkStateReader.getClusterState();
            HashMap<String, String> leaders = new HashMap<String, String>();
            for (Slice slice : clusterState.getActiveSlices(collection)) {
                Replica leader = slice.getLeader();
                if (leader == null) continue;
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(leader);
                String leaderUrl = zkProps.getBaseUrl() + "/" + zkProps.getCoreName();
                leaders.put(leaderUrl, slice.getName());
                String altLeaderUrl = zkProps.getBaseUrl() + "/" + collection;
                leaders.put(altLeaderUrl, slice.getName());
            }
            for (Map.Entry next : routes) {
                String host = next.getKey();
                NamedList hostResp = (NamedList)next.getValue();
                Integer rf = (Integer)((NamedList)hostResp.get("responseHeader")).get("rf");
                if (rf == null) continue;
                String shard = (String)leaders.get(host);
                if (shard == null) {
                    if (host.endsWith("/")) {
                        shard = (String)leaders.get(host.substring(0, host.length() - 1));
                    }
                    if (shard == null) {
                        shard = host;
                    }
                }
                results.put(shard, rf);
            }
        }
        return results;
    }

    public static class RouteException
    extends SolrException {
        private NamedList<Throwable> throwables;
        private Map<String, LBHttpSolrServer.Req> routes;

        public RouteException(SolrException.ErrorCode errorCode, NamedList<Throwable> throwables, Map<String, LBHttpSolrServer.Req> routes) {
            super(errorCode, throwables.getVal(0).getMessage(), throwables.getVal(0));
            this.throwables = throwables;
            this.routes = routes;
        }

        public NamedList<Throwable> getThrowables() {
            return this.throwables;
        }

        public Map<String, LBHttpSolrServer.Req> getRoutes() {
            return this.routes;
        }
    }

    public static class RouteResponse
    extends NamedList {
        private NamedList routeResponses;
        private Map<String, LBHttpSolrServer.Req> routes;

        public void setRouteResponses(NamedList routeResponses) {
            this.routeResponses = routeResponses;
        }

        public NamedList getRouteResponses() {
            return this.routeResponses;
        }

        public void setRoutes(Map<String, LBHttpSolrServer.Req> routes) {
            this.routes = routes;
        }

        public Map<String, LBHttpSolrServer.Req> getRoutes() {
            return this.routes;
        }
    }
}

