/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;

public final class ExtractURIQueryParametersBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("extractURIQueryParameters");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ExtractURIQueryParameters(this, config, parent, child, context);
    }

    private static final class ExtractURIQueryParameters
    extends AbstractCommand {
        private final String parameterName;
        private final String inputFieldName;
        private final String outputFieldName;
        private final int maxParameters;
        private final String charset;
        private final boolean failOnInvalidURI;

        public ExtractURIQueryParameters(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.parameterName = this.getConfigs().getString(config, "parameter");
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.outputFieldName = this.getConfigs().getString(config, "outputField");
            this.failOnInvalidURI = this.getConfigs().getBoolean(config, "failOnInvalidURI", false);
            this.maxParameters = this.getConfigs().getInt(config, "maxParameters", Integer.MAX_VALUE);
            this.charset = this.getConfigs().getString(config, "charset", "UTF-8");
            Charset.forName(this.charset);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Object uri : record.get(this.inputFieldName)) {
                String rawURIQuery;
                block7: {
                    rawURIQuery = "";
                    try {
                        rawURIQuery = new URI(uri.toString()).getRawQuery();
                    }
                    catch (URISyntaxException e) {
                        this.LOG.debug("Invalid URI: {}", uri);
                        if (!this.failOnInvalidURI) break block7;
                        return false;
                    }
                }
                if (rawURIQuery == null) {
                    rawURIQuery = "";
                }
                int len = rawURIQuery.length();
                int numParameters = 0;
                for (int i = 0; numParameters < this.maxParameters && i < len; ++i) {
                    int j = rawURIQuery.indexOf(38, i);
                    if (j < 0) {
                        j = len;
                    }
                    for (int k = i; k < j; ++k) {
                        if (rawURIQuery.charAt(k) != '=') continue;
                        String key = this.decodeString(rawURIQuery.substring(i, k));
                        if (!this.parameterName.equals(key)) break;
                        String value = this.decodeString(rawURIQuery.substring(k + 1, j));
                        record.put(this.outputFieldName, value);
                        ++numParameters;
                        break;
                    }
                    i = j;
                }
            }
            return super.doProcess(record);
        }

        private String decodeString(String str) {
            try {
                return URLDecoder.decode(str, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

