/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.shaded.com.googlecode.jcsv.fastreader.CSVTokenizer;

public final class SimpleCSVTokenizer
implements CSVTokenizer {
    private final char separatorChar;
    private final boolean trim;
    private final List<String> columnNames;
    private final boolean addEmptyStrings;

    public SimpleCSVTokenizer(char separatorChar, boolean trim, boolean addEmptyStrings, List<String> columnNames) {
        this.separatorChar = separatorChar;
        this.trim = trim;
        this.addEmptyStrings = addEmptyStrings;
        this.columnNames = columnNames;
    }

    @Override
    public void tokenizeLine(String line, BufferedReader reader, Record record) throws IOException {
        char separator = this.separatorChar;
        int len = line.length();
        int start = 0;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if (line.charAt(i) != separator) continue;
            this.put(line, start, i, j, record);
            start = i + 1;
            ++j;
        }
        this.put(line, start, len, j, record);
    }

    private void put(String line, int start, int i, int j, Record record) {
        String columnName;
        if (j >= this.columnNames.size()) {
            this.columnNames.add("column" + j);
        }
        if ((columnName = this.columnNames.get(j)).length() != 0) {
            String col = line.substring(start, i);
            String string = col = this.trim ? col.trim() : col;
            if (col.length() > 0 || this.addEmptyStrings) {
                record.put(columnName, col);
            }
        }
    }
}

