/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.skeleton;

import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.skeleton.SkeletonPacket;

public class SkeletonFishead
extends HighLevelOggStreamPacket
implements SkeletonPacket {
    private int versionMajor;
    private int versionMinor;
    private long presentationTimeNumerator;
    private long presentationTimeDenominator;
    private long baseTimeNumerator;
    private long baseTimeDenominator;
    private long utc1;
    private long utc2;
    private long utc3;
    private long segmentLength;
    private long contentOffset;

    public SkeletonFishead() {
        this.versionMajor = 4;
        this.versionMinor = 0;
    }

    public SkeletonFishead(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        if (!IOUtils.byteRangeMatches(MAGIC_FISHEAD_BYTES, data, 0)) {
            throw new IllegalArgumentException("Invalid type, not a Skeleton Fishead Header");
        }
        this.versionMajor = IOUtils.getInt2(data, 8);
        this.versionMinor = IOUtils.getInt2(data, 10);
        if (this.versionMajor < 3 || this.versionMajor > 4) {
            throw new IllegalArgumentException("Unsupported Skeleton version " + this.versionMajor + " detected");
        }
        this.presentationTimeNumerator = IOUtils.getInt8(data, 12);
        this.presentationTimeDenominator = IOUtils.getInt8(data, 20);
        this.baseTimeNumerator = IOUtils.getInt8(data, 28);
        this.baseTimeDenominator = IOUtils.getInt8(data, 36);
        this.utc1 = IOUtils.getInt8(data, 44);
        this.utc2 = IOUtils.getInt8(data, 52);
        this.utc3 = IOUtils.getInt4(data, 60);
        if (this.versionMajor == 4) {
            this.segmentLength = IOUtils.getInt8(data, 64);
            this.contentOffset = IOUtils.getInt8(data, 72);
        }
    }

    public OggPacket write() {
        int len = 64;
        if (this.versionMajor == 4) {
            len = 80;
        }
        byte[] data = new byte[len];
        IOUtils.putUTF8(data, 0, "fishead\u0000");
        IOUtils.putInt2(data, 8, this.versionMajor);
        IOUtils.putInt2(data, 10, this.versionMinor);
        IOUtils.putInt8(data, 12, this.presentationTimeNumerator);
        IOUtils.putInt8(data, 20, this.presentationTimeDenominator);
        IOUtils.putInt8(data, 28, this.baseTimeNumerator);
        IOUtils.putInt8(data, 36, this.baseTimeDenominator);
        IOUtils.putInt8(data, 44, this.utc1);
        IOUtils.putInt8(data, 52, this.utc2);
        IOUtils.putInt4(data, 60, this.utc3);
        if (this.versionMajor == 4) {
            IOUtils.putInt8(data, 64, this.segmentLength);
            IOUtils.putInt8(data, 72, this.contentOffset);
        }
        this.setData(data);
        return super.write();
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(int versionMajor) {
        this.versionMajor = versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(int versionMinor) {
        this.versionMinor = versionMinor;
    }

    public long getPresentationTimeNumerator() {
        return this.presentationTimeNumerator;
    }

    public void setPresentationTimeNumerator(long presentationTimeNumerator) {
        this.presentationTimeNumerator = presentationTimeNumerator;
    }

    public long getPresentationTimeDenominator() {
        return this.presentationTimeDenominator;
    }

    public void setPresentationTimeDenominator(long presentationTimeDenominator) {
        this.presentationTimeDenominator = presentationTimeDenominator;
    }

    public long getBaseTimeNumerator() {
        return this.baseTimeNumerator;
    }

    public void setBaseTimeNumerator(long baseTimeNumerator) {
        this.baseTimeNumerator = baseTimeNumerator;
    }

    public long getBaseTimeDenominator() {
        return this.baseTimeDenominator;
    }

    public void setBaseTimeDenominator(long baseTimeDenominator) {
        this.baseTimeDenominator = baseTimeDenominator;
    }

    public long getUtc1() {
        return this.utc1;
    }

    public void setUtc1(long utc1) {
        this.utc1 = utc1;
    }

    public long getUtc2() {
        return this.utc2;
    }

    public void setUtc2(long utc2) {
        this.utc2 = utc2;
    }

    public long getUtc3() {
        return this.utc3;
    }

    public void setUtc3(long utc3) {
        this.utc3 = utc3;
    }

    public long getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(long segmentLength) {
        this.segmentLength = segmentLength;
    }

    public long getContentOffset() {
        return this.contentOffset;
    }

    public void setContentOffset(long contentOffset) {
        this.contentOffset = contentOffset;
    }
}

