/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.ImageIOUtil;

public class PDPixelMap
extends PDXObjectImage {
    private static final Log LOG = LogFactory.getLog(PDPixelMap.class);
    private BufferedImage image = null;
    private static final String PNG = "png";

    public PDPixelMap(PDStream pdStream) {
        super(pdStream, PNG);
    }

    public PDPixelMap(PDDocument doc, BufferedImage bi) throws IOException {
        super(doc, PNG);
        this.createImageStream(doc, bi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createImageStream(PDDocument doc, BufferedImage bi) throws IOException {
        BufferedImage alphaImage = null;
        BufferedImage rgbImage = null;
        int width = bi.getWidth();
        int height = bi.getHeight();
        if (bi.getColorModel().hasAlpha()) {
            WritableRaster alphaRaster = bi.getAlphaRaster();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            alphaImage = new BufferedImage(cm, alphaRaster, false, null);
            rgbImage = new BufferedImage(width, height, 5);
            Graphics2D g = rgbImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)bi, 0, 0, null);
        } else {
            rgbImage = bi;
        }
        OutputStream os = null;
        try {
            int numberOfComponents = rgbImage.getColorModel().getNumComponents();
            if (numberOfComponents == 3) {
                this.setColorSpace(PDDeviceRGB.INSTANCE);
            } else {
                if (numberOfComponents != 1) throw new IllegalStateException();
                this.setColorSpace(new PDDeviceGray());
            }
            byte[] outData = new byte[width * height * numberOfComponents];
            rgbImage.getData().getDataElements(0, 0, width, height, outData);
            this.getPDStream().addCompression();
            os = this.getCOSStream().createUnfilteredStream();
            os.write(outData);
            COSStream dic = this.getCOSStream();
            dic.setItem(COSName.FILTER, (COSBase)COSName.FLATE_DECODE);
            dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
            dic.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
            if (alphaImage != null) {
                PDPixelMap smask = new PDPixelMap(doc, alphaImage);
                dic.setItem(COSName.SMASK, (COSObjectable)smask);
            }
            this.setBitsPerComponent(8);
            this.setHeight(height);
            this.setWidth(width);
            Object var13_13 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (os == null) throw throwable;
            os.close();
            throw throwable;
        }
        os.close();
    }

    public BufferedImage getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        try {
            byte[] map;
            byte[] array = this.getPDStream().getByteArray();
            if (array.length == 0) {
                LOG.error((Object)"Something went wrong ... the pixelmap doesn't contain any data.");
                return null;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            int bpc = this.getBitsPerComponent();
            PDColorSpace colorspace = this.getColorSpace();
            if (colorspace == null) {
                LOG.error((Object)"getColorSpace() returned NULL.");
                return null;
            }
            ColorModel cm = null;
            if (colorspace instanceof PDIndexed) {
                PDIndexed csIndexed = (PDIndexed)colorspace;
                COSBase maskArray = this.getMask();
                cm = maskArray != null && maskArray instanceof COSArray ? csIndexed.createColorModel(bpc, ((COSArray)maskArray).getInt(0)) : csIndexed.createColorModel(bpc);
            } else if (colorspace instanceof PDSeparation) {
                PDSeparation csSeparation = (PDSeparation)colorspace;
                int numberOfComponents = csSeparation.getAlternateColorSpace().getNumberOfComponents();
                PDFunction tintTransformFunc = csSeparation.getTintTransform();
                COSArray decode = this.getDecode();
                boolean invert = decode != null && decode.getInt(0) == 1;
                int maxValue = (int)Math.pow(2.0, bpc) - 1;
                byte[] mappedData = new byte[width * height * numberOfComponents];
                int rowLength = width * numberOfComponents;
                float[] input = new float[1];
                for (int i = 0; i < height; ++i) {
                    int rowOffset = i * rowLength;
                    for (int j = 0; j < width; ++j) {
                        int value = (array[i * width + j] + 256) % 256;
                        input[0] = invert ? (float)(1 - value / maxValue) : (float)(value / maxValue);
                        float[] mappedColor = tintTransformFunc.eval(input);
                        int columnOffset = j * numberOfComponents;
                        for (int k = 0; k < numberOfComponents; ++k) {
                            float mappedValue = mappedColor[k];
                            mappedData[rowOffset + columnOffset + k] = (byte)(mappedValue * (float)maxValue);
                        }
                    }
                }
                array = mappedData;
                cm = colorspace.createColorModel(bpc);
            } else if (bpc == 1) {
                COSArray decode;
                map = null;
                map = colorspace instanceof PDDeviceGray ? ((decode = this.getDecode()) != null && decode.getInt(0) == 1 ? new byte[]{-1} : new byte[]{0, -1}) : new byte[]{0, -1};
                cm = new IndexColorModel(bpc, map.length, map, map, map, 1);
            } else if (colorspace instanceof PDICCBased) {
                if (((PDICCBased)colorspace).getNumberOfComponents() == 1) {
                    map = new byte[]{-1};
                    cm = new IndexColorModel(bpc, 1, map, map, map, 1);
                } else {
                    cm = colorspace.createColorModel(bpc);
                }
            } else {
                cm = colorspace.createColorModel(bpc);
            }
            LOG.debug((Object)("ColorModel: " + cm.toString()));
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
            byte[] bufferData = buffer.getData();
            System.arraycopy(array, 0, bufferData, 0, array.length < bufferData.length ? array.length : bufferData.length);
            this.image = new BufferedImage(cm, raster, false, null);
            return this.applyMasks(this.image);
        }
        catch (Exception exception) {
            LOG.error((Object)exception, (Throwable)exception);
            return null;
        }
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIOUtil.writeImage(this.image, PNG, out);
        }
    }

    public COSDictionary getDecodeParams() {
        COSBase decodeParms = this.getCOSStream().getDictionaryObject(COSName.DECODE_PARMS);
        if (decodeParms != null) {
            if (decodeParms instanceof COSDictionary) {
                return (COSDictionary)decodeParms;
            }
            if (decodeParms instanceof COSArray) {
                return null;
            }
            return null;
        }
        return null;
    }

    public int getPredictor() {
        int i;
        COSDictionary decodeParms = this.getDecodeParams();
        if (decodeParms != null && (i = decodeParms.getInt(COSName.PREDICTOR)) != -1) {
            return i;
        }
        return 1;
    }
}

