/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.helper.ASCIITextWidthCounter;
import net.sourceforge.argparse4j.helper.PrefixPattern;
import net.sourceforge.argparse4j.helper.ReflectHelper;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TextWidthCounter;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.ArgumentGroupImpl;
import net.sourceforge.argparse4j.internal.ArgumentImpl;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import net.sourceforge.argparse4j.internal.ParseState;
import net.sourceforge.argparse4j.internal.SubparsersImpl;
import net.sourceforge.argparse4j.internal.UnrecognizedArgumentException;
import net.sourceforge.argparse4j.internal.UnrecognizedCommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentParserImpl
implements ArgumentParser {
    private Map<String, ArgumentImpl> optargIndex_ = new HashMap<String, ArgumentImpl>();
    private List<ArgumentImpl> optargs_ = new ArrayList<ArgumentImpl>();
    private List<ArgumentImpl> posargs_ = new ArrayList<ArgumentImpl>();
    private List<ArgumentGroupImpl> arggroups_ = new ArrayList<ArgumentGroupImpl>();
    private Map<String, Object> defaults_ = new HashMap<String, Object>();
    private SubparsersImpl subparsers_ = new SubparsersImpl(this);
    private ArgumentParserImpl mainParser_;
    private String command_;
    private String prog_;
    private String usage_ = "";
    private String description_ = "";
    private String epilog_ = "";
    private String version_ = "";
    private PrefixPattern prefixPattern_;
    private PrefixPattern fromFilePrefixPattern_;
    private boolean defaultHelp_ = false;
    private boolean negNumFlag_ = false;
    private TextWidthCounter textWidthCounter_;
    private static final Pattern NEG_NUM_PATTERN = Pattern.compile("-\\d+");
    private static final Pattern SHORT_OPTS_PATTERN = Pattern.compile("-[^-].*");

    public ArgumentParserImpl(String prog) {
        this(prog, true, "-", null, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp) {
        this(prog, addHelp, "-", null, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars) {
        this(prog, addHelp, prefixChars, null, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars, String fromFilePrefix) {
        this(prog, addHelp, prefixChars, fromFilePrefix, new ASCIITextWidthCounter(), null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars, String fromFilePrefix, TextWidthCounter textWidthCounter) {
        this(prog, addHelp, prefixChars, fromFilePrefix, textWidthCounter, null, null);
    }

    public ArgumentParserImpl(String prog, boolean addHelp, String prefixChars, String fromFilePrefix, TextWidthCounter textWidthCounter, String command, ArgumentParserImpl mainParser) {
        this.prog_ = TextHelper.nonNull(prog);
        this.command_ = command;
        this.mainParser_ = mainParser;
        this.textWidthCounter_ = textWidthCounter;
        if (prefixChars == null || prefixChars.isEmpty()) {
            throw new IllegalArgumentException("prefixChars cannot be a null or empty");
        }
        this.prefixPattern_ = new PrefixPattern(prefixChars);
        if (fromFilePrefix != null) {
            this.fromFilePrefixPattern_ = new PrefixPattern(fromFilePrefix);
        }
        if (addHelp) {
            String prefix = prefixChars.substring(0, 1);
            this.addArgument(prefix + "h", prefix + prefix + "help").action(Arguments.help()).help("show this help message and exit").setDefault(Arguments.SUPPRESS);
        }
    }

    @Override
    public ArgumentImpl addArgument(String ... nameOrFlags) {
        return this.addArgument((ArgumentGroupImpl)null, nameOrFlags);
    }

    public ArgumentImpl addArgument(ArgumentGroupImpl group, String ... nameOrFlags) {
        ArgumentImpl arg = new ArgumentImpl(this.prefixPattern_, group, nameOrFlags);
        if (arg.isOptionalArgument()) {
            for (String flag : arg.getFlags()) {
                ArgumentImpl another = this.optargIndex_.get(flag);
                if (another == null) continue;
                throw new IllegalArgumentException(String.format((Locale)null, "argument %s: conflicting option string(s): %s", flag, another.textualName()));
            }
            for (String flag : arg.getFlags()) {
                if (NEG_NUM_PATTERN.matcher(flag).matches()) {
                    this.negNumFlag_ = true;
                }
                this.optargIndex_.put(flag, arg);
            }
            this.optargs_.add(arg);
        } else {
            for (ArgumentImpl another : this.posargs_) {
                if (!arg.getName().equals(another.getName())) continue;
                throw new IllegalArgumentException(String.format((Locale)null, "argument %s: conflicting option string(s): %s", arg.getName(), another.textualName()));
            }
            this.posargs_.add(arg);
        }
        return arg;
    }

    @Override
    public SubparsersImpl addSubparsers() {
        return this.subparsers_;
    }

    @Override
    public ArgumentGroup addArgumentGroup(String title) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title);
        group.setIndex(this.arggroups_.size());
        this.arggroups_.add(group);
        return group;
    }

    @Override
    public MutuallyExclusiveGroup addMutuallyExclusiveGroup() {
        return this.addMutuallyExclusiveGroup("");
    }

    @Override
    public MutuallyExclusiveGroup addMutuallyExclusiveGroup(String title) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title);
        group.setIndex(this.arggroups_.size());
        group.setMutex(true);
        this.arggroups_.add(group);
        return group;
    }

    @Override
    public ArgumentParserImpl usage(String usage) {
        this.usage_ = TextHelper.nonNull(usage);
        return this;
    }

    @Override
    public ArgumentParserImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    @Override
    public ArgumentParserImpl epilog(String epilog) {
        this.epilog_ = TextHelper.nonNull(epilog);
        return this;
    }

    @Override
    public ArgumentParserImpl version(String version) {
        this.version_ = TextHelper.nonNull(version);
        return this;
    }

    @Override
    public ArgumentParserImpl defaultHelp(boolean defaultHelp) {
        this.defaultHelp_ = defaultHelp;
        return this;
    }

    public boolean isDefaultHelp() {
        return this.defaultHelp_;
    }

    private void printArgumentHelp(PrintWriter writer, List<ArgumentImpl> args, int format_width) {
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isSeparateHelp()) continue;
            arg.printHelp(writer, this.defaultHelp_, this.textWidthCounter_, format_width);
        }
    }

    @Override
    public void printHelp() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printHelp(writer);
        writer.flush();
    }

    @Override
    public void printHelp(PrintWriter writer) {
        boolean subparsersUntitled;
        int formatWidth = ArgumentParsers.getFormatWidth();
        this.printUsage(writer, formatWidth);
        if (!this.description_.isEmpty()) {
            writer.println();
            writer.println(TextHelper.wrap(this.textWidthCounter_, this.description_, formatWidth, 0, "", ""));
        }
        boolean bl = subparsersUntitled = this.subparsers_.getTitle().isEmpty() && this.subparsers_.getDescription().isEmpty();
        if (this.checkDefaultGroup(this.posargs_) || this.subparsers_.hasSubCommand() && subparsersUntitled) {
            writer.println();
            writer.println("positional arguments:");
            this.printArgumentHelp(writer, this.posargs_, formatWidth);
            if (this.subparsers_.hasSubCommand() && subparsersUntitled) {
                this.subparsers_.printSubparserHelp(writer, formatWidth);
            }
        }
        if (this.checkDefaultGroup(this.optargs_)) {
            writer.println();
            writer.println("optional arguments:");
            this.printArgumentHelp(writer, this.optargs_, formatWidth);
        }
        if (this.subparsers_.hasSubCommand() && !subparsersUntitled) {
            writer.println();
            writer.print(this.subparsers_.getTitle().isEmpty() ? "subcommands" : this.subparsers_.getTitle());
            writer.println(":");
            if (!this.subparsers_.getDescription().isEmpty()) {
                writer.print("  ");
                writer.println(TextHelper.wrap(this.textWidthCounter_, this.subparsers_.getDescription(), formatWidth, 2, "", "  "));
                writer.println();
            }
            this.subparsers_.printSubparserHelp(writer, formatWidth);
        }
        for (ArgumentGroupImpl group : this.arggroups_) {
            if (!group.isSeparateHelp()) continue;
            writer.println();
            group.printHelp(writer, formatWidth);
        }
        if (!this.epilog_.isEmpty()) {
            writer.println();
            writer.println(TextHelper.wrap(this.textWidthCounter_, this.epilog_, formatWidth, 0, "", ""));
        }
    }

    private boolean checkDefaultGroup(List<ArgumentImpl> args) {
        if (args.isEmpty()) {
            return false;
        }
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isSeparateHelp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String formatHelp() {
        StringWriter writer = new StringWriter();
        this.printHelp(new PrintWriter(writer));
        return writer.toString();
    }

    private void printArgumentUsage(PrintWriter writer, List<String> opts, int offset, String firstIndent, String subsequentIndent, int format_width) {
        int currentWidth = offset + firstIndent.length();
        writer.print(firstIndent);
        boolean first = true;
        for (String syntax : opts) {
            if (!first && currentWidth + syntax.length() + 1 > format_width) {
                writer.println();
                writer.print(subsequentIndent);
                writer.print(" ");
                writer.print(syntax);
                currentWidth = subsequentIndent.length() + 1 + syntax.length();
                continue;
            }
            writer.print(" ");
            writer.print(syntax);
            currentWidth += 1 + syntax.length();
            first = false;
        }
        writer.println();
    }

    @Override
    public void printUsage() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printUsage(writer);
        writer.flush();
    }

    @Override
    public void printUsage(PrintWriter writer) {
        this.printUsage(writer, ArgumentParsers.getFormatWidth());
    }

    private void printUsage(PrintWriter writer, int format_width) {
        String firstIndent;
        String subsequentIndent;
        int offset;
        if (!this.usage_.isEmpty()) {
            writer.print("usage: ");
            writer.println(this.substitutePlaceholder(this.usage_));
            return;
        }
        String usageprog = "usage: " + this.prog_;
        writer.print(usageprog);
        String indent = "                              ";
        int usageprogWidth = this.textWidthCounter_.width(usageprog);
        if (usageprogWidth > indent.length()) {
            writer.println();
            offset = 6;
            firstIndent = subsequentIndent = indent.substring(0, offset);
        } else {
            offset = usageprogWidth;
            firstIndent = "";
            subsequentIndent = indent.substring(0, offset);
        }
        ArrayList<String> opts = new ArrayList<String>();
        this.addUpperParserUsage(opts, this.mainParser_);
        if (this.command_ != null) {
            opts.add(this.command_);
        }
        for (ArgumentImpl arg : this.optargs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS || arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) continue;
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentGroupImpl group : this.arggroups_) {
            List<ArgumentImpl> args = ArgumentParserImpl.filterSuppressedArgs(group.getArgs());
            int numArgs = args.size();
            if (!group.isMutex()) continue;
            if (numArgs > 1) {
                opts.add((group.isRequired() ? "(" : "[") + args.get(0).formatShortSyntaxNoBracket());
                for (int i = 1; i < numArgs - 1; ++i) {
                    ArgumentImpl arg = args.get(i);
                    opts.add("|");
                    opts.add(arg.formatShortSyntaxNoBracket());
                }
                opts.add("|");
                opts.add(args.get(numArgs - 1).formatShortSyntaxNoBracket() + (group.isRequired() ? ")" : "]"));
                continue;
            }
            if (numArgs != 1) continue;
            if (group.isRequired()) {
                opts.add(args.get(0).formatShortSyntaxNoBracket());
                continue;
            }
            opts.add(args.get(0).formatShortSyntax());
        }
        for (ArgumentImpl arg : this.posargs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            opts.add(arg.formatShortSyntax());
        }
        if (this.subparsers_.hasSubCommand()) {
            opts.add(this.subparsers_.formatShortSyntax());
            opts.add("...");
        }
        this.printArgumentUsage(writer, opts, offset, firstIndent, subsequentIndent, format_width);
    }

    private static List<ArgumentImpl> filterSuppressedArgs(Collection<ArgumentImpl> args) {
        ArrayList<ArgumentImpl> res = new ArrayList<ArgumentImpl>();
        for (ArgumentImpl arg : args) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            res.add(arg);
        }
        return res;
    }

    private void addUpperParserUsage(List<String> opts, ArgumentParserImpl parser) {
        if (parser == null) {
            return;
        }
        this.addUpperParserUsage(opts, parser.mainParser_);
        if (parser.command_ != null) {
            opts.add(parser.command_);
        }
        for (ArgumentImpl arg : parser.optargs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS || !arg.isRequired() || arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) continue;
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentGroupImpl group : parser.arggroups_) {
            List<ArgumentImpl> args = ArgumentParserImpl.filterSuppressedArgs(group.getArgs());
            int numArgs = args.size();
            if (!group.isMutex()) continue;
            if (numArgs > 1) {
                if (!group.isRequired()) continue;
                opts.add("(" + args.get(0).formatShortSyntaxNoBracket());
                for (int i = 1; i < numArgs - 1; ++i) {
                    ArgumentImpl arg = args.get(i);
                    opts.add("|");
                    opts.add(arg.formatShortSyntaxNoBracket());
                }
                opts.add("|");
                opts.add(args.get(numArgs - 1).formatShortSyntaxNoBracket() + ")");
                continue;
            }
            if (numArgs != 1) continue;
            if (group.isRequired()) {
                opts.add(args.get(0).formatShortSyntaxNoBracket());
                continue;
            }
            if (!args.get(0).isRequired()) continue;
            opts.add(args.get(0).formatShortSyntax());
        }
        for (ArgumentImpl arg : parser.posargs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            opts.add(arg.formatShortSyntax());
        }
    }

    @Override
    public String formatUsage() {
        StringWriter writer = new StringWriter();
        this.printUsage(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public ArgumentParserImpl setDefault(String dest, Object value) {
        this.defaults_.put(dest, value);
        return this;
    }

    @Override
    public ArgumentParserImpl setDefaults(Map<String, Object> attrs) {
        this.defaults_.putAll(attrs);
        return this;
    }

    @Override
    public Object getDefault(String dest) {
        for (ArgumentImpl arg : this.optargs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        for (ArgumentImpl arg : this.posargs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        return this.defaults_.get(dest);
    }

    @Override
    public Namespace parseArgsOrFail(String[] args) {
        try {
            Namespace ns = this.parseArgs(args);
            return ns;
        }
        catch (ArgumentParserException e) {
            this.handleError(e);
            System.exit(1);
            return null;
        }
    }

    @Override
    public Namespace parseArgs(String[] args) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseArgs(args, attrs);
        return new Namespace(attrs);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs) throws ArgumentParserException {
        this.parseArgs(args, 0, attrs);
    }

    @Override
    public void parseArgs(String[] args, Object userData) throws ArgumentParserException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        this.parseArgs(args, opts, userData);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs, Object userData) throws ArgumentParserException {
        this.parseArgs(args, 0, attrs);
        for (Class<?> userClass = userData.getClass(); userClass != null; userClass = userClass.getSuperclass()) {
            Object val;
            String argDest;
            Arg ann;
            for (final Field field : userClass.getDeclaredFields()) {
                ann = field.getAnnotation(Arg.class);
                if (ann == null) continue;
                argDest = ann.dest();
                if (argDest.isEmpty()) {
                    argDest = field.getName();
                }
                if (!attrs.containsKey(argDest)) continue;
                val = attrs.get(argDest);
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            field.setAccessible(true);
                            return null;
                        }
                    });
                    field.set(userData, ReflectHelper.list2Array(field.getType(), val));
                }
                catch (RuntimeException e) {
                    if (ann.ignoreError()) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (ann.ignoreError()) continue;
                    throw new IllegalArgumentException(String.format((Locale)null, "Could not set %s to field %s", val, field.getName()), e);
                }
            }
            for (AccessibleObject accessibleObject : userClass.getDeclaredMethods()) {
                ann = ((Method)accessibleObject).getAnnotation(Arg.class);
                if (ann == null) continue;
                argDest = ann.dest();
                if (argDest.isEmpty()) {
                    argDest = ((Method)accessibleObject).getName();
                }
                if (!attrs.containsKey(argDest)) continue;
                val = attrs.get(argDest);
                Class<?>[] fargs = ((Method)accessibleObject).getParameterTypes();
                if (fargs.length != 1) {
                    throw new IllegalArgumentException(String.format((Locale)null, "Method %s must have one formal parameter", ((Method)accessibleObject).getName()));
                }
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>((Method)accessibleObject){
                        final /* synthetic */ Method val$method;
                        {
                            this.val$method = method;
                        }

                        @Override
                        public Void run() {
                            this.val$method.setAccessible(true);
                            return null;
                        }
                    });
                    ((Method)accessibleObject).invoke(userData, ReflectHelper.list2Array(fargs[0], val));
                }
                catch (RuntimeException e) {
                    if (ann.ignoreError()) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (ann.ignoreError()) continue;
                    throw new IllegalArgumentException(String.format((Locale)null, "Could not call method %s with %s", ((Method)accessibleObject).getName(), val), e);
                }
            }
        }
    }

    public void parseArgs(String[] args, int offset, Map<String, Object> attrs) throws ArgumentParserException {
        ParseState state = new ParseState(args, offset, this.negNumFlag_);
        this.parseArgs(state, attrs);
    }

    private boolean checkConcatenatedShortOpts(String term) {
        if (SHORT_OPTS_PATTERN.matcher(term).matches()) {
            int termlen = term.length();
            for (int i = 1; i < termlen; ++i) {
                String shortFlag = "-" + term.charAt(i);
                ArgumentImpl arg = this.optargIndex_.get(shortFlag);
                if (arg == null) {
                    return false;
                }
                if (!arg.getAction().consumeArgument()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private ArgumentImpl resolveNextFlag(String flag) throws ArgumentParserException {
        ArgumentImpl arg = this.optargIndex_.get(flag);
        if (arg != null) {
            return arg;
        }
        List<String> cand = TextHelper.findPrefix(this.optargIndex_.keySet(), flag);
        if (cand.isEmpty()) {
            return null;
        }
        if (this.checkConcatenatedShortOpts(flag)) {
            cand.add(flag.substring(0, 2));
        } else if (cand.size() == 1) {
            return this.optargIndex_.get(cand.get(0));
        }
        Collections.sort(cand);
        throw new ArgumentParserException(String.format((Locale)null, "ambiguous option: %s could match %s", flag, TextHelper.concat(cand, 0, ", ")), (ArgumentParser)this);
    }

    public void parseArgs(ParseState state, Map<String, Object> attrs) throws ArgumentParserException {
        ArgumentImpl arg;
        this.populateDefaults(attrs);
        HashSet<ArgumentImpl> used = new HashSet<ArgumentImpl>();
        ArgumentImpl[] groupUsed = new ArgumentImpl[this.arggroups_.size()];
        int posargIndex = 0;
        int posargsLen = this.posargs_.size();
        while (state.isArgAvail()) {
            if (this.flagFound(state) && !"--".equals(state.getArg())) {
                String embeddedValue;
                String flag;
                String term = state.getArg();
                int p = term.indexOf("=");
                if (p == -1) {
                    flag = term;
                    embeddedValue = null;
                } else {
                    flag = term.substring(0, p);
                    embeddedValue = term.substring(p + 1);
                }
                ArgumentImpl arg2 = this.resolveNextFlag(flag);
                if (arg2 == null) {
                    embeddedValue = null;
                    boolean shortOptsFound = false;
                    if (SHORT_OPTS_PATTERN.matcher(term).matches()) {
                        shortOptsFound = true;
                        int termlen = term.length();
                        for (int i = 1; i < termlen; ++i) {
                            String shortFlag = "-" + term.charAt(i);
                            arg2 = this.optargIndex_.get(shortFlag);
                            if (arg2 == null) {
                                shortOptsFound = false;
                                break;
                            }
                            if (arg2.getAction().consumeArgument()) {
                                flag = shortFlag;
                                shortOptsFound = true;
                                if (term.length() <= i + 1) break;
                                embeddedValue = term.substring(i + 1);
                                break;
                            }
                            this.checkMutex(arg2, groupUsed);
                            arg2.run(this, attrs, shortFlag, null);
                            used.add(arg2);
                            arg2 = null;
                        }
                    }
                    if (!shortOptsFound) {
                        throw new UnrecognizedArgumentException(this.formatUnrecognizedArgumentErrorMessage(state, term), (ArgumentParser)this, term);
                    }
                }
                ++state.index;
                if (arg2 == null) continue;
                this.checkMutex(arg2, groupUsed);
                this.processArg(attrs, state, arg2, flag, embeddedValue);
                used.add(arg2);
                continue;
            }
            if ("--".equals(state.getArg()) && !state.consumedSeparator) {
                state.consumedSeparator = true;
                state.negNumFlag = false;
                ++state.index;
                continue;
            }
            if (posargIndex < posargsLen) {
                arg = this.posargs_.get(posargIndex++);
                this.processArg(attrs, state, arg, null, null);
                continue;
            }
            if (!state.consumedSeparator && this.subparsers_.hasSubCommand()) {
                this.checkRequiredArgument(used, posargIndex);
                this.checkRequiredMutex(groupUsed);
                this.subparsers_.parseArg(state, attrs);
                return;
            }
            throw new ArgumentParserException(this.formatUnrecognizedArgumentErrorMessage(state, TextHelper.concat(state.args, state.index, " ")), (ArgumentParser)this);
        }
        if (this.subparsers_.hasSubCommand()) {
            throw new ArgumentParserException("too few arguments", (ArgumentParser)this);
        }
        while (posargIndex < posargsLen) {
            arg = this.posargs_.get(posargIndex++);
            this.processArg(attrs, state, arg, null, null);
        }
        this.checkRequiredArgument(used, posargIndex);
        this.checkRequiredMutex(groupUsed);
    }

    private String formatUnrecognizedArgumentErrorMessage(ParseState state, String args) {
        return String.format((Locale)null, "unrecognized arguments: '%s'%s", args, state.index > state.lastFromFileArgIndex ? "" : String.format((Locale)null, "%nChecking trailing white spaces or new lines in %sfile may help.", this.fromFilePrefixPattern_.getPrefixChars().length() == 1 ? this.fromFilePrefixPattern_.getPrefixChars() : "[" + this.fromFilePrefixPattern_.getPrefixChars() + "]"));
    }

    private void checkMutex(ArgumentImpl arg, ArgumentImpl[] groupUsed) throws ArgumentParserException {
        if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) {
            ArgumentImpl usedMutexArg = groupUsed[arg.getArgumentGroup().getIndex()];
            if (usedMutexArg == null) {
                groupUsed[arg.getArgumentGroup().getIndex()] = arg;
            } else if (usedMutexArg != arg) {
                throw new ArgumentParserException(String.format((Locale)null, "not allowed with argument %s", usedMutexArg.textualName()), this, arg);
            }
        }
    }

    private void processArg(Map<String, Object> res, ParseState state, ArgumentImpl arg, String flag, String embeddedValue) throws ArgumentParserException {
        if (!arg.getAction().consumeArgument()) {
            if (embeddedValue == null) {
                arg.run(this, res, flag, null);
                return;
            }
            throw new ArgumentParserException(String.format((Locale)null, "ignore implicit argument '%s'", embeddedValue), this, arg);
        }
        if (arg.getMinNumArg() == -1 || arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
            String argval = null;
            if (embeddedValue == null) {
                if (state.isArgAvail() && !this.flagFound(state)) {
                    argval = state.getArg();
                    ++state.index;
                }
            } else {
                argval = embeddedValue;
            }
            if (argval == null) {
                if (arg.getMinNumArg() == -1) {
                    if (arg.isOptionalArgument()) {
                        throw new ArgumentParserException("expected one argument", this, arg);
                    }
                    throw new ArgumentParserException("too few arguments", (ArgumentParser)this);
                }
                if (arg.isOptionalArgument()) {
                    arg.run(this, res, flag, arg.getConst());
                }
            } else {
                arg.run(this, res, flag, arg.convert(this, argval));
            }
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            if (embeddedValue == null) {
                int i = 0;
                while (i < arg.getMaxNumArg() && state.isArgAvail() && !this.flagFound(state)) {
                    list.add(arg.convert(this, state.getArg()));
                    ++i;
                    ++state.index;
                }
            } else {
                list.add(arg.convert(this, embeddedValue));
            }
            if (list.size() < arg.getMinNumArg()) {
                if (arg.isOptionalArgument()) {
                    throw new ArgumentParserException(String.format((Locale)null, "expected %d argument(s)", arg.getMinNumArg()), this, arg);
                }
                throw new ArgumentParserException("too few arguments", (ArgumentParser)this);
            }
            if (arg.isOptionalArgument() || !list.isEmpty()) {
                arg.run(this, res, flag, list);
            }
        }
    }

    private boolean flagFound(ParseState state) throws ArgumentParserException {
        while (this.fromFileFound(state)) {
            this.extendArgs(state, this.fromFilePrefixPattern_.removePrefix(state.getArg()));
        }
        String term = state.getArg();
        if (state.consumedSeparator) {
            return false;
        }
        if ("--".equals(term)) {
            return true;
        }
        return this.prefixPattern_.match(term) && (state.negNumFlag || !NEG_NUM_PATTERN.matcher(term).matches());
    }

    private boolean fromFileFound(ParseState state) {
        return this.fromFilePrefixPattern_ != null && this.fromFilePrefixPattern_.match(state.getArg());
    }

    private void extendArgs(ParseState state, String file) throws ArgumentParserException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format((Locale)null, "Could not read arguments from file '%s'", file), e, this);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        int offset = state.index + 1;
        String[] newargs = new String[list.size() + state.args.length - offset];
        list.toArray(newargs);
        System.arraycopy(state.args, offset, newargs, list.size(), state.args.length - offset);
        state.lastFromFileArgIndex = state.lastFromFileArgIndex < offset ? list.size() - 1 : (state.lastFromFileArgIndex += -offset + list.size());
        state.resetArgs(newargs);
    }

    private void checkRequiredArgument(Set<ArgumentImpl> used, int posargIndex) throws ArgumentParserException {
        for (ArgumentImpl arg : this.optargs_) {
            if (!arg.isRequired() || used.contains(arg)) continue;
            throw new ArgumentParserException(String.format((Locale)null, "argument %s is required", arg.textualName()), (ArgumentParser)this);
        }
        if (this.posargs_.size() > posargIndex) {
            throw new ArgumentParserException("too few arguments", (ArgumentParser)this);
        }
    }

    private void checkRequiredMutex(ArgumentImpl[] used) throws ArgumentParserException {
        for (int i = 0; i < this.arggroups_.size(); ++i) {
            ArgumentGroupImpl group = this.arggroups_.get(i);
            if (!group.isMutex() || !group.isRequired() || used[i] != null) continue;
            StringBuilder sb = new StringBuilder();
            for (ArgumentImpl arg : group.getArgs()) {
                if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
                sb.append(arg.textualName()).append(" ");
            }
            throw new ArgumentParserException(String.format((Locale)null, "one of the arguments %sis required", sb.toString()), (ArgumentParser)this);
        }
    }

    private void populateDefaults(Map<String, Object> opts) {
        for (ArgumentImpl argumentImpl : this.posargs_) {
            if (argumentImpl.getDefaultControl() == Arguments.SUPPRESS) continue;
            opts.put(argumentImpl.getDest(), argumentImpl.getDefault());
        }
        for (ArgumentImpl argumentImpl : this.optargs_) {
            if (argumentImpl.getDefaultControl() == Arguments.SUPPRESS) continue;
            opts.put(argumentImpl.getDest(), argumentImpl.getDefault());
        }
        for (Map.Entry entry : this.defaults_.entrySet()) {
            opts.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String getProg() {
        return this.prog_;
    }

    @Override
    public void printVersion() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printVersion(writer);
        writer.flush();
    }

    @Override
    public void printVersion(PrintWriter writer) {
        writer.println(this.formatVersion());
    }

    @Override
    public String formatVersion() {
        return this.substitutePlaceholder(this.version_);
    }

    @Override
    public void handleError(ArgumentParserException e) {
        if (e.getParser() != this) {
            e.getParser().handleError(e);
            return;
        }
        if (e instanceof HelpScreenException) {
            return;
        }
        PrintWriter writer = new PrintWriter(System.err);
        this.printUsage(writer);
        writer.write(TextHelper.wrap(this.textWidthCounter_, String.format((Locale)null, "%s: error: %s%n", this.prog_, e.getMessage()), ArgumentParsers.getFormatWidth(), 0, "", ""));
        if (e instanceof UnrecognizedArgumentException) {
            String flagBody;
            UnrecognizedArgumentException ex = (UnrecognizedArgumentException)e;
            String argument = ex.getArgument();
            if (this.prefixPattern_.match(argument) && (flagBody = this.prefixPattern_.removePrefix(argument)).length() >= 2) {
                this.printFlagCandidates(flagBody, writer);
            }
        } else if (e instanceof UnrecognizedCommandException) {
            UnrecognizedCommandException ex = (UnrecognizedCommandException)e;
            String command = ex.getCommand();
            this.printCommandCandidates(command, writer);
        }
        writer.flush();
    }

    private int levenshtein(String a, String b, int swap, int sub, int add, int del) {
        int i;
        int alen = a.length();
        int blen = b.length();
        int[][] dp = new int[3][blen + 1];
        for (i = 0; i <= blen; ++i) {
            dp[1][i] = i;
        }
        for (i = 1; i <= alen; ++i) {
            dp[0][0] = i;
            for (int j = 1; j <= blen; ++j) {
                dp[0][j] = dp[1][j - 1] + (a.charAt(i - 1) == b.charAt(j - 1) ? 0 : sub);
                if (i >= 2 && j >= 2 && a.charAt(i - 1) != b.charAt(j - 1) && a.charAt(i - 2) == b.charAt(j - 1) && a.charAt(i - 1) == b.charAt(j - 2)) {
                    dp[0][j] = Math.min(dp[0][j], dp[2][j - 2] + swap);
                }
                dp[0][j] = Math.min(dp[0][j], Math.min(dp[1][j] + del, dp[0][j - 1] + add));
            }
            int[] temp = dp[2];
            dp[2] = dp[1];
            dp[1] = dp[0];
            dp[0] = temp;
        }
        return dp[1][blen];
    }

    private void printFlagCandidates(String flagBody, PrintWriter writer) {
        ArrayList<SubjectBody> subjects = new ArrayList<SubjectBody>();
        for (ArgumentImpl arg : this.optargs_) {
            String[] flags = arg.getFlags();
            int len = flags.length;
            for (int i = 0; i < len; ++i) {
                String body = this.prefixPattern_.removePrefix(flags[i]);
                if (body.length() <= 1) continue;
                subjects.add(new SubjectBody(flags[i], body));
            }
        }
        this.printCandidates(flagBody, subjects, writer);
    }

    private void printCommandCandidates(String command, PrintWriter writer) {
        ArrayList<SubjectBody> subjects = new ArrayList<SubjectBody>();
        for (String com : this.subparsers_.getCommands()) {
            subjects.add(new SubjectBody(com, com));
        }
        this.printCandidates(command, subjects, writer);
    }

    private void printCandidates(String body, List<SubjectBody> subjects, PrintWriter writer) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (SubjectBody sub : subjects) {
            if (sub.body.startsWith(body)) {
                candidates.add(new Candidate(0, sub.subject));
                continue;
            }
            candidates.add(new Candidate(this.levenshtein(body, sub.body, 0, 2, 1, 4), sub.subject));
        }
        if (candidates.isEmpty()) {
            return;
        }
        Collections.sort(candidates);
        int threshold = ((Candidate)candidates.get((int)0)).similarity;
        if (threshold >= 7) {
            return;
        }
        writer.println();
        writer.println("Did you mean:");
        for (Candidate cand : candidates) {
            if (cand.similarity > threshold) break;
            writer.print("\t");
            writer.println(cand.subject);
        }
    }

    private String substitutePlaceholder(String src) {
        return src.replaceAll(Pattern.quote("${prog}"), this.prog_);
    }

    public String getCommand() {
        return this.command_;
    }

    public TextWidthCounter getTextWidthCounter() {
        return this.textWidthCounter_;
    }

    public String getPrefixChars() {
        return this.prefixPattern_.getPrefixChars();
    }

    public String getFromFilePrefixChars() {
        return this.fromFilePrefixPattern_ == null ? null : this.fromFilePrefixPattern_.getPrefixChars();
    }

    public ArgumentParserImpl getMainParser() {
        return this.mainParser_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Candidate
    implements Comparable<Candidate> {
        public int similarity;
        public String subject;

        public Candidate(int similarity, String subject) {
            this.similarity = similarity;
            this.subject = subject;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Candidate other = (Candidate)obj;
            if (this.subject == null) {
                if (other.subject != null) {
                    return false;
                }
            } else {
                if (other.subject == null) {
                    return false;
                }
                if (!this.subject.equals(other.subject)) {
                    return false;
                }
            }
            return this.similarity == other.similarity;
        }

        public int hashCode() {
            int prime = 31;
            int hash = 1;
            hash = hash * prime + (this.subject == null ? 0 : this.subject.hashCode());
            hash = hash * prime + this.similarity;
            return hash;
        }

        @Override
        public int compareTo(Candidate rhs) {
            if (this.similarity < rhs.similarity) {
                return -1;
            }
            if (this.similarity == rhs.similarity) {
                return this.subject.compareTo(rhs.subject);
            }
            return 1;
        }
    }

    private static class SubjectBody {
        public String subject;
        public String body;

        public SubjectBody(String subject, String body) {
            this.subject = subject;
            this.body = body;
        }
    }
}

