/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFileInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(TemporaryFileInputStream.class);
    private final File tempFile;
    private final FileInputStream fileInputStream;

    public TemporaryFileInputStream(File tempFile) throws FileNotFoundException {
        this.tempFile = tempFile;
        this.fileInputStream = new FileInputStream(tempFile);
    }

    public File getTemporaryFile() {
        return this.tempFile;
    }

    @Override
    public int read() throws IOException {
        return this.fileInputStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.fileInputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.fileInputStream.close();
        }
        finally {
            if (this.tempFile.exists() && !this.tempFile.delete()) {
                logger.warn("Could not delete a temporary file: " + this.tempFile.getAbsolutePath());
            }
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.fileInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.fileInputStream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fileInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fileInputStream.skip(n);
    }
}

