/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.transformer.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.codelibs.robot.RobotCrawlAccessException;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.AccessResultData;
import org.codelibs.robot.entity.ResponseData;
import org.codelibs.robot.entity.ResultData;
import org.codelibs.robot.transformer.impl.AbstractTransformer;

public class BinaryTransformer
extends AbstractTransformer {
    @Override
    public ResultData transform(ResponseData responseData) {
        ResultData resultData;
        if (responseData == null || responseData.getResponseBody() == null) {
            throw new RobotCrawlAccessException("No response body.");
        }
        ResultData resultData2 = new ResultData();
        resultData2.setTransformerName(this.getName());
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(responseData.getResponseBody());
            resultData2.setData(IOUtils.toByteArray((InputStream)bis));
            resultData2.setEncoding(responseData.getCharSet());
            resultData = resultData2;
        }
        catch (IOException e) {
            try {
                throw new RobotSystemException("Could not convert the input stream.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        return resultData;
    }

    @Override
    public Object getData(AccessResultData accessResultData) {
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new RobotSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }
}

