/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.extractor.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import org.apache.commons.io.IOUtils;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.ExtractData;
import org.codelibs.robot.extractor.ExtractException;
import org.codelibs.robot.extractor.Extractor;
import org.codelibs.robot.extractor.ExtractorFactory;
import org.codelibs.robot.helper.MimeTypeHelper;
import org.codelibs.robot.util.IgnoreCloseInputStream;
import org.codelibs.robot.util.StreamUtil;
import org.seasar.framework.container.SingletonS2Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LhaExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(LhaExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
        if (mimeTypeHelper == null) {
            throw new RobotSystemException("MimeTypeHelper is unavailable.");
        }
        ExtractorFactory extractorFactory = (ExtractorFactory)SingletonS2Container.getComponent((String)"extractorFactory");
        if (extractorFactory == null) {
            throw new RobotSystemException("ExtractorFactory is unavailable.");
        }
        StringBuilder buf = new StringBuilder(1000);
        File tempFile = null;
        LhaFile lhaFile = null;
        try {
            tempFile = File.createTempFile("s2robot-", ".lzh");
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                StreamUtil.drain(in, bos);
                bos.flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)bos);
            lhaFile = new LhaFile(tempFile);
            Enumeration entries = lhaFile.entries();
            while (entries.hasMoreElements()) {
                Extractor extractor;
                LhaHeader head = (LhaHeader)entries.nextElement();
                String filename = head.getPath();
                String mimeType = mimeTypeHelper.getContentType(null, filename);
                if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) continue;
                InputStream is = null;
                try {
                    is = lhaFile.getInputStream(head);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("resourceName", filename);
                    buf.append(extractor.getText(new IgnoreCloseInputStream(is), map).getContent());
                    buf.append('\n');
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Exception in an internal extractor.", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
        catch (Exception e) {
            throw new ExtractException("Could not extract a content.", e);
        }
        finally {
            if (lhaFile != null) {
                try {
                    lhaFile.close();
                }
                catch (IOException e) {}
            }
            if (tempFile != null && !tempFile.delete()) {
                logger.warn("Failed to delete " + tempFile.getAbsolutePath());
            }
        }
        return new ExtractData(buf.toString());
    }
}

