/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.util.StringUtil;

public class AspectDefFactory {
    protected AspectDefFactory() {
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, Pointcut pointcut) {
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setValue(interceptor);
        return aspectDef;
    }

    public static AspectDef createAspectDef(String interceptorName, Pointcut pointcut) {
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setExpression(new OgnlExpression(interceptorName));
        return aspectDef;
    }

    public static AspectDef createAspectDef(ComponentDef cd, Pointcut pointcut) {
        AspectDefImpl aspectDef = new AspectDefImpl(pointcut);
        aspectDef.setChildComponentDef(cd);
        return aspectDef;
    }

    public static AspectDef createAspectDef(String interceptorName, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        return AspectDefFactory.createAspectDef(interceptorName, pointcut);
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        return AspectDefFactory.createAspectDef(interceptor, pointcut);
    }

    public static AspectDef createAspectDef(ComponentDef cd, String pointcutStr) {
        Pointcut pointcut = AspectDefFactory.createPointcut(pointcutStr);
        return AspectDefFactory.createAspectDef(cd, pointcut);
    }

    public static AspectDef createAspectDef(String interceptorName, Method method) {
        Pointcut pointcut = AspectDefFactory.createPointcut(method);
        return AspectDefFactory.createAspectDef(interceptorName, pointcut);
    }

    public static AspectDef createAspectDef(MethodInterceptor interceptor, Method method) {
        Pointcut pointcut = AspectDefFactory.createPointcut(method);
        return AspectDefFactory.createAspectDef(interceptor, pointcut);
    }

    public static AspectDef createAspectDef(ComponentDef cd, Method method) {
        Pointcut pointcut = AspectDefFactory.createPointcut(method);
        return AspectDefFactory.createAspectDef(cd, pointcut);
    }

    public static Pointcut createPointcut(String pointcutStr) {
        if (!StringUtil.isEmpty(pointcutStr)) {
            String[] methodNames = StringUtil.split(pointcutStr, ", \n");
            return new PointcutImpl(methodNames);
        }
        return null;
    }

    public static Pointcut createPointcut(Class clazz) {
        return new PointcutImpl(clazz);
    }

    public static Pointcut createPointcut(Method method) {
        if (method != null) {
            return new PointcutImpl(method);
        }
        return null;
    }
}

