/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;

public class ActionConfig
implements Serializable {
    protected boolean configured = false;
    protected HashMap exceptions = new HashMap();
    protected HashMap forwards = new HashMap();
    protected ModuleConfig moduleConfig = null;
    protected String attribute = null;
    protected String forward = null;
    protected String include = null;
    protected String input = null;
    protected String multipartClass = null;
    protected String name = null;
    protected String parameter = null;
    protected String path = null;
    protected String prefix = null;
    protected String roles = null;
    protected String[] roleNames = new String[0];
    protected String scope = "session";
    protected String suffix = null;
    protected String type = null;
    protected boolean unknown = false;
    protected boolean validate = true;
    protected boolean cancellable = false;
    protected Integer acceptPage = null;

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.moduleConfig = moduleConfig;
    }

    public String getAttribute() {
        if (this.attribute == null) {
            return this.name;
        }
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.attribute = attribute;
    }

    public String getForward() {
        return this.forward;
    }

    public void setForward(String forward) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forward = forward;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.include = include;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.input = input;
    }

    public String getMultipartClass() {
        return this.multipartClass;
    }

    public void setMultipartClass(String multipartClass) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.multipartClass = multipartClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.parameter = parameter;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.path = path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.prefix = prefix;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        int comma;
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.roles = roles;
        if (roles == null) {
            this.roleNames = new String[0];
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((comma = roles.indexOf(44)) >= 0) {
            list.add(roles.substring(0, comma).trim());
            roles = roles.substring(comma + 1);
        }
        roles = roles.trim();
        if (roles.length() > 0) {
            list.add(roles);
        }
        this.roleNames = list.toArray(new String[list.size()]);
    }

    public String[] getRoleNames() {
        return this.roleNames;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.scope = scope;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.suffix = suffix;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
    }

    public boolean getUnknown() {
        return this.unknown;
    }

    public void setUnknown(boolean unknown) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.unknown = unknown;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.validate = validate;
    }

    public boolean getCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean cancellable) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.cancellable = cancellable;
    }

    public Integer getAcceptPage() {
        return this.acceptPage;
    }

    public void setAcceptPage(Integer acceptPage) {
        this.acceptPage = acceptPage;
    }

    public void addExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.put(config.getType(), config);
    }

    public void addForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.put(config.getName(), config);
    }

    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    public ExceptionConfig findException(Class type) {
        ExceptionConfig config = null;
        do {
            String name;
            if ((config = this.findExceptionConfig(name = type.getName())) != null) {
                return config;
            }
            config = this.getModuleConfig().findExceptionConfig(name);
            if (config == null) continue;
            return config;
        } while ((type = type.getSuperclass()) != null);
        return null;
    }

    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    public void freeze() {
        this.configured = true;
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        for (int i = 0; i < econfigs.length; ++i) {
            econfigs[i].freeze();
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        for (int i = 0; i < fconfigs.length; ++i) {
            fconfigs[i].freeze();
        }
    }

    public void removeExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.remove(config.getType());
    }

    public void removeForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.remove(config.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ActionConfig[");
        sb.append("path=");
        sb.append(this.path);
        if (this.attribute != null) {
            sb.append(",attribute=");
            sb.append(this.attribute);
        }
        if (this.forward != null) {
            sb.append(",forward=");
            sb.append(this.forward);
        }
        if (this.include != null) {
            sb.append(",include=");
            sb.append(this.include);
        }
        if (this.input != null) {
            sb.append(",input=");
            sb.append(this.input);
        }
        if (this.multipartClass != null) {
            sb.append(",multipartClass=");
            sb.append(this.multipartClass);
        }
        if (this.name != null) {
            sb.append(",name=");
            sb.append(this.name);
        }
        if (this.parameter != null) {
            sb.append(",parameter=");
            sb.append(this.parameter);
        }
        if (this.prefix != null) {
            sb.append(",prefix=");
            sb.append(this.prefix);
        }
        if (this.roles != null) {
            sb.append(",roles=");
            sb.append(this.roles);
        }
        if (this.scope != null) {
            sb.append(",scope=");
            sb.append(this.scope);
        }
        if (this.suffix != null) {
            sb.append(",suffix=");
            sb.append(this.suffix);
        }
        if (this.type != null) {
            sb.append(",type=");
            sb.append(this.type);
        }
        sb.append(",validate=");
        sb.append(this.validate);
        sb.append(",cancellable=");
        sb.append(this.cancellable);
        sb.append(",acceptPage=");
        sb.append(this.acceptPage);
        return sb.toString();
    }
}

