/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.msg;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.codelibs.core.util.StringUtil;

public class MessageFormatter {
    protected static final int CODE_NUMBER_LENGTH = 4;
    protected static final String MESSAGES = "Messages";
    protected static volatile boolean initialized;

    public static String getMessage(String messageCode, Object ... args) {
        return MessageFormatter.getFormattedMessage(messageCode == null ? "" : messageCode, MessageFormatter.getSimpleMessage(messageCode, args));
    }

    public static String getFormattedMessage(String messageCode, String simpleMessage) {
        return "[" + messageCode + "]" + simpleMessage;
    }

    public static String getSimpleMessage(String messageCode, Object ... args) {
        try {
            String pattern = MessageFormatter.getPattern(messageCode);
            if (pattern != null) {
                return MessageFormat.format(pattern, args);
            }
            return MessageFormatter.getNoPatternMessage(args);
        }
        catch (Throwable ignore) {
            return MessageFormatter.getNoPatternMessage(args);
        }
    }

    protected static String getPattern(String messageCode) {
        if (StringUtil.isEmpty(messageCode)) {
            return null;
        }
        ResourceBundle resourceBundle = MessageFormatter.getResourceBundle(MessageFormatter.getSystemName(messageCode));
        if (resourceBundle == null) {
            return null;
        }
        int length = messageCode.length();
        if (length > 4) {
            String key = messageCode.charAt(0) + messageCode.substring(length - 4);
            String pattern = null;
            try {
                pattern = resourceBundle.getString(key);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (pattern != null) {
                return pattern;
            }
        }
        return resourceBundle.getString(messageCode);
    }

    protected static String getSystemName(String messageCode) {
        return messageCode.substring(1, Math.max(1, messageCode.length() - 4));
    }

    protected static ResourceBundle getResourceBundle(String systemName) {
        try {
            return ResourceBundle.getBundle(systemName + MESSAGES);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    protected static String getNoPatternMessage(Object ... args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Object arg : args) {
            buffer.append(arg + ", ");
        }
        buffer.setLength(buffer.length() - ", ".length());
        return new String(buffer);
    }
}

