/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis.synonym;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.synonym.NGramSynonymTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public final class NGramSynonymTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private final String synonymFiles;
    private final boolean ignoreCase;
    private final int n;
    private final String delimiters;
    private final String format;
    private final boolean expand;
    private SynonymMap map;

    public NGramSynonymTokenizerFactory(Map<String, String> args) {
        super(args);
        this.synonymFiles = this.get(args, "synonyms");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", true);
        this.n = this.getInt(args, "n", 2);
        this.delimiters = this.get(args, "delimiters", " \u3000\t\n\r");
        this.format = this.get(args, "format");
        this.expand = this.getBoolean(args, "expand", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public Tokenizer create(AttributeFactory factory, Reader input) {
        return new NGramSynonymTokenizer(input, this.n, this.delimiters, this.expand, this.ignoreCase, this.map);
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.synonymFiles == null) {
            this.map = null;
            return;
        }
        Analyzer analyzer = NGramSynonymTokenizerFactory.getAnalyzer(this.ignoreCase);
        try {
            String formatClass = this.format;
            if (this.format == null || this.format.equals("solr")) {
                formatClass = SolrSynonymParser.class.getName();
            } else if (this.format.equals("wordnet")) {
                formatClass = WordnetSynonymParser.class.getName();
            }
            this.map = this.loadSynonyms(loader, formatClass, true, analyzer, true, this.synonymFiles);
        }
        catch (ParseException e) {
            throw new IOException("Error parsing synonyms file:", e);
        }
    }

    public static Analyzer getAnalyzer(final boolean ignoreCase) {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
                KeywordTokenizer tokenizer = new KeywordTokenizer(reader);
                KeywordTokenizer stream = ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
    }

    private SynonymMap loadSynonyms(ResourceLoader loader, String cname, boolean dedup, Analyzer analyzer, boolean expand, String synonyms) throws IOException, ParseException {
        SynonymMap.Parser parser;
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        Class clazz = loader.findClass(cname, SynonymMap.Parser.class);
        try {
            parser = (SynonymMap.Parser)clazz.getConstructor(Boolean.TYPE, Boolean.TYPE, Analyzer.class).newInstance(dedup, expand, analyzer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File synonymFile = new File(synonyms);
        if (synonymFile.exists()) {
            decoder.reset();
            parser.parse((Reader)new InputStreamReader(loader.openResource(synonyms), decoder));
        } else {
            List files = this.splitFileNames(synonyms);
            for (String file : files) {
                decoder.reset();
                parser.parse((Reader)new InputStreamReader(loader.openResource(file), decoder));
            }
        }
        return parser.build();
    }
}

