/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.valuetype.TnPlainValueTypes;
import org.seasar.dbflute.s2dao.valuetype.basic.BigDecimalType;
import org.seasar.dbflute.s2dao.valuetype.basic.BigIntegerType;
import org.seasar.dbflute.s2dao.valuetype.basic.BinaryStreamType;
import org.seasar.dbflute.s2dao.valuetype.basic.BinaryType;
import org.seasar.dbflute.s2dao.valuetype.basic.BooleanType;
import org.seasar.dbflute.s2dao.valuetype.basic.ByteType;
import org.seasar.dbflute.s2dao.valuetype.basic.CharacterType;
import org.seasar.dbflute.s2dao.valuetype.basic.ClassificationType;
import org.seasar.dbflute.s2dao.valuetype.basic.DoubleType;
import org.seasar.dbflute.s2dao.valuetype.basic.FloatType;
import org.seasar.dbflute.s2dao.valuetype.basic.IntegerType;
import org.seasar.dbflute.s2dao.valuetype.basic.LongType;
import org.seasar.dbflute.s2dao.valuetype.basic.ObjectType;
import org.seasar.dbflute.s2dao.valuetype.basic.ShortType;
import org.seasar.dbflute.s2dao.valuetype.basic.SqlDateType;
import org.seasar.dbflute.s2dao.valuetype.basic.StringType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimeType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimestampType;
import org.seasar.dbflute.s2dao.valuetype.basic.UUIDAsDirectType;
import org.seasar.dbflute.s2dao.valuetype.basic.UUIDAsStringType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsSqlDateType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsTimestampType;
import org.seasar.dbflute.s2dao.valuetype.plugin.BytesOidType;
import org.seasar.dbflute.s2dao.valuetype.plugin.BytesType;
import org.seasar.dbflute.s2dao.valuetype.plugin.FixedLengthStringType;
import org.seasar.dbflute.s2dao.valuetype.plugin.ObjectBindingBigDecimalType;
import org.seasar.dbflute.s2dao.valuetype.plugin.OracleResultSetType;
import org.seasar.dbflute.s2dao.valuetype.plugin.PostgreSQLResultSetType;
import org.seasar.dbflute.s2dao.valuetype.plugin.SerializableType;
import org.seasar.dbflute.s2dao.valuetype.plugin.StringClobType;

public class TnValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType BYTE = new ByteType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType BIGINTEGER = new BigIntegerType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType UTILDATE_AS_SQLDATE = new UtilDateAsSqlDateType();
    public static final ValueType UTILDATE_AS_TIMESTAMP = new UtilDateAsTimestampType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType UUID_AS_DIRECT = new UUIDAsDirectType();
    public static final ValueType UUID_AS_STRING = new UUIDAsStringType();
    public static final ValueType CLASSIFICATION = new ClassificationType();
    public static final ValueType DEFAULT_OBJECT = new ObjectType();
    public static final ValueType STRING_CLOB = new StringClobType();
    public static final ValueType BYTES_OID = new BytesOidType();
    public static final ValueType FIXED_LENGTH_STRING = new FixedLengthStringType();
    public static final ValueType OBJECT_BINDING_BIGDECIMAL = new ObjectBindingBigDecimalType();
    public static final ValueType POSTGRESQL_RESULT_SET = new PostgreSQLResultSetType();
    public static final ValueType ORACLE_RESULT_SET = new OracleResultSetType();
    public static final ValueType SERIALIZABLE_BYTE_ARRAY = new SerializableType(BytesType.BYTES_TRAIT);
    protected static final Class<?> BYTE_ARRAY_CLASS = new byte[0].getClass();
    protected static final Map<DBDef, TnPlainValueTypes> _valueTypesMap = new ConcurrentHashMap<DBDef, TnPlainValueTypes>();
    protected static final Object _staticWorldLock = new Object();

    protected static void initialize() {
        _valueTypesMap.put(DBDef.MySQL, TnValueTypes.createValueTypes());
        _valueTypesMap.put(DBDef.PostgreSQL, TnValueTypes.createValueTypes());
        TnPlainValueTypes valueTypes = TnValueTypes.createValueTypes();
        valueTypes.registerBasicValueType(Date.class, UTILDATE_AS_TIMESTAMP);
        _valueTypesMap.put(DBDef.Oracle, valueTypes);
        _valueTypesMap.put(DBDef.DB2, TnValueTypes.createValueTypes());
        valueTypes = TnValueTypes.createValueTypes();
        valueTypes.registerBasicValueType(UUID.class, UUID_AS_STRING);
        _valueTypesMap.put(DBDef.SQLServer, valueTypes);
        _valueTypesMap.put(DBDef.H2, TnValueTypes.createValueTypes());
        _valueTypesMap.put(DBDef.Derby, TnValueTypes.createValueTypes());
        _valueTypesMap.put(DBDef.SQLite, TnValueTypes.createValueTypes());
        _valueTypesMap.put(DBDef.Firebird, TnValueTypes.createValueTypes());
        _valueTypesMap.put(DBDef.MSAccess, TnValueTypes.createValueTypes());
        _valueTypesMap.put(DBDef.Unknown, TnValueTypes.createValueTypes());
    }

    protected static TnPlainValueTypes createValueTypes() {
        return new TnPlainValueTypes();
    }

    protected static TnPlainValueTypes getValueTypes() {
        DBDef currentDBDef = ResourceContext.currentDBDef();
        return TnValueTypes.findValueTypes(currentDBDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TnPlainValueTypes findValueTypes(DBDef dbdef) {
        TnValueTypes.assertObjectNotNull("dbdef", (Object)dbdef);
        TnPlainValueTypes valueTypes = _valueTypesMap.get((Object)dbdef);
        if (valueTypes != null) {
            return valueTypes;
        }
        Object object = _staticWorldLock;
        synchronized (object) {
            valueTypes = _valueTypesMap.get((Object)dbdef);
            if (valueTypes != null) {
                return valueTypes;
            }
            valueTypes = new TnPlainValueTypes();
            _valueTypesMap.put(dbdef, valueTypes);
            return _valueTypesMap.get((Object)dbdef);
        }
    }

    private TnValueTypes() {
    }

    public static ValueType findByTypeOrValue(Class<?> type, Object value) {
        return TnValueTypes.getValueTypes().findByTypeOrValue(type, value);
    }

    public static ValueType findByValueOrJdbcDefType(Object value, int jdbcDefType) {
        return TnValueTypes.getValueTypes().findByValueOrJdbcDefType(value, jdbcDefType);
    }

    public static ValueType getValueType(Object value) {
        return TnValueTypes.getValueTypes().getValueType(value);
    }

    public static ValueType getValueType(Class<?> type) {
        return TnValueTypes.getValueTypes().getValueType(type);
    }

    public static ValueType getValueType(int jdbcDefType) {
        return TnValueTypes.getValueTypes().getValueType(jdbcDefType);
    }

    public static ValueType getPluginValueType(String valueTypeName) {
        return TnValueTypes.getValueTypes().getPluginValueType(valueTypeName);
    }

    public static boolean isDefaultObject(ValueType valueType) {
        return TnValueTypes.getValueTypes().isDefaultObject(valueType);
    }

    public static boolean isDynamicObject(ValueType valueType) {
        return TnValueTypes.getValueTypes().isDynamicObject(valueType);
    }

    public static synchronized void registerBasicValueType(DBDef dbdef, Class<?> keyType, ValueType valueType) {
        TnValueTypes.findValueTypes(dbdef).registerBasicValueType(keyType, valueType);
    }

    public static synchronized void removeBasicValueType(DBDef dbdef, Class<?> keyType) {
        TnValueTypes.findValueTypes(dbdef).removeBasicValueType(keyType);
    }

    public static synchronized void registerPluginValueType(DBDef dbdef, String keyName, ValueType valueType) {
        TnValueTypes.findValueTypes(dbdef).registerPluginValueType(keyName, valueType);
    }

    public static synchronized void removePluginValueType(DBDef dbdef, String keyName) {
        TnValueTypes.findValueTypes(dbdef).removePluginValueType(keyName);
    }

    protected static synchronized void restoreDefault(DBDef dbdef) {
        TnValueTypes.findValueTypes(dbdef).restoreDefault();
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        TnValueTypes.initialize();
    }
}

