/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class TnSqlLogRegistry {
    protected static final String PKG_ORG_SEASAR = "org.seasar.";
    protected static final String NAME_SqlLogRegistryLocator = "org.seasar.extension.jdbc.SqlLogRegistryLocator";
    protected static final String NAME_getInstance = "getInstance";
    protected static final String NAME_setInstance = "setInstance";
    protected static final String NAME_SqlLogRegistry = "org.seasar.extension.jdbc.SqlLogRegistry";
    protected static final String NAME_SqlLogRegistryImpl = "org.seasar.extension.jdbc.impl.SqlLogRegistryImpl";
    protected static final String NAME_SqlLog = "org.seasar.extension.jdbc.SqlLog";
    protected static final String NAME_SqlLogImpl = "org.seasar.extension.jdbc.impl.SqlLogImpl";
    protected static final boolean exists;
    protected static final Class<?> locatorType;
    protected static final Method locatorInstanceMethod;
    protected static final Class<?> registryType;
    protected static final Class<?> registryImplType;
    protected static final Class<?> sqlLogType;
    protected static final Class<?> sqlLogImplType;

    public static boolean exists() {
        return exists;
    }

    public static boolean setupSqlLogRegistry() {
        if (!exists) {
            return false;
        }
        Object sqlLogRegistryImpl = TnSqlLogRegistry.createContainerSqlLogRegistryImpl();
        String methodName = NAME_setInstance;
        try {
            Method method = locatorType.getMethod(NAME_setInstance, registryType);
            method.invoke(null, sqlLogRegistryImpl);
            return true;
        }
        catch (Exception e) {
            String msg = "Failed to set the locator instance:";
            msg = msg + " locatorType=" + locatorType;
            msg = msg + " methodName=" + NAME_setInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void clearSqlLogRegistry() {
        if (!exists) {
            return;
        }
        String methodName = "clear";
        try {
            Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
            Method method = locatorType.getMethod("clear", new Class[0]);
            method.invoke(sqlLogRegistry, new Object[0]);
        }
        catch (Exception e) {
            String msg = "Failed to clear registry of the locator:";
            msg = msg + " locatorType=" + locatorType;
            msg = msg + " methodName=" + "clear";
            throw new IllegalStateException(msg, e);
        }
    }

    public static Object findContainerSqlLogRegistry() {
        if (!exists) {
            return null;
        }
        try {
            return locatorInstanceMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            String msg = "Failed to get the locator instance:";
            msg = msg + " locatorType=" + locatorType;
            msg = msg + " methodName=" + NAME_getInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void closeRegistration() {
        if (!exists) {
            return;
        }
        String methodName = NAME_setInstance;
        try {
            Method method = locatorType.getMethod(NAME_setInstance, registryType);
            method.invoke(null, new Object[]{null});
        }
        catch (Exception e) {
            String msg = "Failed to handle the locator method:";
            msg = msg + " locatorType=" + locatorType;
            msg = msg + " methodName=" + NAME_setInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void push(String rawSql, String completeSql, Object[] bindArgs, Class<?>[] bindArgTypes, Object sqlLogRegistry) {
        if (!exists) {
            return;
        }
        if (sqlLogRegistry == null) {
            throw new IllegalArgumentException("sqlLogRegistry should not be null.");
        }
        Object sqlLogImpl = TnSqlLogRegistry.createContainerSqlLogImpl(rawSql, completeSql, bindArgs, bindArgTypes);
        TnSqlLogRegistry.reflectSqlLogToContainerSqlLogRegistry(sqlLogImpl, sqlLogRegistry);
    }

    public static String peekCompleteSql() {
        if (!exists) {
            return null;
        }
        Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
        Object sqlLog = TnSqlLogRegistry.findLastContainerSqlLog(sqlLogRegistry);
        return TnSqlLogRegistry.extractCompleteSqlFromContainerSqlLog(sqlLog);
    }

    protected static Object createContainerSqlLogRegistryImpl() {
        try {
            Constructor<?> constructor = registryImplType.getConstructor(Integer.TYPE);
            return constructor.newInstance(3);
        }
        catch (Exception e) {
            String msg = "Failed to create registryImpl:";
            msg = msg + " registryImplType=" + registryImplType;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Object createContainerSqlLogImpl(String rawSql, String completeSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
        try {
            Class[] argTypes = new Class[]{String.class, String.class, Object[].class, Class[].class};
            Constructor<?> constructor = sqlLogImplType.getConstructor(argTypes);
            return constructor.newInstance(rawSql, completeSql, bindArgs, bindArgTypes);
        }
        catch (Exception e) {
            String msg = "Failed to create sqlLogImpl:";
            msg = msg + " completeSql=" + completeSql;
            msg = msg + " sqlLogImplType=" + sqlLogImplType;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static void reflectSqlLogToContainerSqlLogRegistry(Object sqlLog, Object sqlLogRegistry) {
        if (sqlLog == null || sqlLogRegistry == null) {
            return;
        }
        String methodName = "add";
        try {
            Method method = registryType.getMethod("add", sqlLogType);
            method.invoke(sqlLogRegistry, sqlLog);
        }
        catch (Exception e) {
            String msg = "Failed to reflect sqlLogRegistry:";
            msg = msg + " sqlLog=" + sqlLog + " sqlLogRegistry=" + sqlLogRegistry;
            msg = msg + " registryType=" + registryType;
            msg = msg + " methodName=" + "add";
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Object findLastContainerSqlLog(Object sqlLogRegistry) {
        if (sqlLogRegistry == null) {
            return null;
        }
        String methodName = "getLast";
        try {
            Method method = registryType.getMethod("getLast", null);
            return method.invoke(sqlLogRegistry, (Object[])null);
        }
        catch (Exception e) {
            String msg = "Failed to find sqlLog:";
            msg = msg + " sqlLogRegistry=" + sqlLogRegistry;
            msg = msg + " methodName=" + "getLast";
            throw new IllegalStateException(msg, e);
        }
    }

    protected static String extractCompleteSqlFromContainerSqlLog(Object sqlLog) {
        if (sqlLog == null) {
            return null;
        }
        String methodName = "getCompleteSql";
        try {
            Method method = sqlLogType.getMethod("getCompleteSql", null);
            return (String)method.invoke(sqlLog, (Object[])null);
        }
        catch (Exception e) {
            String msg = "Failed to extract completeSql:";
            msg = msg + " sqlLog=" + sqlLog;
            msg = msg + " methodName=" + "getCompleteSql";
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Class<?> forNameContainerSqlLogRegistryLocator() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistryLocator);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLogRegistry() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistry);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLogRegistryImpl() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistryImpl);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLog() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLog);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLogImpl() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogImpl);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }

    static {
        locatorType = TnSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (locatorType != null) {
            Method foundMethod;
            exists = true;
            String methodName = NAME_getInstance;
            try {
                foundMethod = locatorType.getMethod(NAME_getInstance, null);
            }
            catch (Exception e) {
                String msg = "Failed to get the method to get the instance: getInstance";
                throw new IllegalStateException(msg);
            }
            locatorInstanceMethod = foundMethod;
            registryType = TnSqlLogRegistry.forNameContainerSqlLogRegistry();
            registryImplType = TnSqlLogRegistry.forNameContainerSqlLogRegistryImpl();
            sqlLogType = TnSqlLogRegistry.forNameContainerSqlLog();
            sqlLogImplType = TnSqlLogRegistry.forNameContainerSqlLogImpl();
        } else {
            exists = false;
            locatorInstanceMethod = null;
            registryType = null;
            registryImplType = null;
            sqlLogType = null;
            sqlLogImplType = null;
        }
    }
}

