/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.infra.manage.refresh;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.seasar.dbflute.util.Srl;

public class DfRefreshResourceRequest {
    protected final List<String> _projectNameList;
    protected final String _requestUrl;

    public DfRefreshResourceRequest(List<String> projectNameList, String requestUrl) {
        if (projectNameList == null || projectNameList.isEmpty()) {
            String msg = "The argument '_projectNameList' should not be null or empty: " + projectNameList;
            throw new IllegalArgumentException(msg);
        }
        if (Srl.is_Null_or_TrimmedEmpty(requestUrl)) {
            String msg = "The argument 'requestUrl' should not be null or empty: " + requestUrl;
            throw new IllegalArgumentException(msg);
        }
        this._projectNameList = projectNameList;
        this._requestUrl = requestUrl;
    }

    public void refreshResources() throws IOException {
        for (String projectName : this._projectNameList) {
            this.doRefreshResources(projectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefreshResources(String projectName) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("refresh?").append(projectName).append("=INFINITE");
        URL url = this.createRefreshRequestURL(sb.toString());
        if (url == null) {
            return;
        }
        InputStream ins = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(this.getRefreshRequestReadTimeout());
            conn.connect();
            ins = conn.getInputStream();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected URL createRefreshRequestURL(String path) throws MalformedURLException {
        String requestUrl = this._requestUrl;
        if (!requestUrl.endsWith("/")) {
            requestUrl = requestUrl + "/";
        }
        return new URL(requestUrl + path);
    }

    protected int getRefreshRequestReadTimeout() {
        return 3000;
    }
}

