/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.BehaviorSelector;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.BehaviorReadable;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.NestedReferrerListGateway;
import org.seasar.dbflute.bhv.ReferrerConditionSetupper;
import org.seasar.dbflute.bhv.ReferrerListHandler;
import org.seasar.dbflute.bhv.ReferrerLoaderHandler;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.dbflute.bhv.core.command.AbstractEntityCommand;
import org.seasar.dbflute.bhv.core.command.InsertEntityCommand;
import org.seasar.dbflute.bhv.core.command.SelectCountCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectCursorCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectListCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectNextValCommand;
import org.seasar.dbflute.bhv.core.command.SelectNextValSubCommand;
import org.seasar.dbflute.bhv.core.command.SelectScalarCBCommand;
import org.seasar.dbflute.cbean.AndQuery;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.OrQuery;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.chelper.HpSLSExecutor;
import org.seasar.dbflute.cbean.chelper.HpSLSFunction;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.CursorSelectOption;
import org.seasar.dbflute.cbean.sqlclause.clause.SelectClauseType;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByElement;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.IllegalBehaviorStateException;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.PagingOverSafetySizeException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.optional.OptionalEntity;
import org.seasar.dbflute.optional.OptionalObjectExceptionThrower;
import org.seasar.dbflute.optional.RelationOptionalFactory;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractBehaviorReadable<ENTITY extends Entity, CB extends ConditionBean>
implements BehaviorReadable {
    protected static final String DERIVED_MAPPABLE_ALIAS_PREFIX = "$";
    protected static final NestedReferrerListGateway<?> EMPTY_NREF_LGWAY = new NestedReferrerListGateway<Entity>(){

        @Override
        public void withNestedReferrer(ReferrerListHandler<Entity> handler) {
            List emptyList = DfCollectionUtil.emptyList();
            handler.handle(emptyList);
        }
    };
    protected BehaviorCommandInvoker _behaviorCommandInvoker;
    protected BehaviorSelector _behaviorSelector;

    @Override
    public String getTableDbName() {
        return this.getDBMeta().getTableDbName();
    }

    public ENTITY newEntity() {
        return (ENTITY)this.getDBMeta().newEntity();
    }

    public abstract CB newConditionBean();

    protected int facadeSelectCount(CB cb) {
        return this.doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(CB cb) {
        this.assertCBStateValid((ConditionBean)cb);
        return this.delegateSelectCountUniquely((ConditionBean)cb);
    }

    protected int doSelectCountPlainly(CB cb) {
        this.assertCBStateValid((ConditionBean)cb);
        return this.delegateSelectCountPlainly((ConditionBean)cb);
    }

    @Override
    public int readCount(ConditionBean cb) {
        this.assertCBStateValid(cb);
        return this.doReadCount(cb);
    }

    protected int doReadCount(ConditionBean cb) {
        return this.facadeSelectCount(this.downcast(cb));
    }

    protected <RESULT extends ENTITY> RESULT doSelectEntity(CB cb, Class<? extends RESULT> entityType) {
        return this.helpSelectEntityInternally(cb, entityType);
    }

    protected ENTITY facadeSelectEntityWithDeletedCheck(CB cb) {
        return this.doSelectEntityWithDeletedCheck(cb, this.typeOfSelectedEntity());
    }

    protected <RESULT extends ENTITY> RESULT doSelectEntityWithDeletedCheck(CB cb, Class<? extends RESULT> entityType) {
        this.assertCBStateValid((ConditionBean)cb);
        this.assertObjectNotNull("entityType", entityType);
        return this.helpSelectEntityWithDeletedCheckInternally(cb, entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT extends ENTITY> RESULT helpSelectEntityInternally(CB cb, Class<? extends RESULT> entityType) {
        List<RESULT> ls;
        this.assertConditionBeanSelectResource(cb, entityType);
        if (cb.hasSelectAllPossible() && cb.getFetchSize() != 1) {
            this.throwSelectEntityConditionNotFoundException((ConditionBean)cb);
        }
        int preSafetyMaxResultSize = this.xcheckSafetyResultAsOne((ConditionBean)cb);
        try {
            ls = this.delegateSelectList((ConditionBean)cb, entityType);
        }
        catch (FetchingOverSafetySizeException e) {
            this.throwSelectEntityDuplicatedException("{over safetyMaxResultSize '1'}", cb, e);
            RESULT RESULT = null;
            return RESULT;
        }
        finally {
            this.xrestoreSafetyResult((ConditionBean)cb, preSafetyMaxResultSize);
        }
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (RESULT)((Entity)ls.get(0));
    }

    protected <RESULT extends ENTITY> RESULT helpSelectEntityWithDeletedCheckInternally(CB cb, Class<? extends RESULT> entityType) {
        RESULT entity = this.helpSelectEntityInternally(cb, entityType);
        this.assertEntityNotDeleted((Entity)entity, (Object)cb);
        return entity;
    }

    protected int xcheckSafetyResultAsOne(ConditionBean cb) {
        int safetyMaxResultSize = cb.getSafetyMaxResultSize();
        cb.checkSafetyResult(1);
        return safetyMaxResultSize;
    }

    protected void xrestoreSafetyResult(ConditionBean cb, int preSafetyMaxResultSize) {
        cb.checkSafetyResult(preSafetyMaxResultSize);
    }

    protected void assertEntityNotDeleted(Entity entity, Object searchKey) {
        if (entity == null) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
    }

    protected void assertEntityNotDeleted(List<? extends Entity> ls, Object searchKey) {
        if (ls == null || ls.isEmpty()) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
    }

    protected void assertEntitySelectedAsOne(List<? extends Entity> ls, Object searchKey) {
        if (ls == null || ls.isEmpty()) {
            this.throwSelectEntityAlreadyDeletedException(searchKey);
        }
        if (ls.size() > 1) {
            this.throwSelectEntityDuplicatedException(String.valueOf(ls.size()), searchKey, null);
        }
    }

    protected void throwSelectEntityAlreadyDeletedException(Object searchKey) {
        this.createBhvExThrower().throwSelectEntityAlreadyDeletedException(searchKey);
    }

    protected void throwSelectEntityDuplicatedException(String resultCountExp, Object searchKey, Throwable cause) {
        this.createBhvExThrower().throwSelectEntityDuplicatedException(resultCountExp, searchKey, cause);
    }

    protected void throwSelectEntityConditionNotFoundException(ConditionBean cb) {
        this.createBhvExThrower().throwSelectEntityConditionNotFoundException(cb);
    }

    @Override
    public Entity readEntity(ConditionBean cb) {
        this.assertCBStateValid(cb);
        return this.doReadEntity(cb);
    }

    protected abstract Entity doReadEntity(ConditionBean var1);

    protected <RESULT> OptionalEntity<RESULT> createOptionalEntity(RESULT entity, final Object ... searchKey) {
        return new OptionalEntity<RESULT>(entity, new OptionalObjectExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                AbstractBehaviorReadable.this.throwSelectEntityAlreadyDeletedException(searchKey);
            }
        });
    }

    @Override
    public Entity readEntityWithDeletedCheck(ConditionBean cb) {
        this.assertCBStateValid(cb);
        return this.doReadEntityWithDeletedCheck(cb);
    }

    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return this.facadeSelectEntityWithDeletedCheck(this.downcast(cb));
    }

    protected ListResultBean<ENTITY> facadeSelectList(CB cb) {
        return this.doSelectList(cb, this.typeOfSelectedEntity());
    }

    protected <RESULT extends ENTITY> ListResultBean<RESULT> doSelectList(CB cb, Class<? extends RESULT> entityType) {
        return this.helpSelectListInternally(cb, entityType);
    }

    protected <RESULT extends ENTITY> ListResultBean<RESULT> helpSelectListInternally(CB cb, Class<? extends RESULT> entityType) {
        this.assertConditionBeanSelectResource(cb, entityType);
        try {
            List<? extends RESULT> selectedList = this.delegateSelectList((ConditionBean)cb, entityType);
            return this.createListResultBean((ConditionBean)cb, (List<RESULT>)selectedList);
        }
        catch (FetchingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException((FetchBean)cb, e);
            return null;
        }
    }

    protected <RESULT extends Entity> ListResultBean<RESULT> createListResultBean(ConditionBean cb, List<RESULT> selectedList) {
        return new ResultBeanBuilder<RESULT>(this.getTableDbName()).buildListResultBean(cb, selectedList);
    }

    protected boolean isEntityDerivedMappable() {
        return false;
    }

    protected void throwSpecifyDerivedReferrerEntityPropertyNotFoundException(String alias, Class<?> entityType) {
        this.createCBExThrower().throwSpecifyDerivedReferrerEntityPropertyNotFoundException(alias, entityType);
    }

    @Override
    public <RESULT extends Entity> ListResultBean<RESULT> readList(ConditionBean cb) {
        this.assertCBStateValid(cb);
        ListResultBean<Entity> entityList = this.doReadList(cb);
        return entityList;
    }

    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return this.facadeSelectList(this.downcast(cb));
    }

    protected PagingResultBean<ENTITY> facadeSelectPage(CB cb) {
        return this.doSelectPage(cb, this.typeOfSelectedEntity());
    }

    protected <RESULT extends ENTITY> PagingResultBean<RESULT> doSelectPage(CB cb, Class<? extends RESULT> entityType) {
        return this.helpSelectPageInternally(cb, entityType);
    }

    protected <RESULT extends ENTITY> PagingResultBean<RESULT> helpSelectPageInternally(CB cb, Class<? extends RESULT> entityType) {
        this.assertConditionBeanSelectResource(cb, entityType);
        try {
            PagingHandler<? extends RESULT> handler = this.createPagingHandler(cb, entityType);
            PagingInvoker<RESULT> invoker = this.createPagingInvoker(cb);
            return invoker.invokePaging(handler);
        }
        catch (PagingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException((FetchBean)cb, e);
            return null;
        }
    }

    protected <RESULT extends ENTITY> PagingHandler<RESULT> createPagingHandler(CB cb, Class<? extends RESULT> entityType) {
        return new PagingHandler<RESULT>((ConditionBean)cb, entityType){
            final /* synthetic */ ConditionBean val$cb;
            final /* synthetic */ Class val$entityType;
            {
                this.val$cb = conditionBean;
                this.val$entityType = clazz;
            }

            @Override
            public PagingBean getPagingBean() {
                return this.val$cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int count() {
                try {
                    this.val$cb.getSqlClause().enablePagingAdjustment();
                    int n = AbstractBehaviorReadable.this.delegateSelectCountPlainly(this.val$cb);
                    return n;
                }
                finally {
                    this.val$cb.getSqlClause().disablePagingAdjustment();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RESULT> paging() {
                try {
                    this.val$cb.getSqlClause().enablePagingAdjustment();
                    List list = AbstractBehaviorReadable.this.delegateSelectList(this.val$cb, this.val$entityType);
                    return list;
                }
                finally {
                    this.val$cb.getSqlClause().disablePagingAdjustment();
                }
            }
        };
    }

    protected <RESULT extends ENTITY> PagingInvoker<RESULT> createPagingInvoker(CB cb) {
        return cb.createPagingInvoker(this.getTableDbName());
    }

    @Override
    public <RESULT extends Entity> PagingResultBean<RESULT> readPage(ConditionBean cb) {
        this.assertCBStateValid(cb);
        PagingResultBean<Entity> entityList = this.doReadPage(cb);
        return entityList;
    }

    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return this.facadeSelectPage(this.downcast(cb));
    }

    protected void facadeSelectCursor(CB cb, EntityRowHandler<ENTITY> entityRowHandler) {
        this.doSelectCursor(cb, entityRowHandler, this.typeOfSelectedEntity());
    }

    protected <RESULT extends ENTITY> void doSelectCursor(CB cb, EntityRowHandler<RESULT> handler, Class<? extends RESULT> entityType) {
        this.assertCBStateValid((ConditionBean)cb);
        this.assertObjectNotNull("entityRowHandler", handler);
        this.assertObjectNotNull("entityType", entityType);
        this.assertSpecifyDerivedReferrerEntityProperty((ConditionBean)cb, (Class<RESULT>)entityType);
        this.helpSelectCursorInternally(cb, handler, entityType);
    }

    protected <RESULT extends ENTITY> void helpSelectCursorInternally(CB cb, EntityRowHandler<RESULT> handler, Class<? extends RESULT> entityType) {
        this.assertObjectNotNull("entityRowHandler", handler);
        this.assertConditionBeanSelectResource(cb, entityType);
        CursorSelectOption option = cb.getCursorSelectOption();
        if (option != null && option.isByPaging()) {
            this.helpSelectCursorHandlingByPaging(cb, handler, entityType, option);
        } else {
            this.delegateSelectCursor((ConditionBean)cb, handler, entityType);
        }
    }

    protected <RESULT extends ENTITY> void helpSelectCursorHandlingByPaging(CB cb, EntityRowHandler<RESULT> entityRowHandler, Class<? extends RESULT> entityType, CursorSelectOption option) {
        this.helpSelectCursorCheckingByPagingAllowed(cb, option);
        this.helpSelectCursorCheckingOrderByPK(cb, option);
        int pageSize = option.getPageSize();
        int pageNumber = 1;
        while (true) {
            cb.paging(pageSize, pageNumber);
            List<RESULT> pageList = this.delegateSelectList((ConditionBean)cb, entityType);
            for (Entity entity : pageList) {
                entityRowHandler.handle(entity);
            }
            if (pageList.size() < pageSize) break;
            ++pageNumber;
        }
    }

    protected void helpSelectCursorCheckingByPagingAllowed(CB cb, CursorSelectOption option) {
        if (!cb.getSqlClause().isCursorSelectByPagingAllowed()) {
            String msg = "The cursor select by paging is not allowed at the DBMS.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void helpSelectCursorCheckingOrderByPK(CB cb, CursorSelectOption option) {
        OrderByClause orderByClause;
        OrderByElement orderByFirstElement;
        if (option.isOrderByPK() && ((orderByFirstElement = (orderByClause = cb.getOrderByComponent()).getOrderByFirstElement()) == null || !orderByFirstElement.getColumnInfo().isPrimary())) {
            String msg = "The cursor select by paging needs order by primary key: " + cb.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected <RESULT> HpSLSFunction<CB, RESULT> facadeScalarSelect(Class<RESULT> resultType) {
        return this.doScalarSelect(resultType, this.newConditionBean());
    }

    protected <RESULT> HpSLSFunction<CB, RESULT> doScalarSelect(Class<RESULT> resultType, CB cb) {
        this.assertObjectNotNull("resultType", resultType);
        this.assertCBStateValid((ConditionBean)cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex();
        HpSLSExecutor<CB, RESULT> executor = this.createHpSLSExecutor();
        return this.createSLSFunction(cb, resultType, executor);
    }

    protected <RESULT> HpSLSExecutor<CB, RESULT> createHpSLSExecutor() {
        return new HpSLSExecutor<CB, RESULT>(){

            @Override
            public RESULT execute(CB cb, Class<RESULT> resultType, SelectClauseType selectClauseType) {
                return AbstractBehaviorReadable.this.invoke(AbstractBehaviorReadable.this.createSelectScalarCBCommand((ConditionBean)cb, resultType, selectClauseType));
            }
        };
    }

    protected <RESULT> HpSLSFunction<CB, RESULT> createSLSFunction(CB cb, Class<RESULT> resultType, HpSLSExecutor<CB, RESULT> exec) {
        return new HpSLSFunction<CB, RESULT>(cb, resultType, exec);
    }

    protected <RESULT> HpSLSFunction<? extends ConditionBean, RESULT> doReadScalar(Class<RESULT> resultTYpe) {
        return this.facadeScalarSelect(resultTYpe);
    }

    @Override
    public <RESULT> HpSLSFunction<ConditionBean, RESULT> readScalar(Class<RESULT> resultType) {
        HpSLSFunction<ConditionBean, RESULT> func = this.doReadScalar(resultType);
        return func;
    }

    @Override
    public <BEHAVIOR extends BehaviorReadable> OutsideSqlBasicExecutor<BEHAVIOR> readyOutsideSql() {
        return this.doOutsideSql();
    }

    protected <BEHAVIOR extends BehaviorReadable> OutsideSqlBasicExecutor<BEHAVIOR> doOutsideSql() {
        this.assertBehaviorCommandInvoker("outsideSql");
        return this._behaviorCommandInvoker.createOutsideSqlBasicExecutor(this.getTableDbName());
    }

    @Override
    public Number readNextVal() {
        return this.doReadNextVal();
    }

    protected abstract Number doReadNextVal();

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> NestedReferrerListGateway<REFERRER_ENTITY> helpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, String referrerProperty) {
        return this.doHelpLoadReferrerInternally(localEntityList, loadReferrerOption, referrerProperty);
    }

    protected <LOCAL_ENTITY extends Entity, KEY, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> NestedReferrerListGateway<REFERRER_ENTITY> doHelpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, String referrerProperty) {
        InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY> callback;
        DBMeta dbmeta = this.getDBMeta();
        ReferrerInfo referrerInfo = dbmeta.findReferrerInfo(referrerProperty);
        BehaviorReadable referrerBhv = this.xfindReferrerBehavior(referrerInfo);
        Set<ColumnInfo> pkColSet = referrerInfo.getLocalReferrerColumnInfoMap().keySet();
        Map<ColumnInfo, ColumnInfo> mappingColMap = referrerInfo.getReferrerLocalColumnInfoMap();
        if (pkColSet.size() == 1) {
            ColumnInfo pkCol = pkColSet.iterator().next();
            ColumnInfo fkCol = mappingColMap.keySet().iterator().next();
            callback = this.xcreateLoadReferrerCallback(referrerProperty, dbmeta, referrerInfo, referrerBhv, pkCol, fkCol);
        } else {
            Set<ColumnInfo> fkColSet = mappingColMap.keySet();
            callback = this.xcreateLoadReferrerCallback(referrerProperty, dbmeta, referrerInfo, referrerBhv, pkColSet, fkColSet, mappingColMap);
        }
        return this.helpLoadReferrerInternally(localEntityList, loadReferrerOption, callback);
    }

    protected BehaviorReadable xfindReferrerBehavior(ReferrerInfo referrerInfo) {
        String behaviorName = referrerInfo.getReferrerDBMeta().getBehaviorTypeName();
        Class<?> behaviorType = DfReflectionUtil.forName(behaviorName);
        return this.xgetBSFLR().select(behaviorType);
    }

    protected <LOCAL_ENTITY extends Entity, KEY, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY> xcreateLoadReferrerCallback(final String referrerProperty, DBMeta dbmeta, final ReferrerInfo referrerInfo, final BehaviorReadable referrerBhv, final ColumnInfo pkCol, final ColumnInfo fkCol) {
        return new InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY>(){

            @Override
            public KEY getPKVal(LOCAL_ENTITY entity) {
                return pkCol.read((Entity)entity);
            }

            @Override
            public void setRfLs(LOCAL_ENTITY entity, List<REFERRER_ENTITY> referrerList) {
                referrerInfo.write((Entity)entity, referrerList);
            }

            @Override
            public REFERRER_CB newMyCB() {
                return referrerBhv.newConditionBean();
            }

            @Override
            public void qyFKIn(REFERRER_CB cb, Collection<KEY> pkList) {
                String conditionKey = ConditionKey.CK_IN_SCOPE.getConditionKey();
                cb.localCQ().invokeQuery(fkCol.getColumnDbName(), conditionKey, pkList);
            }

            @Override
            public void qyOdFKAsc(REFERRER_CB cb) {
                cb.localCQ().invokeOrderBy(fkCol.getColumnDbName(), true);
            }

            @Override
            public void spFKCol(REFERRER_CB cb) {
                cb.localSp().xspecifyColumn(fkCol.getColumnDbName());
            }

            @Override
            public List<REFERRER_ENTITY> selRfLs(REFERRER_CB cb) {
                return referrerBhv.readList((ConditionBean)cb);
            }

            @Override
            public KEY getFKVal(REFERRER_ENTITY entity) {
                Class<?> fkType = fkCol.getObjectNativeType();
                Class<?> pkType = pkCol.getObjectNativeType();
                Object fkValue = fkCol.read((Entity)entity);
                return AbstractBehaviorReadable.this.xconvertFK2PKImplicitly(referrerProperty, fkType, pkType, fkValue);
            }

            @Override
            public void setlcEt(REFERRER_ENTITY referrerEntity, LOCAL_ENTITY localEntity) {
                RelationInfo reverseInfo = referrerInfo.getReverseRelation();
                Object written = AbstractBehaviorReadable.this.xconvertToRelationOptionalEntityIfNeeds(localEntity, reverseInfo);
                reverseInfo.write((Entity)referrerEntity, written);
            }

            @Override
            public String getRfPrNm() {
                return referrerProperty;
            }
        };
    }

    protected <LOCAL_ENTITY extends Entity, KEY, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY> xcreateLoadReferrerCallback(final String referrerProperty, DBMeta dbmeta, final ReferrerInfo referrerInfo, final BehaviorReadable referrerBhv, final Set<ColumnInfo> pkColSet, final Set<ColumnInfo> fkColSet, final Map<ColumnInfo, ColumnInfo> mappingColMap) {
        return new InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY>(){

            @Override
            public KEY getPKVal(LOCAL_ENTITY entity) {
                Map<String, Object> keyMap = AbstractBehaviorReadable.this.xnewLoadReferrerCompoundKeyMap();
                for (ColumnInfo pkCol : pkColSet) {
                    keyMap.put(pkCol.getColumnDbName(), pkCol.read((Entity)entity));
                }
                return keyMap;
            }

            @Override
            public void setRfLs(LOCAL_ENTITY entity, List<REFERRER_ENTITY> referrerList) {
                referrerInfo.write((Entity)entity, referrerList);
            }

            @Override
            public REFERRER_CB newMyCB() {
                return referrerBhv.newConditionBean();
            }

            @Override
            public void qyFKIn(REFERRER_CB cb, final Collection<KEY> pkList) {
                cb.invokeOrScopeQuery(new OrQuery<ConditionBean>(){

                    @Override
                    public void query(ConditionBean orCB) {
                        for (Object pkKey : pkList) {
                            final Map pkMap = (Map)pkKey;
                            orCB.invokeOrScopeQueryAndPart(new AndQuery<ConditionBean>(){

                                @Override
                                public void query(ConditionBean andCB) {
                                    for (ColumnInfo fkCol : fkColSet) {
                                        ColumnInfo pkCol = (ColumnInfo)mappingColMap.get(fkCol);
                                        Object pkValue = pkMap.get(pkCol.getColumnDbName());
                                        andCB.localCQ().invokeQueryEqual(fkCol.getColumnDbName(), pkValue);
                                    }
                                }
                            });
                        }
                    }
                });
            }

            @Override
            public void qyOdFKAsc(REFERRER_CB cb) {
                for (ColumnInfo fkCol : fkColSet) {
                    cb.localCQ().invokeOrderBy(fkCol.getColumnDbName(), true);
                }
            }

            @Override
            public void spFKCol(REFERRER_CB cb) {
                for (ColumnInfo fkCol : fkColSet) {
                    cb.localSp().xspecifyColumn(fkCol.getColumnDbName());
                }
            }

            @Override
            public List<REFERRER_ENTITY> selRfLs(REFERRER_CB cb) {
                return referrerBhv.readList((ConditionBean)cb);
            }

            @Override
            public KEY getFKVal(REFERRER_ENTITY entity) {
                Map<String, Object> fkMap = AbstractBehaviorReadable.this.xnewLoadReferrerCompoundKeyMap();
                for (ColumnInfo fkCol : fkColSet) {
                    Class<?> pkType;
                    Object fkValue = fkCol.read((Entity)entity);
                    ColumnInfo pkCol = (ColumnInfo)mappingColMap.get(fkCol);
                    String mapKey = pkCol.getColumnDbName();
                    Class<?> fkType = fkCol.getObjectNativeType();
                    Object realValue = fkType.equals(pkType = pkCol.getObjectNativeType()) ? fkValue : AbstractBehaviorReadable.this.xconvertFK2PKImplicitly(referrerProperty, fkType, pkType, fkValue);
                    fkMap.put(mapKey, realValue);
                }
                return fkMap;
            }

            @Override
            public void setlcEt(REFERRER_ENTITY referrerEntity, LOCAL_ENTITY localEntity) {
                RelationInfo reverseInfo = referrerInfo.getReverseRelation();
                Object written = AbstractBehaviorReadable.this.xconvertToRelationOptionalEntityIfNeeds(localEntity, reverseInfo);
                reverseInfo.write((Entity)referrerEntity, written);
            }

            @Override
            public String getRfPrNm() {
                return referrerProperty;
            }
        };
    }

    protected <KEY> KEY xconvertFK2PKImplicitly(String referrerProperty, Class<?> fkType, Class<?> pkType, Object fkValue) {
        Object realValue = fkType.equals(pkType) ? fkValue : (String.class.equals(pkType) ? fkValue.toString() : (Number.class.isAssignableFrom(pkType) ? DfTypeUtil.toNumber(fkValue, pkType) : (Date.class.isAssignableFrom(fkType) ? (Date.class.equals(pkType) ? new Date(((Date)fkValue).getTime()) : (Timestamp.class.equals(pkType) ? new Timestamp(((Date)fkValue).getTime()) : fkValue)) : fkValue)));
        return (KEY)realValue;
    }

    protected Object xconvertToRelationOptionalEntityIfNeeds(Object localEntity, RelationInfo reverseInfo) {
        Object writtenObj = this.isRelationOptional(reverseInfo.getPropertyAccessType()) ? this.toRelationOptional(reverseInfo.getRelationPropertyName(), localEntity) : localEntity;
        return writtenObj;
    }

    protected <LOCAL_ENTITY extends Entity, KEY, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> NestedReferrerListGateway<REFERRER_ENTITY> helpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY> callback) {
        return this.doHelpLoadReferrerInternally(localEntityList, loadReferrerOption, callback);
    }

    protected <LOCAL_ENTITY extends Entity, KEY, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> NestedReferrerListGateway<REFERRER_ENTITY> doHelpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, final InternalLoadReferrerCallback<LOCAL_ENTITY, KEY, REFERRER_CB, REFERRER_ENTITY> callback) {
        KEY referrerListKey;
        boolean hasFixedCondition;
        this.assertBehaviorSelectorNotNull("loadReferrer");
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
        if (localEntityList.isEmpty()) {
            NestedReferrerListGateway<?> empty = EMPTY_NREF_LGWAY;
            return empty;
        }
        LinkedHashMap<KEY, Entity> pkLocalEntityMap = new LinkedHashMap<KEY, Entity>();
        final LinkedHashSet<KEY> pkSet = new LinkedHashSet<KEY>();
        for (Entity localEntity : localEntityList) {
            KEY primaryKeyValue = callback.getPKVal(localEntity);
            if (primaryKeyValue == null) {
                String msg = "PK value of local entity should not be null: " + localEntity;
                throw new IllegalArgumentException(msg);
            }
            pkSet.add(primaryKeyValue);
            pkLocalEntityMap.put(this.toLoadReferrerMappingKey(primaryKeyValue), localEntity);
        }
        REFERRER_CB cb = loadReferrerOption.getReferrerConditionBean() != null ? loadReferrerOption.getReferrerConditionBean() : callback.newMyCB();
        callback.qyFKIn(cb, pkSet);
        String referrerPropertyName = callback.getRfPrNm();
        final String fixedCondition = this.xbuildReferrerCorrelatedFixedCondition((ConditionBean)cb, referrerPropertyName);
        final String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        boolean bl = hasFixedCondition = fixedCondition != null && fixedCondition.trim().length() > 0;
        if (hasFixedCondition) {
            cb.getSqlClause().registerWhereClause(fixedCondition, basePointAliasName);
        }
        cb.xregisterUnionQuerySynchronizer(new UnionQuery<ConditionBean>(){

            @Override
            public void query(ConditionBean unionCB) {
                ConditionBean referrerUnionCB = unionCB;
                callback.qyFKIn(referrerUnionCB, pkSet);
                if (hasFixedCondition) {
                    referrerUnionCB.getSqlClause().registerWhereClause(fixedCondition, basePointAliasName);
                }
            }
        });
        if (pkSet.size() > 1) {
            callback.qyOdFKAsc(cb);
            cb.getOrderByComponent().exchangeFirstOrderByElementForLastOne();
        }
        loadReferrerOption.delegateConditionBeanSettingUp(cb);
        if (cb.getSqlClause().hasSpecifiedSelectColumn(basePointAliasName)) {
            callback.spFKCol(cb);
        }
        final List<REFERRER_ENTITY> referrerList = callback.selRfLs(cb);
        loadReferrerOption.delegateEntitySettingUp(referrerList);
        LinkedHashMap pkReferrerListMap = new LinkedHashMap();
        for (Entity referrerEntity : referrerList) {
            KEY foreignKeyValue = callback.getFKVal(referrerEntity);
            referrerListKey = this.toLoadReferrerMappingKey(foreignKeyValue);
            if (!pkReferrerListMap.containsKey(referrerListKey)) {
                pkReferrerListMap.put(referrerListKey, new ArrayList());
            }
            ((List)pkReferrerListMap.get(referrerListKey)).add(referrerEntity);
            Entity localEntity = (Entity)pkLocalEntityMap.get(referrerListKey);
            callback.setlcEt(referrerEntity, localEntity);
        }
        for (Entity localEntity : localEntityList) {
            KEY primaryKey = callback.getPKVal(localEntity);
            referrerListKey = this.toLoadReferrerMappingKey(primaryKey);
            if (pkReferrerListMap.containsKey(referrerListKey)) {
                callback.setRfLs(localEntity, (List)pkReferrerListMap.get(referrerListKey));
                continue;
            }
            callback.setRfLs(localEntity, new ArrayList());
        }
        return new NestedReferrerListGateway<REFERRER_ENTITY>(){

            @Override
            public void withNestedReferrer(ReferrerListHandler<REFERRER_ENTITY> handler) {
                handler.handle(Collections.unmodifiableList(referrerList));
            }
        };
    }

    protected String xbuildReferrerCorrelatedFixedCondition(ConditionBean cb, String referrerPropertyName) {
        if (referrerPropertyName == null) {
            return null;
        }
        DBMeta localDBMeta = this.getDBMeta();
        if (!localDBMeta.hasReferrer(referrerPropertyName)) {
            return null;
        }
        ReferrerInfo referrerInfo = localDBMeta.findReferrerInfo(referrerPropertyName);
        return this.xdoBuildReferrerCorrelatedFixedCondition(cb, referrerInfo);
    }

    protected String xdoBuildReferrerCorrelatedFixedCondition(ConditionBean cb, ReferrerInfo referrerInfo) {
        RelationInfo reverseRelation = referrerInfo.getReverseRelation();
        if (reverseRelation == null) {
            return null;
        }
        if (!(reverseRelation instanceof ForeignInfo)) {
            String msg = "The reverse relation (referrer's reverse) should be foreign info: " + referrerInfo;
            throw new IllegalStateException(msg);
        }
        ForeignInfo foreignInfo = (ForeignInfo)reverseRelation;
        String fixedCondition = foreignInfo.getFixedCondition();
        if (fixedCondition == null || fixedCondition.trim().length() == 0) {
            return null;
        }
        String localAliasMark = "$$localAlias$$";
        String basePointAliasName = cb.getSqlClause().getBasePointAliasName();
        return Srl.replace(fixedCondition, "$$localAlias$$", basePointAliasName);
    }

    protected <PK> PK toLoadReferrerMappingKey(PK value) {
        if (value instanceof String) {
            return (PK)this.toLowerCaseIfString(value);
        }
        if (value instanceof Map) {
            Map pkMap = (Map)value;
            Map<String, Object> filteredMap = this.xnewLoadReferrerCompoundKeyMap();
            for (Map.Entry entry : pkMap.entrySet()) {
                String key = (String)entry.getKey();
                Object element = entry.getValue();
                if (element instanceof String) {
                    filteredMap.put(key, this.toLowerCaseIfString(element));
                    continue;
                }
                filteredMap.put(key, element);
            }
            return (PK)filteredMap;
        }
        return value;
    }

    protected Map<String, Object> xnewLoadReferrerCompoundKeyMap() {
        return new LinkedHashMap<String, Object>();
    }

    protected <ELEMENT extends Entity> List<ELEMENT> xnewLRAryLs(ELEMENT entity) {
        ArrayList<ELEMENT> ls = new ArrayList<ELEMENT>(1);
        ls.add(entity);
        return ls;
    }

    protected void xassLRArg(List<? extends Entity> entityList, ReferrerLoaderHandler<?> handler) {
        this.assertObjectNotNull("LoadReferrer's entityList", entityList);
        this.assertObjectNotNull("LoadReferrer's handler", handler);
    }

    protected void xassLRArg(Entity entity, ReferrerLoaderHandler<?> handler) {
        this.assertObjectNotNull("LoadReferrer's entity", entity);
        this.assertObjectNotNull("LoadReferrer's handler", handler);
    }

    protected void xassLRArg(List<? extends Entity> entityList, ReferrerConditionSetupper<? extends ConditionBean> setupper) {
        this.assertObjectNotNull("LoadReferrer's entityList", entityList);
        this.assertObjectNotNull("LoadReferrer's setupper", setupper);
    }

    protected void xassLRArg(Entity entity, ReferrerConditionSetupper<? extends ConditionBean> setupper) {
        this.assertObjectNotNull("LoadReferrer's entity", entity);
        this.assertObjectNotNull("LoadReferrer's setupper", setupper);
    }

    protected void xassLRArg(List<? extends Entity> entityList, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("LoadReferrer's entityList", entityList);
        this.assertObjectNotNull("LoadReferrer's loadReferrerOption", loadReferrerOption);
    }

    protected void xassLRArg(Entity entity, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("LoadReferrer's entity", entity);
        this.assertObjectNotNull("LoadReferrer's loadReferrerOption", loadReferrerOption);
    }

    protected BehaviorSelector xgetBSFLR() {
        this.assertBehaviorSelectorNotNull("loadReferrer");
        return this.getBehaviorSelector();
    }

    private void assertBehaviorSelectorNotNull(String methodName) {
        if (this._behaviorSelector != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the selector of behavior in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the selector at your component configuration of DBFlute.");
        br.addElement("It is precondition that '" + methodName + "()' needs the selector instance.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    protected <ELEMENT> List<ELEMENT> xnewLRLs(ELEMENT element) {
        ArrayList<ELEMENT> ls = new ArrayList<ELEMENT>(1);
        ls.add(element);
        return ls;
    }

    protected <LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> List<FOREIGN_ENTITY> helpPulloutInternally(List<LOCAL_ENTITY> localEntityList, String foreignPropertyName) {
        Object foreignEntity;
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("foreignPropertyName", foreignPropertyName);
        DBMeta dbmeta = this.getDBMeta();
        ForeignInfo foreignInfo = dbmeta.findForeignInfo(foreignPropertyName);
        RelationInfo reverseInfo = foreignInfo.getReverseRelation();
        boolean existsReferrer = reverseInfo != null;
        RelationOptionalFactory optionalFactory = this.xgetROpFactory();
        LinkedHashMap foreignBasicMap = new LinkedHashMap();
        Map foreignCollisionMap = null;
        LinkedHashMap foreignReferrerMap = new LinkedHashMap();
        for (Entity entity : localEntityList) {
            foreignEntity = this.xextractPulloutForeignEntity(foreignInfo, reverseInfo, optionalFactory, entity);
            if (foreignEntity == null) continue;
            foreignCollisionMap = this.xsavePulloutForeignEntity(foreignBasicMap, foreignCollisionMap, foreignEntity);
            if (!existsReferrer) continue;
            if (!foreignReferrerMap.containsKey(foreignEntity)) {
                foreignReferrerMap.put(foreignEntity, new ArrayList());
            }
            ((List)foreignReferrerMap.get(foreignEntity)).add(entity);
        }
        if (existsReferrer) {
            for (Map.Entry entry : foreignReferrerMap.entrySet()) {
                foreignEntity = (Entity)entry.getKey();
                List mappedLocalList = (List)entry.getValue();
                Object writtenObj = this.xextractPulloutReverseWrittenObject(foreignInfo, reverseInfo, optionalFactory, mappedLocalList);
                reverseInfo.write((Entity)foreignEntity, writtenObj);
            }
        }
        return this.xpreparePulloutResultList(foreignBasicMap, foreignCollisionMap);
    }

    protected <LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> FOREIGN_ENTITY xextractPulloutForeignEntity(ForeignInfo foreignInfo, RelationInfo reverseInfo, RelationOptionalFactory optionalFactory, LOCAL_ENTITY localEntity) {
        Object mightBeOptional = foreignInfo.read(localEntity);
        Entity foreignEntity = optionalFactory.isOptional(mightBeOptional) ? (Entity)optionalFactory.orElseNull(mightBeOptional) : (Entity)mightBeOptional;
        return (FOREIGN_ENTITY)foreignEntity;
    }

    protected <FOREIGN_ENTITY extends Entity> Map<Integer, List<FOREIGN_ENTITY>> xsavePulloutForeignEntity(Map<Integer, FOREIGN_ENTITY> foreignBasicMap, Map<Integer, List<FOREIGN_ENTITY>> foreignCollisionMap, FOREIGN_ENTITY foreignEntity) {
        int instanceHash = foreignEntity.instanceHash();
        if (!foreignBasicMap.containsKey(instanceHash)) {
            foreignBasicMap.put(instanceHash, foreignEntity);
        } else {
            Entity firstEntity = (Entity)foreignBasicMap.get(instanceHash);
            if (firstEntity != null && foreignEntity == firstEntity) {
                return foreignCollisionMap;
            }
            if (foreignCollisionMap == null) {
                foreignCollisionMap = new LinkedHashMap<Integer, List<FOREIGN_ENTITY>>(2);
            }
            if (firstEntity != null) {
                foreignBasicMap.put(instanceHash, null);
            }
            if (!foreignCollisionMap.containsKey(instanceHash)) {
                foreignCollisionMap.put(instanceHash, new ArrayList(2));
            }
            List<FOREIGN_ENTITY> collisionList = foreignCollisionMap.get(instanceHash);
            for (Entity collision : collisionList) {
                if (collision != foreignEntity) continue;
                return foreignCollisionMap;
            }
            if (firstEntity != null) {
                collisionList.add(firstEntity);
            }
            collisionList.add(foreignEntity);
        }
        return foreignCollisionMap;
    }

    protected <LOCAL_ENTITY extends Entity> Object xextractPulloutReverseWrittenObject(ForeignInfo foreignInfo, RelationInfo reverseInfo, RelationOptionalFactory optionalFactory, List<LOCAL_ENTITY> mappedLocalList) {
        Entity plainFirstElement;
        Object writtenObj = foreignInfo.isOneToOne() ? (mappedLocalList != null && !mappedLocalList.isEmpty() ? ((plainFirstElement = (Entity)mappedLocalList.get(0)) != null && optionalFactory.isOptionalType(reverseInfo.getPropertyAccessType()) ? optionalFactory.createOptionalPresentEntity(plainFirstElement) : plainFirstElement) : null) : mappedLocalList;
        return writtenObj;
    }

    protected <FOREIGN_ENTITY extends Entity> List<FOREIGN_ENTITY> xpreparePulloutResultList(Map<Integer, FOREIGN_ENTITY> foreignBasicMap, Map<Integer, List<FOREIGN_ENTITY>> foreignCollisionMap) {
        ArrayList<Entity> resultList = new ArrayList<Entity>(foreignBasicMap.size() + 1);
        for (Map.Entry<Integer, FOREIGN_ENTITY> entry : foreignBasicMap.entrySet()) {
            Entity foreignEntity = (Entity)entry.getValue();
            if (foreignEntity != null) {
                resultList.add(foreignEntity);
                continue;
            }
            if (foreignCollisionMap == null) {
                String msg = "Not lazy-loaded the collision map: basicMap=" + foreignBasicMap;
                throw new IllegalStateException(msg);
            }
            Integer instanceHash = entry.getKey();
            List<FOREIGN_ENTITY> savedList = foreignCollisionMap.get(instanceHash);
            if (savedList == null) {
                String msg = "Not found the saved entity list in the collision map:";
                msg = msg + " key=" + instanceHash + ", collisionMap=" + foreignCollisionMap;
                throw new IllegalStateException(msg);
            }
            for (Entity savedEntity : savedList) {
                resultList.add(savedEntity);
            }
        }
        return resultList;
    }

    protected <LOCAL_ENTITY extends Entity, COLUMN> List<COLUMN> helpExtractListInternally(List<LOCAL_ENTITY> localEntityList, String propertyName) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("propertyName", propertyName);
        ArrayList valueList = new ArrayList();
        return this.xdoHelpExtractSetInternally(localEntityList, propertyName, valueList);
    }

    protected <LOCAL_ENTITY extends Entity, COLUMN> Set<COLUMN> helpExtractSetInternally(List<LOCAL_ENTITY> localEntityList, String propertyName) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("propertyName", propertyName);
        LinkedHashSet valueSet = new LinkedHashSet();
        return this.xdoHelpExtractSetInternally(localEntityList, propertyName, valueSet);
    }

    protected <LOCAL_ENTITY extends Entity, COLUMN, COLLECTION extends Collection<COLUMN>> COLLECTION xdoHelpExtractSetInternally(List<LOCAL_ENTITY> localEntityList, String propertyName, COLLECTION collection) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("propertyName", propertyName);
        ColumnInfo columnInfo = this.getDBMeta().findColumnInfo(propertyName);
        for (Entity entity : localEntityList) {
            Object column = columnInfo.read(entity);
            if (column == null) continue;
            collection.add(column);
        }
        return collection;
    }

    protected void filterEntityOfInsert(Entity targetEntity, InsertOption<? extends ConditionBean> option) {
    }

    protected int delegateSelectCountUniquely(ConditionBean cb) {
        return this.invoke(this.createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(ConditionBean cb) {
        return this.invoke(this.createSelectCountCBCommand(cb, false));
    }

    protected <RESULT extends ENTITY> void delegateSelectCursor(ConditionBean cb, EntityRowHandler<RESULT> handler, Class<? extends RESULT> entityType) {
        this.invoke(this.createSelectCursorCBCommand(cb, handler, entityType));
    }

    protected <RESULT extends ENTITY> List<RESULT> delegateSelectList(ConditionBean cb, Class<? extends RESULT> entityType) {
        return (List)this.invoke(this.createSelectListCBCommand(cb, entityType));
    }

    protected <RESULT> RESULT delegateSelectNextVal(Class<RESULT> resultType) {
        return this.invoke(this.createSelectNextValCommand(resultType));
    }

    protected <RESULT> RESULT delegateSelectNextValSub(Class<RESULT> resultType, String columnDbName, String sequenceName, Integer incrementSize, Integer cacheSize) {
        return this.invoke(this.createSelectNextValSubCommand(resultType, columnDbName, sequenceName, incrementSize, cacheSize));
    }

    protected int delegateInsertNoPK(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.filterEntityOfInsert(entity, option);
        return this.invoke(this.createInsertEntityCommand(entity, option));
    }

    @Override
    public void warmUpCommand() {
        SelectCountCBCommand cmd = this.createSelectCountCBCommand((ConditionBean)this.newConditionBean(), true);
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        cmd = this.createSelectCountCBCommand((ConditionBean)this.newConditionBean(), false);
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        Class<? extends Entity> entityType = this.getDBMeta().getEntityType();
        SelectListCBCommand<? extends Entity> cmd2 = this.createSelectListCBCommand((ConditionBean)this.newConditionBean(), (Class)entityType);
        cmd2.setInitializeOnly(true);
        this.invoke(cmd2);
    }

    protected SelectCountCBCommand createSelectCountCBCommand(ConditionBean cb, boolean uniqueCount) {
        this.assertBehaviorCommandInvoker("createSelectCountCBCommand");
        SelectCountCBCommand cmd = this.newSelectCountCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setUniqueCount(uniqueCount);
        return cmd;
    }

    protected SelectCountCBCommand newSelectCountCBCommand() {
        return new SelectCountCBCommand();
    }

    protected <RESULT extends ENTITY> SelectCursorCBCommand<RESULT> createSelectCursorCBCommand(ConditionBean cb, EntityRowHandler<RESULT> entityRowHandler, Class<? extends RESULT> entityType) {
        this.assertBehaviorCommandInvoker("createSelectCursorCBCommand");
        SelectCursorCBCommand<RESULT> cmd = this.newSelectCursorCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setEntityType(entityType);
        cmd.setEntityRowHandler(entityRowHandler);
        return cmd;
    }

    protected <RESULT extends ENTITY> SelectCursorCBCommand<RESULT> newSelectCursorCBCommand() {
        return new SelectCursorCBCommand();
    }

    protected <RESULT extends ENTITY> SelectListCBCommand<RESULT> createSelectListCBCommand(ConditionBean cb, Class<? extends RESULT> entityType) {
        this.assertBehaviorCommandInvoker("createSelectListCBCommand");
        SelectListCBCommand<RESULT> cmd = this.newSelectListCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setEntityType(entityType);
        return cmd;
    }

    protected <RESULT extends ENTITY> SelectListCBCommand<RESULT> newSelectListCBCommand() {
        return new SelectListCBCommand();
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValCommand(Class<RESULT> resultType) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValCommand<RESULT> cmd = this.newSelectNextValCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setResultType(resultType);
        cmd.setDBMeta(this.getDBMeta());
        cmd.setSequenceCacheHandler(this._behaviorCommandInvoker.getSequenceCacheHandler());
        return cmd;
    }

    protected <RESULT> SelectNextValCommand<RESULT> newSelectNextValCommand() {
        return new SelectNextValCommand();
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValSubCommand(Class<RESULT> resultType, String columnDbName, String sequenceName, Integer incrementSize, Integer cacheSize) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValSubCommand<RESULT> cmd = this.newSelectNextValSubCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setResultType(resultType);
        cmd.setDBMeta(this.getDBMeta());
        cmd.setSequenceCacheHandler(this._behaviorCommandInvoker.getSequenceCacheHandler());
        cmd.setColumnInfo(this.getDBMeta().findColumnInfo(columnDbName));
        cmd.setSequenceName(sequenceName);
        cmd.setIncrementSize(incrementSize);
        cmd.setCacheSize(cacheSize);
        return cmd;
    }

    protected <RESULT> SelectNextValSubCommand<RESULT> newSelectNextValSubCommand() {
        return new SelectNextValSubCommand();
    }

    protected <RESULT> SelectScalarCBCommand<RESULT> createSelectScalarCBCommand(ConditionBean cb, Class<RESULT> resultType, SelectClauseType selectClauseType) {
        this.assertBehaviorCommandInvoker("createSelectScalarCBCommand");
        SelectScalarCBCommand<RESULT> cmd = this.newSelectScalarCBCommand();
        this.xsetupSelectCommand(cmd);
        cmd.setConditionBean(cb);
        cmd.setResultType(resultType);
        cmd.setSelectClauseType(selectClauseType);
        return cmd;
    }

    protected <RESULT> SelectScalarCBCommand<RESULT> newSelectScalarCBCommand() {
        return new SelectScalarCBCommand();
    }

    protected void xsetupSelectCommand(AbstractBehaviorCommand<?> cmd) {
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
    }

    protected InsertEntityCommand createInsertEntityCommand(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createInsertEntityCommand");
        InsertEntityCommand cmd = this.newInsertEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected InsertEntityCommand newInsertEntityCommand() {
        return new InsertEntityCommand();
    }

    protected void xsetupEntityCommand(AbstractEntityCommand cmd, Entity entity) {
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    protected void assertBehaviorCommandInvoker(String methodName) {
        if (this._behaviorCommandInvoker != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the invoker of behavior command in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addElement("It is precondition that '" + methodName + "()' needs the invoker instance.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    protected Object toRelationOptional(final String relationTitle, Object relationRow) {
        this.assertObjectNotNull("relationTitle", relationTitle);
        RelationOptionalFactory factory = this.xgetROpFactory();
        Object result = relationRow != null ? factory.createOptionalPresentEntity(relationRow) : factory.createOptionalNullEntity(new OptionalObjectExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                String msg = "Not found the relation row for: " + relationTitle;
                throw new EntityAlreadyDeletedException(msg);
            }
        });
        return result;
    }

    protected boolean isRelationOptional(Class<?> relationPropertyType) {
        this.assertObjectNotNull("relationPropertyType", relationPropertyType);
        RelationOptionalFactory factory = this.xgetROpFactory();
        return factory.isOptionalType(relationPropertyType);
    }

    protected RelationOptionalFactory xgetROpFactory() {
        this.assertBehaviorCommandInvoker("xgetROpFactory");
        return this._behaviorCommandInvoker.getRelationOptionalFactory();
    }

    protected abstract Class<? extends ENTITY> typeOfSelectedEntity();

    protected abstract Class<ENTITY> typeOfHandlingEntity();

    protected abstract Class<CB> typeOfHandlingConditionBean();

    protected ENTITY downcast(Entity entity) {
        return this.helpEntityDowncastInternally(entity, this.typeOfHandlingEntity());
    }

    protected <RESULT extends ENTITY> RESULT helpEntityDowncastInternally(Entity entity, Class<RESULT> clazz) {
        this.assertEntityNotNull(entity);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (RESULT)entity;
        }
        catch (ClassCastException e) {
            String classTitle = DfTypeUtil.toClassTitle(clazz);
            String msg = "The entity should be " + classTitle + " but it was: " + entity.getClass();
            throw new IllegalStateException(msg, e);
        }
    }

    protected CB downcast(ConditionBean cb) {
        return this.helpConditionBeanDowncastInternally(cb, this.typeOfHandlingConditionBean());
    }

    protected CB helpConditionBeanDowncastInternally(ConditionBean cb, Class<CB> clazz) {
        this.assertCBNotNull(cb);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (CB)cb;
        }
        catch (ClassCastException e) {
            String classTitle = DfTypeUtil.toClassTitle(clazz);
            String msg = "The condition-bean should be " + classTitle + " but it was: " + cb.getClass();
            throw new IllegalStateException(msg, e);
        }
    }

    protected List<ENTITY> downcast(List<? extends Entity> entityList) {
        return entityList;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        this.assertBehaviorCommandInvoker("createBhvExThrower");
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEntityNotNull(Entity entity) {
        if (entity == null) {
            String msg = "The entity should not be null: table=" + this.getTableDbName();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEntityNotNullAndHasPrimaryKeyValue(Entity entity) {
        this.assertEntityNotNull(entity);
        Set<String> uniqueDrivenPropSet = entity.myuniqueDrivenProperties();
        if (uniqueDrivenPropSet.isEmpty()) {
            if (!entity.hasPrimaryKeyValue()) {
                this.createBhvExThrower().throwEntityPrimaryKeyNotFoundException(entity);
            }
        } else {
            for (String prop : uniqueDrivenPropSet) {
                Object value;
                ColumnInfo columnInfo = this.getDBMeta().findColumnInfo(prop);
                if (columnInfo == null || (value = columnInfo.read(entity)) != null) continue;
                this.createBhvExThrower().throwEntityUniqueKeyNotFoundException(entity);
            }
        }
    }

    protected void assertEntityListNotNull(List<? extends Entity> entityList) {
        if (entityList == null) {
            String msg = "The list of entity should not be null: table=" + this.getTableDbName();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCBNotNull(ConditionBean cb) {
        if (cb == null) {
            String msg = "The condition-bean should not be null: table=" + this.getTableDbName();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCBStateValid(ConditionBean cb) {
        this.assertCBNotNull(cb);
        this.assertCBNotDreamCruise(cb);
    }

    protected void assertCBNotDreamCruise(ConditionBean cb) {
        if (cb.xisDreamCruiseShip()) {
            String msg = "The condition-bean should not be dream cruise: " + cb.getClass();
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected <RESULT extends ENTITY> void assertConditionBeanSelectResource(CB cb, Class<RESULT> entityType) {
        this.assertCBStateValid((ConditionBean)cb);
        this.assertObjectNotNull("entityType", entityType);
        this.assertSpecifyDerivedReferrerEntityProperty((ConditionBean)cb, entityType);
    }

    protected <RESULT extends ENTITY> void assertSpecifyDerivedReferrerEntityProperty(ConditionBean cb, Class<RESULT> entityType) {
        List<String> aliasList = cb.getSqlClause().getSpecifiedDerivingAliasList();
        if (aliasList.isEmpty()) {
            return;
        }
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(entityType);
        for (String alias : aliasList) {
            if (this.isEntityDerivedMappable() && alias.startsWith(DERIVED_MAPPABLE_ALIAS_PREFIX)) continue;
            DfPropertyDesc pd = null;
            if (beanDesc.hasPropertyDesc(alias)) {
                pd = beanDesc.getPropertyDesc(alias);
            } else {
                String noUnsco = Srl.replace(alias, "_", "");
                if (beanDesc.hasPropertyDesc(noUnsco)) {
                    pd = beanDesc.getPropertyDesc(noUnsco);
                }
            }
            if (pd != null && pd.hasWriteMethod()) continue;
            this.throwSpecifyDerivedReferrerEntityPropertyNotFoundException(alias, entityType);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (!ls.isEmpty()) {
            String msg = "The list should be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndNotEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.isEmpty()) {
            String msg = "The list should not be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndHasOnlyOne(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.size() != 1) {
            String msg = "The list should contain only one object: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected Object toLowerCaseIfString(Object obj) {
        if (obj != null && obj instanceof String) {
            return ((String)obj).toLowerCase();
        }
        return obj;
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected BehaviorCommandInvoker getBehaviorCommandInvoker() {
        return this._behaviorCommandInvoker;
    }

    public void setBehaviorCommandInvoker(BehaviorCommandInvoker behaviorCommandInvoker) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
    }

    protected BehaviorSelector getBehaviorSelector() {
        return this._behaviorSelector;
    }

    public void setBehaviorSelector(BehaviorSelector behaviorSelector) {
        this._behaviorSelector = behaviorSelector;
    }

    protected static interface InternalLoadReferrerCallback<LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> {
        public PK getPKVal(LOCAL_ENTITY var1);

        public void setRfLs(LOCAL_ENTITY var1, List<REFERRER_ENTITY> var2);

        public REFERRER_CB newMyCB();

        public void qyFKIn(REFERRER_CB var1, Collection<PK> var2);

        public void qyOdFKAsc(REFERRER_CB var1);

        public void spFKCol(REFERRER_CB var1);

        public List<REFERRER_ENTITY> selRfLs(REFERRER_CB var1);

        public PK getFKVal(REFERRER_ENTITY var1);

        public void setlcEt(REFERRER_ENTITY var1, LOCAL_ENTITY var2);

        public String getRfPrNm();
    }
}

