/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;

public final class ExtractJsonPathsBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("extractJsonPaths");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ExtractJsonPaths(this, config, parent, child, context);
    }

    private static final class ExtractJsonPaths
    extends AbstractCommand {
        private final boolean flatten;
        private final Map<String, Collection<String>> stepMap;
        private static final String ARRAY_TOKEN = "[]";

        public ExtractJsonPaths(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            ArrayListMultimap stepMultiMap = ArrayListMultimap.create();
            this.flatten = this.getConfigs().getBoolean(config, "flatten", true);
            Config paths = this.getConfigs().getConfig(config, "paths");
            for (Map.Entry entry : new Configs().getEntrySet(paths)) {
                String fieldName = (String)entry.getKey();
                String path = entry.getValue().toString().trim();
                if (path.contains("//")) {
                    throw new MorphlineCompilationException("No support for descendant axis available yet", config);
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                path = path.trim();
                for (String step : path.split("/")) {
                    if ((step = step.trim()).length() > ARRAY_TOKEN.length() && step.endsWith(ARRAY_TOKEN)) {
                        step = step.substring(0, step.length() - ARRAY_TOKEN.length());
                        stepMultiMap.put((Object)fieldName, (Object)this.normalize(step));
                        stepMultiMap.put((Object)fieldName, (Object)ARRAY_TOKEN);
                        continue;
                    }
                    stepMultiMap.put((Object)fieldName, (Object)this.normalize(step));
                }
            }
            this.stepMap = stepMultiMap.asMap();
            this.LOG.debug("stepMap: {}", this.stepMap);
            this.validateArguments();
        }

        private String normalize(String step) {
            return ARRAY_TOKEN.equals(step) ? ARRAY_TOKEN : step;
        }

        protected boolean doProcess(Record inputRecord) {
            JsonNode datum = (JsonNode)inputRecord.getFirstValue("_attachment_body");
            Preconditions.checkNotNull((Object)datum);
            Record outputRecord = inputRecord.copy();
            for (Map.Entry<String, Collection<String>> entry : this.stepMap.entrySet()) {
                String fieldName = entry.getKey();
                List steps = (List)entry.getValue();
                this.extractPath(datum, fieldName, steps, outputRecord, 0);
            }
            return this.getChild().process(outputRecord);
        }

        private void extractPath(JsonNode datum, String fieldName, List<String> steps, Record record, int level) {
            JsonNode value;
            if (level >= steps.size()) {
                return;
            }
            boolean isLeaf = level + 1 == steps.size();
            String step = steps.get(level);
            if (ARRAY_TOKEN == step) {
                if (datum.isArray()) {
                    if (isLeaf) {
                        this.resolve(datum, record, fieldName);
                    } else {
                        Iterator iter = datum.elements();
                        while (iter.hasNext()) {
                            this.extractPath((JsonNode)iter.next(), fieldName, steps, record, level + 1);
                        }
                    }
                }
            } else if (datum.isObject() && (value = datum.get(step)) != null) {
                if (isLeaf) {
                    this.resolve(value, record, fieldName);
                } else {
                    this.extractPath(value, fieldName, steps, record, level + 1);
                }
            }
        }

        private void resolve(JsonNode datum, Record record, String fieldName) {
            if (datum == null) {
                return;
            }
            if (this.flatten) {
                this.flatten(datum, record.get(fieldName));
                return;
            }
            if (datum.isObject()) {
                record.put(fieldName, (Object)datum);
            } else if (datum.isArray()) {
                record.put(fieldName, (Object)datum);
            } else if (datum.isTextual()) {
                record.put(fieldName, (Object)datum.asText());
            } else if (datum.isBoolean()) {
                record.put(fieldName, (Object)datum.asBoolean());
            } else if (datum.isInt()) {
                record.put(fieldName, (Object)datum.asInt());
            } else if (datum.isLong()) {
                record.put(fieldName, (Object)datum.asLong());
            } else if (datum.isShort()) {
                record.put(fieldName, (Object)datum.shortValue());
            } else if (datum.isDouble()) {
                record.put(fieldName, (Object)datum.asDouble());
            } else if (datum.isFloat()) {
                record.put(fieldName, (Object)Float.valueOf(datum.floatValue()));
            } else if (datum.isBigInteger()) {
                record.put(fieldName, (Object)datum.bigIntegerValue());
            } else if (datum.isBigDecimal()) {
                record.put(fieldName, (Object)datum.decimalValue());
            } else if (!datum.isNull()) {
                record.put(fieldName, (Object)datum.toString());
            }
        }

        private void flatten(JsonNode datum, List list) {
            if (datum == null) {
                return;
            }
            if (datum.isObject()) {
                for (JsonNode child : datum) {
                    this.flatten(child, list);
                }
            } else if (datum.isArray()) {
                Iterator iter = datum.elements();
                while (iter.hasNext()) {
                    this.flatten((JsonNode)iter.next(), list);
                }
            } else if (datum.isTextual()) {
                list.add(datum.asText());
            } else if (datum.isBoolean()) {
                list.add(datum.asBoolean());
            } else if (datum.isInt()) {
                list.add(datum.asInt());
            } else if (datum.isLong()) {
                list.add(datum.asLong());
            } else if (datum.isShort()) {
                list.add(datum.shortValue());
            } else if (datum.isDouble()) {
                list.add(datum.asDouble());
            } else if (datum.isFloat()) {
                list.add(Float.valueOf(datum.floatValue()));
            } else if (datum.isBigInteger()) {
                list.add(datum.bigIntegerValue());
            } else if (datum.isBigDecimal()) {
                list.add(datum.decimalValue());
            } else if (!datum.isNull()) {
                list.add(datum.toString());
            }
        }
    }
}

