/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.contentprotection;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.piff.ProtectionSpecificHeader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayReadyHeader
extends ProtectionSpecificHeader {
    public static UUID PROTECTION_SYSTEM_ID = UUID.fromString("9A04F079-9840-4286-AB92-E65BE0885F95");
    private long length;
    private List<PlayReadyRecord> records;

    static {
        ProtectionSpecificHeader.uuidRegistry.put(PROTECTION_SYSTEM_ID, PlayReadyHeader.class);
    }

    @Override
    public UUID getSystemId() {
        return PROTECTION_SYSTEM_ID;
    }

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.length = IsoTypeReader.readUInt32BE(byteBuffer);
        int recordCount = IsoTypeReader.readUInt16BE(byteBuffer);
        this.records = PlayReadyRecord.createFor(byteBuffer, recordCount);
    }

    @Override
    public ByteBuffer getData() {
        int size = 6;
        for (PlayReadyRecord record : this.records) {
            size += 4;
            size += record.getValue().rewind().limit();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        IsoTypeWriter.writeUInt32BE(byteBuffer, size);
        IsoTypeWriter.writeUInt16BE(byteBuffer, this.records.size());
        for (PlayReadyRecord record : this.records) {
            IsoTypeWriter.writeUInt16BE(byteBuffer, record.type);
            IsoTypeWriter.writeUInt16BE(byteBuffer, record.getValue().limit());
            ByteBuffer tmp4debug = record.getValue();
            byteBuffer.put(tmp4debug);
        }
        return byteBuffer;
    }

    public void setRecords(List<PlayReadyRecord> records) {
        this.records = records;
    }

    public List<PlayReadyRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PlayReadyHeader");
        sb.append("{length=").append(this.length);
        sb.append(", recordCount=").append(this.records.size());
        sb.append(", records=").append(this.records);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PlayReadyRecord {
        int type;

        public PlayReadyRecord(int type) {
            this.type = type;
        }

        public static List<PlayReadyRecord> createFor(ByteBuffer byteBuffer, int recordCount) {
            ArrayList<PlayReadyRecord> records = new ArrayList<PlayReadyRecord>(recordCount);
            int i = 0;
            while (i < recordCount) {
                PlayReadyRecord record;
                int type = IsoTypeReader.readUInt16BE(byteBuffer);
                int length = IsoTypeReader.readUInt16BE(byteBuffer);
                switch (type) {
                    case 1: {
                        record = new RMHeader();
                        break;
                    }
                    case 2: {
                        record = new DefaulPlayReadyRecord(2);
                        break;
                    }
                    case 3: {
                        record = new EmeddedLicenseStore();
                        break;
                    }
                    default: {
                        record = new DefaulPlayReadyRecord(type);
                    }
                }
                record.parse((ByteBuffer)byteBuffer.slice().limit(length));
                byteBuffer.position(byteBuffer.position() + length);
                records.add(record);
                ++i;
            }
            return records;
        }

        public abstract void parse(ByteBuffer var1);

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PlayReadyRecord");
            sb.append("{type=").append(this.type);
            sb.append(", length=").append(this.getValue().limit());
            sb.append('}');
            return sb.toString();
        }

        public abstract ByteBuffer getValue();

        public static class DefaulPlayReadyRecord
        extends PlayReadyRecord {
            ByteBuffer value;

            public DefaulPlayReadyRecord(int type) {
                super(type);
            }

            public void parse(ByteBuffer bytes) {
                this.value = bytes.duplicate();
            }

            public ByteBuffer getValue() {
                return this.value;
            }
        }

        public static class EmeddedLicenseStore
        extends PlayReadyRecord {
            ByteBuffer value;

            public EmeddedLicenseStore() {
                super(3);
            }

            public void parse(ByteBuffer bytes) {
                this.value = bytes.duplicate();
            }

            public ByteBuffer getValue() {
                return this.value;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("EmeddedLicenseStore");
                sb.append("{length=").append(this.getValue().limit());
                sb.append('}');
                return sb.toString();
            }
        }

        public static class RMHeader
        extends PlayReadyRecord {
            String header;

            public RMHeader() {
                super(1);
            }

            public void parse(ByteBuffer bytes) {
                try {
                    byte[] str = new byte[bytes.slice().limit()];
                    bytes.get(str);
                    this.header = new String(str, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            public ByteBuffer getValue() {
                byte[] headerBytes;
                try {
                    headerBytes = this.header.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                return ByteBuffer.wrap(headerBytes);
            }

            public void setHeader(String header) {
                this.header = header;
            }

            public String getHeader() {
                return this.header;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("RMHeader");
                sb.append("{length=").append(this.getValue().limit());
                sb.append(", header='").append(this.header).append('\'');
                sb.append('}');
                return sb.toString();
            }
        }
    }
}

