/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.cache;

import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.ForwardingTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapTemplateCache
implements TemplateCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<TemplateSource, Pair<TemplateSource, Template>> cache;

    protected ConcurrentMapTemplateCache(ConcurrentMap<TemplateSource, Pair<TemplateSource, Template>> cache) {
        this.cache = (ConcurrentMap)Validate.notNull(cache, (String)"The cache is required.", (Object[])new Object[0]);
    }

    public ConcurrentMapTemplateCache() {
        this(new ConcurrentHashMap<TemplateSource, Pair<TemplateSource, Template>>());
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void evict(TemplateSource source) {
        this.cache.remove(source);
    }

    @Override
    public Template get(final TemplateSource source, Parser parser) throws IOException {
        Validate.notNull((Object)source, (String)"The source is required.", (Object[])new Object[0]);
        Validate.notNull((Object)parser, (String)"The parser is required.", (Object[])new Object[0]);
        return this.cacheGet(new ForwardingTemplateSource(source){

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof TemplateSource) {
                    return source.filename().equals(((TemplateSource)obj).filename());
                }
                return false;
            }

            @Override
            public int hashCode() {
                return source.filename().hashCode();
            }
        }, parser);
    }

    private Template cacheGet(TemplateSource source, Parser parser) throws IOException {
        Pair entry = (Pair)this.cache.get(source);
        if (entry == null) {
            this.logger.debug("Loading: {}", (Object)source);
            entry = Pair.of((Object)source, (Object)parser.parse(source));
            this.cache.put(source, (Pair<TemplateSource, Template>)entry);
        } else if (source.lastModified() != ((TemplateSource)entry.getKey()).lastModified()) {
            this.evict(source);
            this.logger.debug("Reloading: {}", (Object)source);
            entry = Pair.of((Object)source, (Object)parser.parse(source));
            this.cache.put(source, (Pair<TemplateSource, Template>)entry);
        } else {
            this.logger.debug("Found in cache: {}", (Object)source);
        }
        return (Template)entry.getValue();
    }
}

