/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;

public class SolrCLI {
    public static Logger log = Logger.getLogger(SolrCLI.class);
    public static final String DEFAULT_SOLR_URL = "http://localhost:8983/solr";
    public static final String ZK_HOST = "localhost:9983";
    public static Option[] cloudOptions;
    private static final long MS_IN_MIN = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0 || args[0] == null || args[0].trim().length() == 0) {
            System.err.println("Invalid command-line args! Must pass the name of a tool to run.\nSupported tools:\n");
            SolrCLI.displayToolOptions(System.err);
            System.exit(1);
        }
        String toolType = args[0].trim().toLowerCase(Locale.ROOT);
        Tool tool = SolrCLI.newTool(toolType);
        String[] toolArgs = new String[args.length - 1];
        System.arraycopy(args, 1, toolArgs, 0, toolArgs.length);
        CommandLine cli = SolrCLI.processCommandLineArgs(SolrCLI.joinCommonAndToolOptions(tool.getOptions()), toolArgs);
        int exitCode = tool.runTool(cli);
        System.exit(exitCode);
    }

    public static Option[] getCommonToolOptions() {
        return new Option[0];
    }

    private static Tool newTool(String toolType) throws Exception {
        if ("healthcheck".equals(toolType)) {
            return new HealthcheckTool();
        }
        if ("status".equals(toolType)) {
            return new StatusTool();
        }
        if ("api".equals(toolType)) {
            return new ApiTool();
        }
        for (Class<Tool> next : SolrCLI.findToolClassesInPackage("org.apache.solr.util")) {
            Tool tool = next.newInstance();
            if (!toolType.equals(tool.getName())) continue;
            return tool;
        }
        throw new IllegalArgumentException(toolType + " not supported!");
    }

    private static void displayToolOptions(PrintStream out) throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("healthcheck", SolrCLI.getToolOptions(new HealthcheckTool()));
        formatter.printHelp("status", SolrCLI.getToolOptions(new StatusTool()));
        formatter.printHelp("api", SolrCLI.getToolOptions(new ApiTool()));
        List<Class<Tool>> toolClasses = SolrCLI.findToolClassesInPackage("org.apache.solr.util");
        for (Class<Tool> next : toolClasses) {
            Tool tool = next.newInstance();
            formatter.printHelp(tool.getName(), SolrCLI.getToolOptions(tool));
        }
    }

    private static Options getToolOptions(Tool tool) {
        Options options = new Options();
        options.addOption("h", "help", false, "Print this message");
        options.addOption("v", "verbose", false, "Generate verbose log messages");
        Option[] toolOpts = SolrCLI.joinCommonAndToolOptions(tool.getOptions());
        for (int i = 0; i < toolOpts.length; ++i) {
            options.addOption(toolOpts[i]);
        }
        return options;
    }

    public static Option[] joinCommonAndToolOptions(Option[] toolOpts) {
        return SolrCLI.joinOptions(SolrCLI.getCommonToolOptions(), toolOpts);
    }

    public static Option[] joinOptions(Option[] lhs, Option[] rhs) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (lhs != null && lhs.length > 0) {
            for (Option opt : lhs) {
                options.add(opt);
            }
        }
        if (rhs != null) {
            for (Option opt : rhs) {
                options.add(opt);
            }
        }
        return options.toArray(new Option[0]);
    }

    public static CommandLine processCommandLineArgs(Option[] customOptions, String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "Print this message");
        options.addOption("v", "verbose", false, "Generate verbose log messages");
        if (customOptions != null) {
            for (int i = 0; i < customOptions.length; ++i) {
                options.addOption(customOptions[i]);
            }
        }
        CommandLine cli = null;
        try {
            cli = new GnuParser().parse(options, args);
        }
        catch (ParseException exp) {
            boolean hasHelpArg = false;
            if (args != null && args.length > 0) {
                for (int z = 0; z < args.length; ++z) {
                    if (!"-h".equals(args[z]) && !"-help".equals(args[z])) continue;
                    hasHelpArg = true;
                    break;
                }
            }
            if (!hasHelpArg) {
                System.err.println("Failed to parse command-line arguments due to: " + exp.getMessage());
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SolrCLI.class.getName(), options);
            System.exit(1);
        }
        if (cli.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SolrCLI.class.getName(), options);
            System.exit(0);
        }
        return cli;
    }

    private static List<Class<Tool>> findToolClassesInPackage(String packageName) {
        ArrayList<Class<Tool>> toolClasses = new ArrayList<Class<Tool>>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            TreeSet<String> classes = new TreeSet<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                classes.addAll(SolrCLI.findClasses(resource.getFile(), packageName));
            }
            for (String classInPackage : classes) {
                Class<?> theClass = Class.forName(classInPackage);
                if (!Tool.class.isAssignableFrom(theClass)) continue;
                toolClasses.add(theClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toolClasses;
    }

    private static Set<String> findClasses(String path, String packageName) throws Exception {
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                classes.add(className);
            }
        }
        return classes;
    }

    public static boolean checkCommunicationError(Exception exc) {
        Throwable rootCause = SolrException.getRootCause((Throwable)exc);
        boolean wasCommError = rootCause instanceof ConnectException || rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof SocketException;
        return wasCommError;
    }

    public static HttpClient getHttpClient() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 128);
        params.set("maxConnectionsPerHost", 32);
        params.set("followRedirects", false);
        return HttpClientUtil.createClient((SolrParams)params);
    }

    public static void closeHttpClient(HttpClient httpClient) {
        if (httpClient != null) {
            try {
                httpClient.getConnectionManager().shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getJson(String getUrl) throws Exception {
        Map<String, Object> json = null;
        HttpClient httpClient = SolrCLI.getHttpClient();
        try {
            json = SolrCLI.getJson(httpClient, getUrl, 2);
        }
        finally {
            SolrCLI.closeHttpClient(httpClient);
        }
        return json;
    }

    public static Map<String, Object> getJson(HttpClient httpClient, String getUrl, int attempts) throws Exception {
        Map<String, Object> json = null;
        if (attempts >= 1) {
            try {
                json = SolrCLI.getJson(httpClient, getUrl);
            }
            catch (Exception exc) {
                if (--attempts > 0 && SolrCLI.checkCommunicationError(exc)) {
                    log.warn((Object)("Request to " + getUrl + " failed due to: " + exc.getMessage() + ", sleeping for 5 seconds before re-trying the request ..."));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    json = SolrCLI.getJson(httpClient, getUrl, attempts);
                }
                throw exc;
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getJson(HttpClient httpClient, String getUrl) throws Exception {
        Long status;
        Map json;
        block24: {
            json = null;
            URL url = new URL(getUrl);
            String queryString = url.getQuery();
            if (queryString != null) {
                if (queryString.indexOf("wt=json") == -1) {
                    getUrl = getUrl + "&wt=json";
                }
            } else {
                getUrl = getUrl + "?wt=json";
            }
            HttpGet httpget = new HttpGet(getUrl);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                StringBuilder body = new StringBuilder();
                if (entity != null) {
                    try (InputStream instream = entity.getContent();){
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            body.append(line);
                        }
                    }
                }
                throw new Exception("GET request [" + getUrl + "] failed due to: " + response.getStatusLine() + ": " + body);
            }
            if (entity != null) {
                try (InputStreamReader isr = null;){
                    isr = new InputStreamReader(entity.getContent(), "UTF-8");
                    Object resp = ObjectBuilder.getVal((JSONParser)new JSONParser((Reader)isr));
                    if (resp != null && resp instanceof Map) {
                        json = (Map)resp;
                        break block24;
                    }
                    throw new SolrServerException("Expected JSON object in response from " + getUrl + " but received " + resp);
                }
            }
        }
        int statusCode = -1;
        Map responseHeader = (Map)json.get("responseHeader");
        if (responseHeader != null && (status = (Long)responseHeader.get("status")) != null) {
            statusCode = status.intValue();
        }
        if (statusCode == -1) {
            throw new SolrServerException("Unable to determine outcome of GET request to: " + getUrl + "! Response: " + json);
        }
        if (statusCode != 0) {
            String errMsg = null;
            Map error = (Map)json.get("error");
            if (error != null) {
                errMsg = (String)error.get("msg");
            }
            if (errMsg == null) {
                errMsg = String.valueOf(json);
            }
            throw new SolrServerException("Request to " + getUrl + " failed due to: " + errMsg);
        }
        return json;
    }

    public static String asString(String jsonPath, Map<String, Object> json) {
        String str = null;
        Object obj = SolrCLI.atPath(jsonPath, json);
        if (obj != null) {
            if (obj instanceof String) {
                str = (String)obj;
            } else {
                throw new IllegalStateException("Expected a String at path " + jsonPath + " but found " + obj + " instead! " + json);
            }
        }
        return str;
    }

    public static Long asLong(String jsonPath, Map<String, Object> json) {
        Long num = null;
        Object obj = SolrCLI.atPath(jsonPath, json);
        if (obj != null) {
            if (obj instanceof Long) {
                num = (Long)obj;
            } else {
                throw new IllegalStateException("Expected a Long at path " + jsonPath + " but found " + obj + " instead! " + json);
            }
        }
        return num;
    }

    public static List<String> asList(String jsonPath, Map<String, Object> json) {
        List list = null;
        Object obj = SolrCLI.atPath(jsonPath, json);
        if (obj != null) {
            if (obj instanceof List) {
                list = (List)obj;
            } else {
                throw new IllegalStateException("Expected a List at path " + jsonPath + " but found " + obj + " instead! " + json);
            }
        }
        return list;
    }

    public static Map<String, Object> asMap(String jsonPath, Map<String, Object> json) {
        Map map = null;
        Object obj = SolrCLI.atPath(jsonPath, json);
        if (obj != null) {
            if (obj instanceof Map) {
                map = (Map)obj;
            } else {
                throw new IllegalStateException("Expected a Map at path " + jsonPath + " but found " + obj + " instead! " + json);
            }
        }
        return map;
    }

    public static Object atPath(String jsonPath, Map<String, Object> json) {
        Object child;
        if ("/".equals(jsonPath)) {
            return json;
        }
        if (!jsonPath.startsWith("/")) {
            throw new IllegalArgumentException("Invalid JSON path: " + jsonPath + "! Must start with a /");
        }
        Map parent = json;
        Object result = null;
        String[] path = jsonPath.split("/");
        for (int p = 1; p < path.length && (child = parent.get(path[p])) != null; ++p) {
            if (p == path.length - 1) {
                result = child;
                continue;
            }
            if (!(child instanceof Map)) break;
            parent = (Map)child;
        }
        return result;
    }

    private static final String uptime(long uptimeMs) {
        if (uptimeMs <= 0L) {
            return "?";
        }
        long numDays = uptimeMs >= 86400000L ? (long)Math.floor(uptimeMs / 86400000L) : 0L;
        long rem = uptimeMs - numDays * 86400000L;
        long numHours = rem >= 3600000L ? (long)Math.floor(rem / 3600000L) : 0L;
        long numMinutes = (rem -= numHours * 3600000L) >= 60000L ? (long)Math.floor(rem / 60000L) : 0L;
        long numSeconds = Math.round((rem -= numMinutes * 60000L) / 1000L);
        return String.format(Locale.ROOT, "%d days, %d hours, %d minutes, %d seconds", numDays, numHours, numMinutes, numSeconds);
    }

    static {
        Option[] optionArray = new Option[2];
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
        optionArray[0] = OptionBuilder.create((String)"zkHost");
        OptionBuilder.withArgName((String)"COLLECTION");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Name of collection; no default");
        optionArray[1] = OptionBuilder.create((String)"collection");
        cloudOptions = optionArray;
    }

    public static class HealthcheckTool
    extends SolrCloudTool {
        @Override
        public String getName() {
            return "healthcheck";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runCloudTool(CloudSolrServer cloudSolrServer, CommandLine cli) throws Exception {
            String collection = cli.getOptionValue("collection");
            if (collection == null) {
                throw new IllegalArgumentException("Must provide a collection to run a healthcheck against!");
            }
            log.info((Object)("Running healthcheck for " + collection));
            ZkStateReader zkStateReader = cloudSolrServer.getZkStateReader();
            Collection slices = zkStateReader.getClusterState().getSlices(collection);
            if (slices == null) {
                throw new IllegalArgumentException("Collection " + collection + " not found!");
            }
            SolrQuery q = new SolrQuery("*:*");
            q.setRows(Integer.valueOf(0));
            QueryResponse qr = cloudSolrServer.query((SolrParams)q);
            String collErr = null;
            long docCount = -1L;
            try {
                docCount = qr.getResults().getNumFound();
            }
            catch (Exception exc) {
                collErr = String.valueOf(exc);
            }
            ArrayList<Map<String, Object>> shardList = new ArrayList<Map<String, Object>>();
            boolean collectionIsHealthy = docCount != -1L;
            for (Slice slice : slices) {
                String shardName = slice.getName();
                String leaderUrl = null;
                try {
                    leaderUrl = zkStateReader.getLeaderUrl(collection, shardName, 1000);
                }
                catch (Exception exc) {
                    log.warn((Object)("Failed to get leader for shard " + shardName + " due to: " + exc));
                }
                ArrayList<ReplicaHealth> replicaList = new ArrayList<ReplicaHealth>();
                for (Replica r : slice.getReplicas()) {
                    String uptime = null;
                    String memory = null;
                    String replicaStatus = null;
                    long numDocs = -1L;
                    ZkCoreNodeProps replicaCoreProps = new ZkCoreNodeProps((ZkNodeProps)r);
                    String coreUrl = replicaCoreProps.getCoreUrl();
                    boolean isLeader = coreUrl.equals(leaderUrl);
                    HttpSolrServer solr = new HttpSolrServer(coreUrl);
                    String solrUrl = solr.getBaseURL();
                    q = new SolrQuery("*:*");
                    q.setRows(Integer.valueOf(0));
                    q.set("distrib", new String[]{"false"});
                    try {
                        qr = solr.query((SolrParams)q);
                        numDocs = qr.getResults().getNumFound();
                        int lastSlash = solrUrl.lastIndexOf(47);
                        String systemInfoUrl = solrUrl.substring(0, lastSlash) + "/admin/info/system";
                        Map<String, Object> info = SolrCLI.getJson(solr.getHttpClient(), systemInfoUrl, 2);
                        uptime = SolrCLI.uptime(SolrCLI.asLong("/jvm/jmx/upTimeMS", info));
                        String usedMemory = SolrCLI.asString("/jvm/memory/used", info);
                        String totalMemory = SolrCLI.asString("/jvm/memory/total", info);
                        memory = usedMemory + " of " + totalMemory;
                        replicaStatus = replicaCoreProps.getState();
                    }
                    catch (Exception exc) {
                        log.error((Object)("ERROR: " + exc + " when trying to reach: " + solrUrl));
                        replicaStatus = SolrCLI.checkCommunicationError(exc) ? "down" : "error: " + exc;
                    }
                    finally {
                        solr.shutdown();
                    }
                    replicaList.add(new ReplicaHealth(shardName, r.getName(), coreUrl, replicaStatus, numDocs, isLeader, uptime, memory));
                }
                ShardHealth shardHealth = new ShardHealth(shardName, replicaList);
                if (ShardState.healthy != shardHealth.getShardState()) {
                    collectionIsHealthy = false;
                }
                shardList.add(shardHealth.asMap());
            }
            LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
            report.put("collection", collection);
            report.put("status", collectionIsHealthy ? "healthy" : "degraded");
            if (collErr != null) {
                report.put("error", collErr);
            }
            report.put("numDocs", docCount);
            report.put("numShards", slices.size());
            report.put("shards", shardList);
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(report);
            System.out.println(arr.toString());
        }
    }

    static class ShardHealth {
        String shard;
        List<ReplicaHealth> replicas;

        ShardHealth(String shard, List<ReplicaHealth> replicas) {
            this.shard = shard;
            this.replicas = replicas;
        }

        public ShardState getShardState() {
            boolean healthy = true;
            boolean hasLeader = false;
            boolean atLeastOneActive = false;
            for (ReplicaHealth replicaHealth : this.replicas) {
                if (replicaHealth.isLeader) {
                    hasLeader = true;
                }
                if (!"active".equals(replicaHealth.status)) {
                    healthy = false;
                    continue;
                }
                atLeastOneActive = true;
            }
            if (!hasLeader) {
                return ShardState.no_leader;
            }
            return healthy ? ShardState.healthy : (atLeastOneActive ? ShardState.degraded : ShardState.down);
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("shard", this.shard);
            map.put("status", this.getShardState().toString());
            ArrayList<Map<String, Object>> replicaList = new ArrayList<Map<String, Object>>();
            for (ReplicaHealth replica : this.replicas) {
                replicaList.add(replica.asMap());
            }
            map.put("replicas", replicaList);
            return map;
        }

        public String toString() {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.asMap());
            return arr.toString();
        }
    }

    static enum ShardState {
        healthy,
        degraded,
        down,
        no_leader;

    }

    static class ReplicaHealth
    implements Comparable<ReplicaHealth> {
        String shard;
        String name;
        String url;
        String status;
        long numDocs;
        boolean isLeader;
        String uptime;
        String memory;

        ReplicaHealth(String shard, String name, String url, String status, long numDocs, boolean isLeader, String uptime, String memory) {
            this.shard = shard;
            this.name = name;
            this.url = url;
            this.numDocs = numDocs;
            this.status = status;
            this.isLeader = isLeader;
            this.uptime = uptime;
            this.memory = memory;
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("url", this.url);
            map.put("numDocs", this.numDocs);
            map.put("status", this.status);
            if (this.uptime != null) {
                map.put("uptime", this.uptime);
            }
            if (this.memory != null) {
                map.put("memory", this.memory);
            }
            if (this.isLeader) {
                map.put("leader", true);
            }
            return map;
        }

        public String toString() {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.asMap());
            return arr.toString();
        }

        public int hashCode() {
            return this.shard.hashCode() + (this.isLeader ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReplicaHealth)) {
                return true;
            }
            ReplicaHealth that = (ReplicaHealth)obj;
            return this.shard.equals(that.shard) && this.isLeader == that.isLeader;
        }

        @Override
        public int compareTo(ReplicaHealth other) {
            int otherShardIndex;
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return 1;
            }
            int myShardIndex = Integer.parseInt(this.shard.substring("shard".length()));
            if (myShardIndex == (otherShardIndex = Integer.parseInt(other.shard.substring("shard".length())))) {
                return this.isLeader ? -1 : 1;
            }
            return myShardIndex - otherShardIndex;
        }
    }

    public static class ApiTool
    implements Tool {
        @Override
        public String getName() {
            return "api";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[1];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Send a GET request to a Solr API endpoint");
            optionArray[0] = OptionBuilder.create((String)"get");
            return optionArray;
        }

        @Override
        public int runTool(CommandLine cli) throws Exception {
            String getUrl = cli.getOptionValue("get");
            if (getUrl != null) {
                Map<String, Object> json = SolrCLI.getJson(getUrl);
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                System.out.println(arr.toString());
            }
            return 0;
        }
    }

    public static class StatusTool
    implements Tool {
        @Override
        public String getName() {
            return "status";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[1];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Address of the Solr Web application, defaults to: http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solr");
            return optionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runTool(CommandLine cli) throws Exception {
            String solrUrl = cli.getOptionValue("solr", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            int exitCode = 0;
            String systemInfoUrl = solrUrl + "admin/info/system";
            HttpClient httpClient = SolrCLI.getHttpClient();
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson(httpClient, systemInfoUrl, 2);
                Map<String, Object> status = this.reportStatus(solrUrl, systemInfo, httpClient);
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(status);
                System.out.println(arr.toString());
            }
            catch (Exception exc) {
                if (SolrCLI.checkCommunicationError(exc)) {
                    System.err.println("Solr at " + solrUrl + " not online.");
                } else {
                    System.err.print("Failed to get system information from " + solrUrl + " due to: ");
                    exc.printStackTrace(System.err);
                    exitCode = 1;
                }
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            return exitCode;
        }

        protected Map<String, Object> reportStatus(String solrUrl, Map<String, Object> info, HttpClient httpClient) throws Exception {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            status.put("version", SolrCLI.asString("/lucene/solr-impl-version", info));
            status.put("startTime", SolrCLI.asString("/jvm/jmx/startTime", info));
            status.put("uptime", SolrCLI.uptime(SolrCLI.asLong("/jvm/jmx/upTimeMS", info)));
            String usedMemory = SolrCLI.asString("/jvm/memory/used", info);
            String totalMemory = SolrCLI.asString("/jvm/memory/total", info);
            status.put("memory", usedMemory + " of " + totalMemory);
            if ("solrcloud".equals(info.get("mode"))) {
                String zkHost = null;
                List<String> args = SolrCLI.asList("/jvm/jmx/commandLineArgs", info);
                if (args != null) {
                    for (String arg : args) {
                        if (arg.startsWith("-DzkHost=")) {
                            zkHost = arg.substring("-DzkHost=".length());
                            break;
                        }
                        if (!arg.startsWith("-DzkRun")) continue;
                        URL serverUrl = new URL(solrUrl);
                        String host = serverUrl.getHost();
                        int port = serverUrl.getPort();
                        zkHost = host + ":" + (port + 1000) + " (embedded)";
                        break;
                    }
                }
                status.put("cloud", this.getCloudStatus(httpClient, solrUrl, zkHost));
            }
            return status;
        }

        protected Map<String, String> getCloudStatus(HttpClient httpClient, String solrUrl, String zkHost) throws Exception {
            LinkedHashMap<String, String> cloudStatus = new LinkedHashMap<String, String>();
            cloudStatus.put("ZooKeeper", zkHost != null ? zkHost : "?");
            String clusterStatusUrl = solrUrl + "admin/collections?action=CLUSTERSTATUS";
            Map<String, Object> json = SolrCLI.getJson(httpClient, clusterStatusUrl, 2);
            List<String> liveNodes = SolrCLI.asList("/cluster/live_nodes", json);
            cloudStatus.put("liveNodes", String.valueOf(liveNodes.size()));
            Map<String, Object> collections = SolrCLI.asMap("/cluster/collections", json);
            cloudStatus.put("collections", String.valueOf(collections.size()));
            return cloudStatus;
        }
    }

    public static abstract class SolrCloudTool
    implements Tool {
        @Override
        public Option[] getOptions() {
            return cloudOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runTool(CommandLine cli) throws Exception {
            LogManager.getLogger((String)"org.apache.zookeeper").setLevel(Level.ERROR);
            LogManager.getLogger((String)"org.apache.solr.common.cloud").setLevel(Level.WARN);
            String zkHost = cli.getOptionValue("zkHost", SolrCLI.ZK_HOST);
            log.debug((Object)("Connecting to Solr cluster: " + zkHost));
            CloudSolrServer cloudSolrServer = null;
            try {
                cloudSolrServer = new CloudSolrServer(zkHost);
                String collection = cli.getOptionValue("collection");
                if (collection != null) {
                    cloudSolrServer.setDefaultCollection(collection);
                }
                cloudSolrServer.connect();
                this.runCloudTool(cloudSolrServer, cli);
            }
            finally {
                if (cloudSolrServer != null) {
                    try {
                        cloudSolrServer.shutdown();
                    }
                    catch (Exception ignore) {}
                }
            }
            return 0;
        }

        protected abstract void runCloudTool(CloudSolrServer var1, CommandLine var2) throws Exception;
    }

    public static interface Tool {
        public String getName();

        public Option[] getOptions();

        public int runTool(CommandLine var1) throws Exception;
    }
}

